/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.task;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.core.internal.JaggeryCoreServiceComponent;
import org.jaggeryjs.jaggery.core.task.JaggeryTaskInfo;
import org.jaggeryjs.jaggery.core.task.JaggeryTaskUtils;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskManager;

public class JaggeryTaskAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(JaggeryTaskAdmin.class);

    public String[] getAllTaskNames() throws TaskException {
        try {
            TaskManager taskManager = JaggeryCoreServiceComponent.getTaskService().getTaskManager("JAGGERY_TASK");
            List taskInfoList = taskManager.getAllTasks();
            ArrayList<String> result = new ArrayList<String>();
            for (TaskInfo taskInfo : taskInfoList) {
                result.add(taskInfo.getName());
            }
            return result.toArray(new String[result.size()]);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new TaskException("Error in retrieving task names: " + e.getMessage(), TaskException.Code.CONFIG_ERROR);
        }
    }

    public JaggeryTaskInfo getTaskInfo(String taskName) throws TaskException {
        try {
            TaskManager taskManager = JaggeryCoreServiceComponent.getTaskService().getTaskManager("JAGGERY_TASK");
            return JaggeryTaskUtils.convert(taskManager.getTask(taskName));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new TaskException("Error getting task info for task: " + taskName, TaskException.Code.CONFIG_ERROR);
        }
    }

    public void scheduleTask(JaggeryTaskInfo jaggeryTaskInfo) throws TaskException {
        TaskManager taskManager = null;
        try {
            taskManager = JaggeryCoreServiceComponent.getTaskService().getTaskManager("JAGGERY_TASK");
            TaskInfo taskInfo = JaggeryTaskUtils.convert(jaggeryTaskInfo);
            taskManager.registerTask(taskInfo);
            taskManager.scheduleTask(taskInfo.getName());
        }
        catch (Exception e) {
            log.error((Object)e);
            if (taskManager != null) {
                try {
                    taskManager.deleteTask(jaggeryTaskInfo.getName());
                }
                catch (TaskException e1) {
                    log.error((Object)e1);
                }
            }
            throw new TaskException("Error scheduling task: " + jaggeryTaskInfo.getName(), TaskException.Code.CONFIG_ERROR);
        }
    }

    public boolean rescheduleTask(JaggeryTaskInfo jaggeryTaskInfo) throws TaskException {
        try {
            TaskManager taskManager = JaggeryCoreServiceComponent.getTaskService().getTaskManager("JAGGERY_TASK");
            TaskInfo taskInfo = JaggeryTaskUtils.convert(jaggeryTaskInfo);
            taskManager.registerTask(taskInfo);
            taskManager.rescheduleTask(taskInfo.getName());
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new TaskException("Error rescheduling task: " + jaggeryTaskInfo.getName(), TaskException.Code.CONFIG_ERROR);
        }
        return true;
    }

    public void deleteAllTasks() throws TaskException {
        String[] allTaks;
        for (String taskName : allTaks = this.getAllTaskNames()) {
            this.deleteTask(taskName);
        }
    }

    public void deleteTask(String taskName) throws TaskException {
        try {
            TaskManager taskManager = JaggeryCoreServiceComponent.getTaskService().getTaskManager("JAGGERY_TASK");
            taskManager.deleteTask(taskName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new TaskException("Error deleting task: " + taskName, TaskException.Code.CONFIG_ERROR);
        }
    }

    public boolean isTaskScheduled(String taskName) throws TaskException {
        try {
            TaskManager taskManager = JaggeryCoreServiceComponent.getTaskService().getTaskManager("JAGGERY_TASK");
            return taskManager.isTaskScheduled(taskName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new TaskException("Error checking task scheduled status: " + taskName, TaskException.Code.CONFIG_ERROR);
        }
    }
}

