/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.activation.FileTypeMap;
import javax.servlet.ServletContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.JavaScriptFile;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManager;
import org.jaggeryjs.jaggery.core.plugins.WebAppFile;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;

public class UploadedFile
implements JavaScriptFile {
    private static final Log log = LogFactory.getLog(WebAppFile.class);
    private ServletContext context = null;
    private FileItem fileItem = null;
    private String path = null;
    private boolean opened = false;
    private JavaScriptFileManager fileManager = null;
    private boolean readable = false;
    private boolean writable = false;

    public UploadedFile(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    public void construct() throws ScriptException {
    }

    public void open(String mode) throws ScriptException {
        if (!"r".equals(mode)) {
            String msg = "Invalid or unsupported file mode, path : " + this.path + ", mode : " + mode;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        this.readable = true;
        this.opened = true;
    }

    public void close() throws ScriptException {
        if (!this.opened) {
            return;
        }
        try {
            this.fileItem.getInputStream().close();
            this.opened = false;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public String read(long count) throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for reading");
            return null;
        }
        if (!this.readable) {
            log.warn((Object)"File has not opened in a readable mode.");
            return null;
        }
        try {
            InputStream inputStream = this.fileItem.getInputStream();
            StringBuilder buffer = new StringBuilder();
            int size = 1024;
            byte[] bytes = new byte[size];
            while (inputStream.read(bytes) != -1) {
                buffer.append(new String(bytes));
                if ((count -= (long)size) >= (long)size) continue;
                bytes = new byte[(int)count];
                buffer.append(new String(bytes));
                break;
            }
            return buffer.toString();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public void write(String data) throws ScriptException {
        log.warn((Object)("write() method is not available for uploaded files. Field name : " + this.fileItem.getFieldName() + ", File name : " + this.getName()));
    }

    public String readAll() throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for reading");
            return null;
        }
        if (!this.readable) {
            log.warn((Object)"File has not opened in a readable mode.");
            return null;
        }
        try {
            return HostObjectUtil.streamToString((InputStream)this.fileItem.getInputStream());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public boolean move(String dest) throws ScriptException {
        if (this.opened) {
            log.warn((Object)"Please close the file before moving");
            return false;
        }
        try {
            InputStream inputStream = this.fileItem.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(this.fileManager.getFile(dest));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
            inputStream.close();
            outputStream.flush();
            outputStream.close();
            return true;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public boolean del() throws ScriptException {
        return false;
    }

    public long getLength() throws ScriptException {
        return this.fileItem.getSize();
    }

    public long getLastModified() throws ScriptException {
        return new File(this.path).lastModified();
    }

    public String getName() throws ScriptException {
        return this.fileItem.getName();
    }

    public boolean isExist() throws ScriptException {
        return new File(this.path).exists();
    }

    public InputStream getInputStream() throws ScriptException {
        try {
            return this.fileItem.getInputStream();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public OutputStream getOutputStream() throws ScriptException {
        return null;
    }

    public String getContentType() throws ScriptException {
        return FileTypeMap.getDefaultFileTypeMap().getContentType(this.getName());
    }

    public boolean saveAs(String dest) throws ScriptException {
        return this.move(dest);
    }

    public boolean isDirectory() throws ScriptException {
        return false;
    }

    public ArrayList<String> listFiles() throws ScriptException {
        return null;
    }

    public void setFileManager(JavaScriptFileManager fileManager) {
        this.fileManager = fileManager;
    }
}

