/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Stack;
import javax.activation.FileTypeMap;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.JavaScriptFile;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManager;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.jaggery.core.manager.WebAppContext;
import org.jaggeryjs.jaggery.core.manager.WebAppManager;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;

public class WebAppFile
implements JavaScriptFile {
    private static final Log log = LogFactory.getLog(WebAppFile.class);
    private ServletContext context = null;
    private RandomAccessFile file = null;
    private String path = null;
    private boolean opened = false;
    private JavaScriptFileManager fileManager = null;
    private boolean readable = false;
    private boolean writable = false;

    public WebAppFile(String path, ServletContext context) throws ScriptException {
        this.path = context.getRealPath(this.getFilePath(path));
        this.context = context;
    }

    public void construct() throws ScriptException {
    }

    private String getFilePath(String fileURL) throws ScriptException {
        WebAppContext webAppContext = (WebAppContext)CommonManager.getJaggeryContext();
        Stack<String> includesCallstack = CommonManager.getJaggeryContext().getIncludesCallstack();
        ServletContext context = webAppContext.getServletConext();
        String parent = (String)includesCallstack.lastElement();
        try {
            String[] keys = WebAppManager.getKeys(context.getContextPath(), parent, fileURL);
            fileURL = "/".equals(keys[1]) ? keys[2] : keys[1] + keys[2];
        }
        catch (NullPointerException ne) {
            throw new ScriptException("Invalid file path : " + fileURL, (Exception)ne);
        }
        return fileURL;
    }

    public void open(String mode) throws ScriptException {
        if ("r".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.path, "r");
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.readable = true;
        } else if ("r+".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.path, "rw");
                this.file.seek(0L);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.readable = true;
            this.writable = true;
        } else if ("w".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.path, "rw");
                this.file.setLength(0L);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.writable = true;
        } else if ("w+".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.path, "rw");
                this.file.setLength(0L);
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.readable = true;
            this.writable = true;
        } else if ("a".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.path, "rw");
                this.file.seek(this.file.length());
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.writable = true;
        } else if ("a+".equals(mode)) {
            try {
                this.file = new RandomAccessFile(this.path, "rw");
                this.file.seek(this.file.length());
            }
            catch (FileNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
            this.readable = true;
            this.writable = true;
        } else {
            String msg = "Invalid or unsupported file mode, path : " + this.path + ", mode : " + mode;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        this.opened = true;
    }

    public void close() throws ScriptException {
        if (!this.opened) {
            return;
        }
        try {
            this.file.close();
            this.opened = false;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public String read(long count) throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for reading");
            return null;
        }
        if (!this.readable) {
            log.warn((Object)"File has not opened in a readable mode.");
            return null;
        }
        try {
            StringBuffer buffer = new StringBuffer();
            long length = this.file.length();
            for (long i = 0L; i < count && i < length; ++i) {
                buffer.append((char)this.file.readByte());
            }
            return buffer.toString();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public void write(String data) throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for writing");
            return;
        }
        if (!this.writable) {
            log.warn((Object)"File has not opened in a writable mode.");
            return;
        }
        try {
            this.file.writeBytes(data);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public String readAll() throws ScriptException {
        if (!this.opened) {
            log.warn((Object)"You need to open the file for reading");
            return null;
        }
        if (!this.readable) {
            log.warn((Object)"File has not opened in a readable mode.");
            return null;
        }
        try {
            long pointer = this.file.getFilePointer();
            this.file.seek(0L);
            String data = this.read(this.file.length());
            this.file.seek(pointer);
            return data;
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public boolean move(String dest) throws ScriptException {
        if (this.opened) {
            log.warn((Object)"Please close the file before moving");
            return false;
        }
        return new File(this.path).renameTo(this.fileManager.getFile(this.path));
    }

    public boolean del() throws ScriptException {
        if (this.opened) {
            log.warn((Object)"Please close the file before deleting");
            return false;
        }
        return new File(this.path).delete();
    }

    public long getLength() throws ScriptException {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public long getLastModified() throws ScriptException {
        return new File(this.path).lastModified();
    }

    public String getName() throws ScriptException {
        return new File(this.path).getName();
    }

    public boolean isExist() throws ScriptException {
        return new File(this.path).exists();
    }

    public InputStream getInputStream() throws ScriptException {
        try {
            return new FileInputStream(this.file.getFD());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public OutputStream getOutputStream() throws ScriptException {
        try {
            return new FileOutputStream(this.file.getFD());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public String getContentType() throws ScriptException {
        return FileTypeMap.getDefaultFileTypeMap().getContentType(this.getName());
    }

    public boolean saveAs(String dest) throws ScriptException {
        return this.move(dest);
    }

    public void setFileManager(JavaScriptFileManager fileManager) {
        this.fileManager = fileManager;
    }
}

