/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.manager;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.core.ScriptReader;
import org.jaggeryjs.jaggery.core.manager.CommonManager;
import org.jaggeryjs.jaggery.core.manager.JaggeryContext;
import org.jaggeryjs.jaggery.core.manager.JaggerySecurityDomain;
import org.jaggeryjs.jaggery.core.manager.WebAppContext;
import org.jaggeryjs.jaggery.core.plugins.WebAppFileManager;
import org.jaggeryjs.scriptengine.cache.ScriptCachingContext;
import org.jaggeryjs.scriptengine.engine.JavaScriptProperty;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityController;
import org.jaggeryjs.scriptengine.security.RhinoSecurityDomain;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.carbon.context.CarbonContext;

public class WebAppManager {
    private static final Log log = LogFactory.getLog(WebAppManager.class);
    public static final String CORE_MODULE_NAME = "core";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    public static final String JAGGERY_MODULES_DIR = "modules";

    public static void include(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "include";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"RhinoTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)"RhinoTopLevel", (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        Stack<String> includesCallstack = jaggeryContext.getIncludesCallstack();
        String parent = (String)includesCallstack.lastElement();
        String fileURL = (String)args[0];
        if (CommonManager.isHTTP(fileURL) || CommonManager.isHTTP(parent)) {
            CommonManager.include(cx, thisObj, args, funObj);
            return;
        }
        WebAppManager.executeScript(jaggeryContext, jaggeryContext.getScope(), fileURL, false, false, false);
    }

    public static void include_once(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "include_once";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"RhinoTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)"RhinoTopLevel", (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        Stack<String> includesCallstack = jaggeryContext.getIncludesCallstack();
        String parent = (String)includesCallstack.lastElement();
        String fileURL = (String)args[0];
        if (CommonManager.isHTTP(fileURL) || CommonManager.isHTTP(parent)) {
            CommonManager.include_once(cx, thisObj, args, funObj);
            return;
        }
        WebAppManager.executeScript(jaggeryContext, jaggeryContext.getScope(), fileURL, false, false, true);
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        if (((WebAppContext)jaggeryContext).getServletResponse().getContentType() == null) {
            ((WebAppContext)CommonManager.getJaggeryContext()).getServletResponse().setContentType(DEFAULT_CONTENT_TYPE);
        }
        CommonManager.print(cx, thisObj, args, funObj);
    }

    private static ScriptableObject executeScript(JaggeryContext jaggeryContext, ScriptableObject scope, String fileURL, final boolean isJSON, boolean isBuilt, boolean isIncludeOnce) throws ScriptException {
        WebAppContext webAppContext = (WebAppContext)jaggeryContext;
        Stack<String> includesCallstack = jaggeryContext.getIncludesCallstack();
        Map<String, Boolean> includedScripts = jaggeryContext.getIncludedScripts();
        ServletContext context = webAppContext.getServletConext();
        String parent = (String)includesCallstack.lastElement();
        String[] keys = WebAppManager.getKeys(context.getContextPath(), parent, fileURL);
        fileURL = WebAppManager.getNormalizedScriptPath(keys);
        if (includesCallstack.search(fileURL) != -1) {
            return scope;
        }
        if (isIncludeOnce && includedScripts.get(fileURL) != null) {
            return scope;
        }
        RhinoEngine engine = jaggeryContext.getEngine();
        ScriptReader source = isBuilt ? new ScriptReader(context.getResourceAsStream(fileURL)){

            @Override
            protected void build() throws IOException {
                try {
                    this.sourceReader = isJSON ? new StringReader("(" + HostObjectUtil.streamToString((InputStream)this.sourceIn) + ")") : new StringReader(HostObjectUtil.streamToString((InputStream)this.sourceIn));
                }
                catch (ScriptException e) {
                    throw new IOException(e);
                }
            }
        } : new ScriptReader(context.getResourceAsStream(fileURL));
        ScriptCachingContext sctx = new ScriptCachingContext(webAppContext.getTenantId(), keys[0], keys[1], keys[2]);
        sctx.setSecurityDomain((RhinoSecurityDomain)new JaggerySecurityDomain(fileURL, context));
        long lastModified = WebAppManager.getScriptLastModified(context, fileURL);
        sctx.setSourceModifiedTime(lastModified);
        includedScripts.put(fileURL, true);
        includesCallstack.push(fileURL);
        if (isJSON) {
            scope = (ScriptableObject)engine.eval((Reader)source, scope, sctx);
        } else {
            engine.exec((Reader)source, scope, sctx);
        }
        includesCallstack.pop();
        return scope;
    }

    private static String getNormalizedScriptPath(String[] keys) {
        return "/".equals(keys[1]) ? keys[2] : keys[1] + keys[2];
    }

    public static ScriptableObject require(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException, IOException {
        String functionName = "require";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)"RhinoTopLevel", (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)"RhinoTopLevel", (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        String param = (String)args[0];
        int dotIndex = param.lastIndexOf(".");
        if (param.length() == dotIndex + 1) {
            String msg = "Invalid file path for require method : " + param;
            log.error((Object)msg);
            throw new ScriptException(msg);
        }
        if (dotIndex == -1) {
            ScriptableObject object = CommonManager.require(cx, thisObj, args, funObj);
            WebAppManager.initModule(cx, CommonManager.getJaggeryContext(), param, object);
            return object;
        }
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        ScriptableObject object = (ScriptableObject)cx.newObject(thisObj);
        object.setPrototype(thisObj);
        object.setParentScope(null);
        String ext = param.substring(dotIndex + 1);
        if (ext.equalsIgnoreCase("json")) {
            return WebAppManager.executeScript(jaggeryContext, object, param, true, true, false);
        }
        if (ext.equalsIgnoreCase("js")) {
            return WebAppManager.executeScript(jaggeryContext, object, param, false, true, false);
        }
        if (ext.equalsIgnoreCase("jag")) {
            return WebAppManager.executeScript(jaggeryContext, object, param, false, false, false);
        }
        String msg = "Unsupported file type for require() method : ." + ext;
        log.error((Object)msg);
        throw new ScriptException(msg);
    }

    public static void initContext(Context cx, JaggeryContext context) throws ScriptException {
        CommonManager.initContext(context);
        WebAppManager.defineProperties(cx, context, context.getScope());
    }

    public static void initModule(Context cx, JaggeryContext context, String module, ScriptableObject object) {
        if (CORE_MODULE_NAME.equals(module)) {
            WebAppManager.defineProperties(cx, context, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String scriptPath = WebAppManager.getScriptPath(request);
        InputStream sourceIn = request.getServletContext().getResourceAsStream(scriptPath);
        if (sourceIn == null) {
            response.sendError(404, request.getRequestURI());
            return;
        }
        RhinoEngine engine = null;
        try {
            engine = CommonManager.getInstance().getEngine();
            Context cx = engine.enterContext();
            ServletOutputStream out = response.getOutputStream();
            JaggeryContext webAppContext = WebAppManager.createJaggeryContext((OutputStream)out, scriptPath, request, response);
            WebAppManager.initContext(cx, webAppContext);
            RhinoEngine.putContextProperty((Object)"hostobjects.file.filemanager", (Object)new WebAppFileManager(request.getServletContext()));
            CommonManager.getInstance().getEngine().exec((Reader)new ScriptReader(sourceIn), webAppContext.getScope(), WebAppManager.getScriptCachingContext(request, scriptPath));
            out.flush();
        }
        catch (ScriptException e) {
            String msg = e.getMessage();
            log.error((Object)msg, (Throwable)e);
            response.sendError(500, msg);
        }
        finally {
            if (engine != null) {
                engine.exitContext();
            }
        }
    }

    public static String getScriptPath(HttpServletRequest request) {
        Map urlMappings;
        String url = request.getServletPath();
        if (request.getPathInfo() != null) {
            url = url + "/*";
        }
        if ((urlMappings = (Map)request.getServletContext().getAttribute("jaggery.urls.map")) == null) {
            return url;
        }
        if (url.equals("/")) {
            Object obj = urlMappings.get("/");
            return obj != null ? (String)obj : url;
        }
        String tmpUrl = url.startsWith("/") ? url.substring(1) : url;
        String path = WebAppManager.resolveScriptPath(new ArrayList<String>(Arrays.asList(tmpUrl.split("/"))), urlMappings);
        return path == null ? url : path;
    }

    private static String resolveScriptPath(List<String> parts, Map<String, Object> map) {
        String part = parts.remove(0);
        if (parts.isEmpty()) {
            Object obj = map.get(part);
            if (obj instanceof Map) {
                return (String)((Map)obj).get("/");
            }
            return (String)obj;
        }
        Object obj = map.get(part);
        if (obj instanceof Map) {
            return WebAppManager.resolveScriptPath(parts, (Map)obj);
        }
        return (String)map.get("*");
    }

    private static void defineProperties(Context cx, JaggeryContext context, ScriptableObject scope) {
        WebAppContext ctx = (WebAppContext)context;
        JavaScriptProperty request = new JavaScriptProperty("request");
        request.setValue((Object)cx.newObject((Scriptable)scope, "Request", new Object[]{ctx.getServletRequest()}));
        request.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)request);
        JavaScriptProperty response = new JavaScriptProperty("response");
        response.setValue((Object)cx.newObject((Scriptable)scope, "Response", new Object[]{ctx.getServletResponse()}));
        response.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)response);
        JavaScriptProperty session = new JavaScriptProperty("session");
        session.setValue((Object)cx.newObject((Scriptable)scope, "Session", new Object[]{ctx.getServletRequest().getSession()}));
        session.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)session);
        JavaScriptProperty application = new JavaScriptProperty("application");
        application.setValue((Object)cx.newObject((Scriptable)scope, "Application", new Object[]{ctx.getServletConext()}));
        application.setAttribute(1);
        RhinoEngine.defineProperty((ScriptableObject)scope, (JavaScriptProperty)application);
    }

    private static JaggeryContext createJaggeryContext(OutputStream out, String scriptPath, HttpServletRequest request, HttpServletResponse response) {
        WebAppContext context = new WebAppContext();
        context.setTenantId(Integer.toString(CarbonContext.getCurrentContext().getTenantId()));
        context.setOutputStream(out);
        context.setServletRequest(request);
        context.setServletResponse(response);
        context.setServletConext(request.getServletContext());
        context.setScriptPath(scriptPath);
        context.getIncludesCallstack().push(scriptPath);
        context.getIncludedScripts().put(scriptPath, true);
        return context;
    }

    protected static ScriptCachingContext getScriptCachingContext(HttpServletRequest request, String scriptPath) throws ScriptException {
        JaggeryContext jaggeryContext = CommonManager.getJaggeryContext();
        String tenantId = jaggeryContext.getTenantId();
        String[] parts = WebAppManager.getKeys(request.getContextPath(), scriptPath, scriptPath);
        ScriptCachingContext sctx = new ScriptCachingContext(tenantId, parts[0], parts[1], parts[2]);
        ServletContext servletContext = request.getServletContext();
        sctx.setSecurityDomain((RhinoSecurityDomain)new JaggerySecurityDomain(WebAppManager.getNormalizedScriptPath(parts), servletContext));
        long lastModified = WebAppManager.getScriptLastModified(servletContext, scriptPath);
        sctx.setSourceModifiedTime(lastModified);
        return sctx;
    }

    public static String[] getKeys(String context, String parent, String scriptPath) {
        context = context.equals("") ? "/" : context;
        String normalizedScriptPath = scriptPath.startsWith("/") ? FilenameUtils.normalize((String)scriptPath, (boolean)true) : FilenameUtils.normalize((String)(FilenameUtils.getFullPath((String)parent) + scriptPath), (boolean)true);
        String path = FilenameUtils.getFullPath((String)normalizedScriptPath);
        path = path.equals("/") ? path : path.substring(0, path.length() - 1);
        normalizedScriptPath = "/" + FilenameUtils.getName((String)normalizedScriptPath);
        return new String[]{context, path, normalizedScriptPath};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getScriptLastModified(ServletContext context, String scriptPath) throws ScriptException {
        long result = -1L;
        URLConnection uc = null;
        try {
            URL scriptUrl = context.getResource(WebAppManager.canonicalURI(scriptPath));
            if (scriptUrl == null) {
                String msg = "Requested resource " + scriptPath + " cannot be found";
                log.error((Object)msg);
                throw new ScriptException(msg);
            }
            uc = scriptUrl.openConnection();
            result = uc instanceof JarURLConnection ? ((JarURLConnection)uc).getJarEntry().getTime() : uc.getLastModified();
        }
        catch (IOException e) {
            log.warn((Object)("Error getting last modified time for " + scriptPath), (Throwable)e);
            result = -1L;
        }
        finally {
            if (uc != null) {
                try {
                    uc.getInputStream().close();
                }
                catch (IOException e) {
                    log.error((Object)("Error closing input stream for script " + scriptPath), (Throwable)e);
                }
            }
        }
        return result;
    }

    private static String canonicalURI(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int len = s.length();
        int pos = 0;
        block4: while (pos < len) {
            char c = s.charAt(pos);
            if (WebAppManager.isPathSeparator(c)) {
                while (pos + 1 < len && WebAppManager.isPathSeparator(s.charAt(pos + 1))) {
                    ++pos;
                }
                if (pos + 1 < len && s.charAt(pos + 1) == '.') {
                    if (pos + 2 >= len) break;
                    switch (s.charAt(pos + 2)) {
                        case '/': 
                        case '\\': {
                            pos += 2;
                            continue block4;
                        }
                        case '.': {
                            int separatorPos;
                            if (pos + 3 >= len || !WebAppManager.isPathSeparator(s.charAt(pos + 3))) break;
                            pos += 3;
                            for (separatorPos = result.length() - 1; separatorPos >= 0 && !WebAppManager.isPathSeparator(result.charAt(separatorPos)); --separatorPos) {
                            }
                            if (separatorPos < 0) continue block4;
                            result.setLength(separatorPos);
                            continue block4;
                        }
                    }
                }
            }
            result.append(c);
            ++pos;
        }
        return result.toString();
    }

    private static boolean isPathSeparator(char c) {
        return c == '/' || c == '\\';
    }

    static {
        try {
            String jaggeryDir = System.getProperty("jaggery.home");
            if (jaggeryDir == null) {
                jaggeryDir = System.getProperty("carbon.home");
            }
            if (jaggeryDir == null) {
                log.error((Object)"Unable to find jaggery.home or carbon.home system properties");
            }
            String modulesDir = jaggeryDir + File.separator + JAGGERY_MODULES_DIR;
            CommonManager.getInstance().initialize(modulesDir, new RhinoSecurityController(){

                protected void updatePermissions(PermissionCollection permissions, RhinoSecurityDomain securityDomain) {
                    JaggerySecurityDomain domain = (JaggerySecurityDomain)securityDomain;
                    ServletContext context = domain.getServletContext();
                    String docBase = context.getRealPath("/");
                    if (!docBase.endsWith(File.separator)) {
                        permissions.add(new FilePermission(docBase, "read"));
                        docBase = docBase + File.separator;
                    } else {
                        permissions.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                    }
                    docBase = docBase + "-";
                    permissions.add(new FilePermission(docBase, "read"));
                }
            });
        }
        catch (ScriptException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

