/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.app.mgt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.jaggery.app.mgt.JaggeryApplication;
import org.jaggeryjs.jaggery.app.mgt.JaggeryDeploymentUtil;
import org.jaggeryjs.jaggery.app.mgt.ServletMappingParameter;
import org.jaggeryjs.jaggery.app.mgt.ServletParameter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.session.CarbonTomcatClusterableSessionManager;
import org.wso2.carbon.webapp.mgt.CarbonTomcatSessionManager;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;

public class TomcatJaggeryWebappsDeployer
extends TomcatGenericWebappsDeployer {
    private static Log log = LogFactory.getLog(TomcatJaggeryWebappsDeployer.class);

    public TomcatJaggeryWebappsDeployer(String webContextPrefix, int tenantId, String tenantDomain, WebApplicationsHolder webappsHolder, ConfigurationContext configurationContext) {
        super(webContextPrefix, tenantId, tenantDomain, webappsHolder, configurationContext);
    }

    public void deploy(File webappFile, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        try {
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(this.tenantDomain);
            long lastModifiedTime = webappFile.lastModified();
            long configLastModified = 0L;
            if (JaggeryDeploymentUtil.getConfig(webappFile) != null) {
                configLastModified = JaggeryDeploymentUtil.getConfig(webappFile).lastModified();
            }
            JaggeryApplication deployedWebapp = (JaggeryApplication)((Object)this.webappsHolder.getStartedWebapps().get(webappFile.getName()));
            JaggeryApplication undeployedWebapp = (JaggeryApplication)((Object)this.webappsHolder.getStoppedWebapps().get(webappFile.getName()));
            JaggeryApplication faultyWebapp = (JaggeryApplication)((Object)this.webappsHolder.getFaultyWebapps().get(webappFile.getName()));
            if (deployedWebapp == null && faultyWebapp == null && undeployedWebapp == null) {
                this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
            } else if (deployedWebapp != null && deployedWebapp.getLastModifiedTime() != lastModifiedTime && configLastModified != 0L && deployedWebapp.getConfigDirLastModifiedTime() != configLastModified) {
                this.undeploy(webappFile);
                this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
            } else if (faultyWebapp != null && faultyWebapp.getLastModifiedTime() != lastModifiedTime && configLastModified != 0L && faultyWebapp.getConfigDirLastModifiedTime() != configLastModified) {
                this.handleHotDeployment(webappFile, webContextParams, applicationEventListeners);
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error while Tomact jaggery web apps Deployment ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleZipWebappDeployment(File webapp, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        TomcatJaggeryWebappsDeployer tomcatJaggeryWebappsDeployer = this;
        synchronized (tomcatJaggeryWebappsDeployer) {
            String appPath = webapp.getAbsolutePath().substring(0, webapp.getAbsolutePath().indexOf(".zip"));
            try {
                JaggeryDeploymentUtil.unZip(new FileInputStream(webapp), appPath);
                if (!webapp.delete()) {
                    throw new CarbonException(appPath + "could not be deleted");
                }
            }
            catch (FileNotFoundException e) {
                throw new CarbonException((Throwable)e);
            }
            File unzippedWebapp = new File(appPath);
            this.handleExplodedWebappDeployment(unzippedWebapp, webContextParams, applicationEventListeners);
        }
    }

    private void registerApplicationEventListeners(List<Object> applicationEventListeners, Context context) {
        Object[] originalEventListeners = context.getApplicationEventListeners();
        Object[] newEventListeners = new Object[originalEventListeners.length + applicationEventListeners.size()];
        if (originalEventListeners.length != 0) {
            System.arraycopy(originalEventListeners, 0, newEventListeners, 0, originalEventListeners.length);
            int i = originalEventListeners.length;
            for (Object eventListener : applicationEventListeners) {
                newEventListeners[i++] = eventListener;
            }
        } else {
            newEventListeners = applicationEventListeners.toArray(new Object[applicationEventListeners.size()]);
        }
        context.setApplicationEventListeners(newEventListeners);
    }

    protected void handleWebappDeployment(File webappFile, String contextStr, List<WebContextParameter> webContextParams, List<Object> applicationEventListeners) throws CarbonException {
        String filename = webappFile.getName();
        ArrayList listeners = new ArrayList(1);
        ServletParameter jaggeryServletParameter = new ServletParameter();
        ServletParameter jsspParameter = new ServletParameter();
        jaggeryServletParameter.setServletName("JaggeryServlet");
        jaggeryServletParameter.setServletClass("org.jaggeryjs.jaggery.core.JaggeryServlet");
        jsspParameter.setServletName("jssp");
        jsspParameter.setServletClass("org.apache.jasper.servlet.JspServlet");
        jsspParameter.setLoadOnStartup(2);
        HashMap<String, String> jsspInitParamMap = new HashMap<String, String>();
        jsspInitParamMap.put("fork", "false");
        jsspParameter.setInitParams(jsspInitParamMap);
        ArrayList<ServletParameter> servletParameters = new ArrayList<ServletParameter>();
        servletParameters.add(jaggeryServletParameter);
        servletParameters.add(jsspParameter);
        ServletMappingParameter jaggeryServletMappingParameter = new ServletMappingParameter();
        ServletMappingParameter jsspMappingParameter = new ServletMappingParameter();
        jaggeryServletMappingParameter.setServletName("JaggeryServlet");
        jaggeryServletMappingParameter.setUrlPattern("*.jag");
        SecurityConstraint securityConstraint = new SecurityConstraint();
        securityConstraint.setAuthConstraint(true);
        SecurityCollection securityCollection = new SecurityCollection();
        securityCollection.setName("ConfigDir");
        securityCollection.setDescription("Jaggery Configuration Dir");
        securityCollection.addPattern("/jaggery.conf");
        securityConstraint.addCollection(securityCollection);
        ArrayList<ServletMappingParameter> servletMappingParameters = new ArrayList<ServletMappingParameter>();
        servletMappingParameters.add(jaggeryServletMappingParameter);
        servletMappingParameters.add(jsspMappingParameter);
        try {
            JSONObject jaggeryConfigObj = this.readJaggeryConfig(webappFile);
            Tomcat tomcat = DataHolder.getCarbonTomcatService().getTomcat();
            Context context = DataHolder.getCarbonTomcatService().addWebApp(contextStr, webappFile.getAbsolutePath(), (LifecycleListener)new JaggeryConfListener(tomcat, servletParameters, servletMappingParameters, jaggeryConfigObj, securityConstraint));
            if (DataHolder.getHotUpdateService() != null) {
                List hostNames = DataHolder.getHotUpdateService().getMappigsPerWebapp(contextStr);
                for (String hostName : hostNames) {
                    Host host = DataHolder.getHotUpdateService().addHost(hostName);
                    Context contextForHost = DataHolder.getCarbonTomcatService().addWebApp(host, "/", webappFile.getAbsolutePath(), (LifecycleListener)new JaggeryConfListener(tomcat, servletParameters, servletMappingParameters, jaggeryConfigObj, securityConstraint));
                    log.info((Object)("Deployed JaggeryApp on host: " + contextForHost));
                }
            }
            if (TomcatJaggeryWebappsDeployer.isDistributable(context, jaggeryConfigObj)) {
                context.setDistributable(true);
                CarbonTomcatClusterableSessionManager sessionManager = new CarbonTomcatClusterableSessionManager(this.tenantId);
                context.setManager((Manager)sessionManager);
                this.sessionManagerMap.put(context.getName(), sessionManager);
                this.configurationContext.setProperty("CarbonTomcatSessionManagerMap", (Object)this.sessionManagerMap);
            } else {
                context.setManager((Manager)new CarbonTomcatSessionManager(this.tenantId));
            }
            context.setReloadable(true);
            JaggeryApplication webapp = new JaggeryApplication(this, context, webappFile);
            webapp.setServletParameters(servletParameters);
            webapp.setServletMappingParameters(servletMappingParameters);
            webapp.setServletContextParameters(webContextParams);
            webapp.setState("Started");
            this.webappsHolder.getStartedWebapps().put(filename, webapp);
            this.webappsHolder.getFaultyWebapps().remove(filename);
            this.registerApplicationEventListeners(applicationEventListeners, context);
            log.info((Object)("Deployed webapp: " + (Object)((Object)webapp)));
        }
        catch (Throwable e) {
            StandardContext context = new StandardContext();
            context.setName(webappFile.getName());
            JaggeryApplication webapp = new JaggeryApplication(this, (Context)context, webappFile);
            webapp.setProperty("webappFilter", "jaggeryWebapp");
            String msg = "Error while deploying webapp: " + (Object)((Object)webapp);
            log.error((Object)msg, e);
            webapp.setFaultReason(new Exception(msg, e));
            this.webappsHolder.getFaultyWebapps().put(filename, webapp);
            this.webappsHolder.getStartedWebapps().remove(filename);
            throw new CarbonException(msg, e);
        }
    }

    private static void initJaggeryappDefaults(Context ctx, Tomcat tomcat, JSONObject jaggeryConfig, List<ServletParameter> servletParameters, List<ServletMappingParameter> servletMappingParameters, SecurityConstraint securityConstraint) {
        for (ServletParameter servletParameter : servletParameters) {
            if (servletParameter.getServletName() == null || servletParameter.getServletClass() == null) continue;
            Wrapper servletWrapper = Tomcat.addServlet((Context)ctx, (String)servletParameter.getServletName(), (String)servletParameter.getServletClass());
            if (servletParameter.getInitParams() != null) {
                for (Map.Entry<String, String> entry : servletParameter.getInitParams().entrySet()) {
                    servletWrapper.addInitParameter(entry.getKey(), entry.getValue());
                }
            }
            if (servletParameter.getLoadOnStartup() == 0) continue;
            servletWrapper.setLoadOnStartup(servletParameter.getLoadOnStartup());
        }
        for (ServletMappingParameter servletMappingParameter : servletMappingParameters) {
            if (servletMappingParameter.getServletName() == null || servletMappingParameter.getUrlPattern() == null) continue;
            ctx.addServletMapping(servletMappingParameter.getUrlPattern(), servletMappingParameter.getServletName());
        }
        ctx.addConstraint(securityConstraint);
        TomcatJaggeryWebappsDeployer.addWelcomeFiles(ctx, jaggeryConfig);
        if (jaggeryConfig != null) {
            TomcatJaggeryWebappsDeployer.setDisplayName(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addErrorPages(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addSecurityConstraints(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.setLoginConfig(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addSecurityRoles(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addUrlMappings(ctx, jaggeryConfig);
            TomcatJaggeryWebappsDeployer.addParameters(ctx, jaggeryConfig);
        }
    }

    private JSONObject readJaggeryConfig(File f) throws IOException {
        File confFile = new File(f.getAbsolutePath() + File.separator + "jaggery.conf");
        if (!confFile.exists()) {
            return null;
        }
        String jsonString = "";
        if (!confFile.isDirectory()) {
            FileInputStream fis = new FileInputStream(confFile);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)fis, (Writer)writer, null);
            jsonString = writer.toString();
        }
        return (JSONObject)JSONValue.parse((String)jsonString);
    }

    private static void addErrorPages(Context context, JSONObject obj) {
        JSONObject arr = (JSONObject)obj.get((Object)"errorPages");
        if (arr != null) {
            for (Object keys : arr.keySet()) {
                ErrorPage errPage = new ErrorPage();
                errPage.setErrorCode((String)keys);
                errPage.setLocation((String)arr.get(keys));
                context.addErrorPage(errPage);
            }
        }
    }

    private static void setLoginConfig(Context context, JSONObject obj) {
        JSONObject loginObj = (JSONObject)obj.get((Object)"loginConfig");
        if (loginObj != null) {
            if (loginObj.get((Object)"authMethod").equals("FORM")) {
                LoginConfig loginConfig = new LoginConfig();
                loginConfig.setAuthMethod("FORM");
                loginConfig.setLoginPage((String)((JSONObject)loginObj.get((Object)"formLoginConfig")).get((Object)"formLoginPage"));
                loginConfig.setErrorPage((String)((JSONObject)loginObj.get((Object)"formLoginConfig")).get((Object)"formErrorPage"));
                context.setLoginConfig(loginConfig);
            } else if (loginObj.get((Object)"authMethod").equals("BASIC")) {
                LoginConfig loginConfig = new LoginConfig();
                loginConfig.setAuthMethod("BASIC");
                context.setLoginConfig(loginConfig);
            }
        }
    }

    private static void addSecurityConstraints(Context context, JSONObject obj) {
        JSONArray arr = (JSONArray)obj.get((Object)"securityConstraints");
        if (arr != null) {
            for (Object anArr : arr) {
                JSONObject o = (JSONObject)anArr;
                SecurityConstraint securityConstraint = new SecurityConstraint();
                if (((JSONObject)o.get((Object)"securityConstraint")).get((Object)"webResourceCollection") != null) {
                    JSONObject resCollection = (JSONObject)((JSONObject)o.get((Object)"securityConstraint")).get((Object)"webResourceCollection");
                    SecurityCollection secCollection = new SecurityCollection();
                    secCollection.setName((String)resCollection.get((Object)"name"));
                    JSONArray arrPattern = (JSONArray)resCollection.get((Object)"urlPatterns");
                    for (Object anArrPattern : arrPattern) {
                        secCollection.addPattern((String)anArrPattern);
                    }
                    JSONArray methods = (JSONArray)resCollection.get((Object)"methods");
                    if (methods != null) {
                        for (Object method : methods) {
                            secCollection.addMethod((String)method);
                        }
                    }
                    securityConstraint.addCollection(secCollection);
                }
                if (((JSONObject)o.get((Object)"securityConstraint")).get((Object)"authRoles") != null) {
                    JSONArray roles = (JSONArray)((JSONObject)o.get((Object)"securityConstraint")).get((Object)"authRoles");
                    for (Object role : roles) {
                        securityConstraint.addAuthRole((String)role);
                    }
                    securityConstraint.setAuthConstraint(true);
                }
                context.addConstraint(securityConstraint);
            }
        }
    }

    private static void addSecurityRoles(Context context, JSONObject obj) {
        JSONArray arr = (JSONArray)obj.get((Object)"securityRoles");
        if (arr != null) {
            for (Object role : arr) {
                context.addSecurityRole((String)role);
            }
        }
    }

    private static void setDisplayName(Context context, JSONObject obj) {
        if (obj == null) {
            return;
        }
        String dName = (String)obj.get((Object)"displayName");
        if (dName != null) {
            context.setDisplayName(dName);
        }
    }

    private static boolean isDistributable(Context context, JSONObject obj) {
        if (obj != null) {
            if (obj.get((Object)"distributable") instanceof Boolean) {
                Boolean isDistributable = (Boolean)obj.get((Object)"distributable");
                if (isDistributable != null) {
                    return isDistributable;
                }
            } else if (obj.get((Object)"distributable") instanceof String) {
                String distributable = (String)obj.get((Object)"distributable");
                return distributable != null && distributable.equalsIgnoreCase("true");
            }
        }
        return false;
    }

    private static void addParameters(Context context, JSONObject obj) {
        if (obj != null) {
            for (String key : obj.keySet()) {
                if (!(obj.get((Object)key) instanceof String)) continue;
                context.addParameter(key, (String)obj.get((Object)key));
            }
        }
    }

    private static void addWelcomeFiles(Context context, JSONObject obj) {
        if (obj != null) {
            JSONArray arr = (JSONArray)obj.get((Object)"welcomeFiles");
            if (arr != null) {
                for (Object role : arr) {
                    context.addWelcomeFile((String)role);
                }
            } else {
                context.addWelcomeFile("index.jag");
                context.addWelcomeFile("index.html");
            }
        } else {
            context.addWelcomeFile("index.jag");
            context.addWelcomeFile("index.html");
        }
    }

    private static void addUrlMappings(Context context, JSONObject obj) {
        JSONArray arr = (JSONArray)obj.get((Object)"urlMappings");
        if (arr != null) {
            HashMap<String, Object> urlMappings = new HashMap<String, Object>();
            for (Object mapObj : arr) {
                JSONObject mapping = (JSONObject)mapObj;
                String url = (String)mapping.get((Object)"url");
                String path = (String)mapping.get((Object)"path");
                if (url != null && path != null) {
                    path = path.startsWith("/") ? path : "/" + path;
                    context.addServletMapping(url, "JaggeryServlet");
                    if (url.equals("/")) {
                        urlMappings.put("/", path);
                        continue;
                    }
                    url = url.startsWith("/") ? url.substring(1) : url;
                    ArrayList<String> parts = new ArrayList<String>(Arrays.asList(url.split("/")));
                    TomcatJaggeryWebappsDeployer.addMappings(urlMappings, parts, path);
                    continue;
                }
                log.error((Object)("Invalid url mapping in jaggery.conf url : " + url + ", path : " + path));
            }
            context.getServletContext().setAttribute("jaggery.urls.map", urlMappings);
        }
    }

    private static void addMappings(Map<String, Object> map, List<String> parts, String path) {
        HashMap<String, Object> childMap;
        String part = parts.remove(0);
        if (parts.isEmpty()) {
            Object obj = map.get(part);
            if (obj != null) {
                log.error((Object)("Conflicting url patterns for the path : " + path));
            }
            if (part.startsWith("*")) {
                int dotIndex = part.lastIndexOf(".");
                if (dotIndex != -1) {
                    HashMap<String, String> extsMap;
                    if (part.length() == dotIndex + 1) {
                        log.error((Object)("Extension cannot be found for the url pattern for " + path));
                        return;
                    }
                    String ext = part.substring(dotIndex + 1);
                    Object exts = map.get("*");
                    if (exts instanceof String) {
                        log.error((Object)("* wildcard mapping is already existing for " + path));
                        return;
                    }
                    if (exts == null) {
                        extsMap = new HashMap<String, String>();
                    } else {
                        extsMap = (HashMap<String, String>)exts;
                        if (extsMap.get(ext) != null) {
                            log.error((Object)("Url mapping is already existing for " + path));
                            return;
                        }
                    }
                    extsMap.put(ext, path);
                    map.put(part, extsMap);
                    return;
                }
                map.put(part, path);
                return;
            }
            map.put(part, path);
            return;
        }
        Object obj = map.get(part);
        if (obj instanceof Map) {
            childMap = (HashMap<String, Object>)obj;
        } else {
            childMap = new HashMap<String, Object>();
            map.put(part, childMap);
            if (obj instanceof String) {
                childMap.put("/", obj);
            }
        }
        TomcatJaggeryWebappsDeployer.addMappings(childMap, parts, path);
    }

    private static class JaggeryConfListener
    implements LifecycleListener {
        private List<ServletParameter> servletParameters;
        private List<ServletMappingParameter> servletMappingParameters;
        private JSONObject jaggeryConfig;
        private Tomcat tomcat;
        private SecurityConstraint securityConstraint;

        private JaggeryConfListener(Tomcat tomcat, List<ServletParameter> servletParameters, List<ServletMappingParameter> servletMappingParameters, JSONObject jaggeryConfig, SecurityConstraint securityConstraint) {
            this.servletParameters = servletParameters;
            this.servletMappingParameters = servletMappingParameters;
            this.jaggeryConfig = jaggeryConfig;
            this.tomcat = tomcat;
            this.securityConstraint = securityConstraint;
        }

        public void lifecycleEvent(LifecycleEvent event) {
            if ("before_start".equals(event.getType())) {
                TomcatJaggeryWebappsDeployer.initJaggeryappDefaults((Context)event.getLifecycle(), this.tomcat, this.jaggeryConfig, this.servletParameters, this.servletMappingParameters, this.securityConstraint);
            }
            if ("start".equals(event.getType())) {
                TomcatJaggeryWebappsDeployer.setDisplayName((Context)event.getLifecycle(), this.jaggeryConfig);
            }
        }
    }
}

