/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.app.mgt.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jaggeryjs.jaggery.app.mgt.stub.types.carbon.WebappUploadData;
import org.jaggeryjs.jaggery.app.mgt.ui.JaggeryAdminClient;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class WarFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".war", ".zip"};

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "Jaggery application uploading failed. No file specified.";
            log.error((Object)msg);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/jaggeryapp-mgt/uploadjaggeryapp.jsp"));
            return false;
        }
        JaggeryAdminClient client = new JaggeryAdminClient(cookie, serverURL, this.configurationContext, request.getLocale());
        List tempDataList = (List)fileItemsMap.get("warFileName");
        if (tempDataList == null) {
            return false;
        }
        ArrayList<WebappUploadData> webappUploadDataList = new ArrayList<WebappUploadData>();
        try {
            for (FileItemData filedata : tempDataList) {
                WebappUploadData tempData = new WebappUploadData();
                this.checkServiceFileExtensionValidity(this.getFileName(filedata.getFileItem().getName()), ALLOWED_FILE_EXTENSIONS);
                tempData.setFileName(this.getFileName(filedata.getFileItem().getName()));
                tempData.setDataHandler(filedata.getDataHandler());
                webappUploadDataList.add(tempData);
            }
            client.uploadWebapp(webappUploadDataList.toArray(new WebappUploadData[webappUploadDataList.size()]));
            response.setContentType("text/html; charset=utf-8");
            String msg = tempDataList.size() > 1 ? "Jaggery applications have been uploaded successfully. Please refresh this page in a while to see the status of the running Jaggery apps." : "Jaggery application has been uploaded successfully. Please refresh this page in a while to see the status of the running Jaggery apps.";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/jaggeryapp-mgt/index.jsp"));
            return true;
        }
        catch (Exception e) {
            String msg = "Jaggery application upload failed. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)("../" + webContext + "/jaggeryapp-mgt/uploadjaggeryapp.jsp"));
            return false;
        }
    }
}

