/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.xslt;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.xml.XMLObject;

public class XSLTHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(XSLTHostObject.class);
    private TransformerFactory factory = null;
    private Transformer transformer = null;
    private StringReader xslt = null;
    private static final String hostObjectName = "XSLT";

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (argsCount < 1 || argsCount > 3) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        Function uriResolver = null;
        NativeObject paramMap = null;
        XSLTHostObject xho = new XSLTHostObject();
        if (args[0] instanceof String) {
            xho.xslt = new StringReader((String)args[0]);
        } else if (args[0] instanceof XMLObject) {
            xho.xslt = new StringReader(args[0].toString());
        } else {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"1", (String)"string | xml", (Object)args[0], (boolean)true);
        }
        if (argsCount == 2) {
            if (args[1] instanceof NativeObject) {
                paramMap = (NativeObject)args[1];
            } else if (args[1] instanceof Function) {
                uriResolver = (Function)args[1];
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"2", (String)"string", (Object)args[1], (boolean)true);
            }
        } else if (argsCount == 3) {
            if (args[1] instanceof NativeObject) {
                paramMap = (NativeObject)args[1];
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"2", (String)"string", (Object)args[1], (boolean)true);
            }
            if (args[2] instanceof Function) {
                uriResolver = (Function)args[2];
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"3", (String)"string", (Object)args[1], (boolean)true);
            }
        }
        xho.factory = TransformerFactory.newInstance();
        if (uriResolver != null) {
            xho.factory.setURIResolver(XSLTHostObject.getUriResolver(cx, (Scriptable)ctorObj, uriResolver));
        }
        return xho;
    }

    private static URIResolver getUriResolver(final Context cx, final Scriptable scope, final Function uriResolver) {
        return new URIResolver(){

            @Override
            public Source resolve(String href, String base) throws TransformerException {
                Object obj = uriResolver.call(cx, scope, scope, new Object[]{base, href});
                if (obj instanceof XMLObject) {
                    return new StreamSource(new StringReader(obj.toString()));
                }
                if (obj instanceof String) {
                    return new StreamSource(new StringReader((String)obj));
                }
                throw new TransformerException("Error while resolving the content for " + href);
            }
        };
    }

    private static Transformer getTransformer(Context cx, Scriptable scope, XSLTHostObject xho, NativeObject paramMap, Function uriResolver) throws ScriptException {
        try {
            Transformer transformer = xho.factory.newTransformer(new StreamSource(xho.xslt));
            if (paramMap != null) {
                XSLTHostObject.setParams(transformer, paramMap);
            }
            if (uriResolver != null) {
                transformer.setURIResolver(XSLTHostObject.getUriResolver(cx, scope, uriResolver));
            }
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public String getClassName() {
        return hostObjectName;
    }

    public static String jsFunction_transform(final Context cx, final Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "transform";
        int argsCount = args.length;
        if (argsCount > 4) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        StringReader xml = null;
        Function uriResolver = null;
        NativeObject paramMap = null;
        Function callback = null;
        if (args[0] instanceof String) {
            xml = new StringReader((String)args[0]);
        } else if (args[0] instanceof XMLObject) {
            xml = new StringReader(args[0].toString());
        } else {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)hostObjectName, (String)"1", (String)"string | xml", (Object)args[0], (boolean)true);
        }
        if (argsCount == 2) {
            if (args[1] instanceof NativeObject) {
                paramMap = (NativeObject)args[1];
            } else if (args[1] instanceof Function) {
                callback = (Function)args[1];
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"object | function", (Object)args[1], (boolean)false);
            }
        } else if (argsCount == 3) {
            if (args[1] instanceof NativeObject) {
                paramMap = (NativeObject)args[1];
                if (args[2] instanceof Function) {
                    callback = (Function)args[2];
                } else {
                    HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"3", (String)"function", (Object)args[2], (boolean)false);
                }
            } else if (args[1] instanceof Function) {
                callback = (Function)args[1];
                if (args[2] instanceof Function) {
                    uriResolver = (Function)args[2];
                } else {
                    HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"3", (String)"function", (Object)args[2], (boolean)false);
                }
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"object", (Object)args[1], (boolean)false);
            }
        } else if (argsCount == 4) {
            if (args[1] instanceof NativeObject) {
                paramMap = (NativeObject)args[1];
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"object", (Object)args[1], (boolean)false);
            }
            if (args[2] instanceof Function) {
                callback = (Function)args[2];
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"3", (String)"function", (Object)args[2], (boolean)false);
            }
            if (args[3] instanceof Function) {
                uriResolver = (Function)args[3];
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"4", (String)"function", (Object)args[3], (boolean)false);
            }
        }
        final XSLTHostObject xho = (XSLTHostObject)thisObj;
        try {
            final StringWriter result = new StringWriter();
            if (callback == null) {
                if (xho.transformer == null) {
                    xho.transformer = XSLTHostObject.getTransformer(cx, thisObj, xho, paramMap, uriResolver);
                } else {
                    if (paramMap != null) {
                        XSLTHostObject.setParams(xho.transformer, paramMap);
                    }
                    if (uriResolver != null) {
                        xho.transformer.setURIResolver(XSLTHostObject.getUriResolver(cx, (Scriptable)funObj, uriResolver));
                    }
                }
                xho.transformer.transform(new StreamSource(xml), new StreamResult(result));
                return result.toString();
            }
            final StringReader finalXml = xml;
            final Function finalCallback = callback;
            final Function finalUriResolver = uriResolver;
            final NativeObject finalParamMap = paramMap;
            final ContextFactory factory = cx.getFactory();
            final ExecutorService es = Executors.newCachedThreadPool();
            es.submit(new Callable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object call() throws Exception {
                    RhinoEngine.enterContext((ContextFactory)factory);
                    try {
                        XSLTHostObject.getTransformer(cx, thisObj, xho, finalParamMap, finalUriResolver).transform(new StreamSource(finalXml), new StreamResult(result));
                        finalCallback.call(cx, (Scriptable)xho, (Scriptable)xho, new Object[]{result.toString()});
                    }
                    catch (TransformerException e) {
                        log.warn((Object)e);
                    }
                    finally {
                        es.shutdown();
                        RhinoEngine.exitContext();
                    }
                    return null;
                }
            });
            return null;
        }
        catch (TransformerException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    private static void setParams(Transformer transformer, NativeObject paramMap) {
        Object[] ids;
        transformer.clearParameters();
        for (Object id : ids = paramMap.getIds()) {
            String key = (String)id;
            Object obj = paramMap.get(key, (Scriptable)paramMap);
            transformer.setParameter(key, HostObjectUtil.serializeObject((Object)obj));
        }
    }
}

