/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.xhr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class XMLHttpRequestHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(XMLHttpRequestHostObject.class);
    private static final short UNSENT = 0;
    private static final short OPENED = 1;
    private static final short HEADERS_RECEIVED = 2;
    private static final short LOADING = 3;
    private static final short DONE = 4;
    private short readyState;
    private StatusLine statusLine;
    private String responseText;
    private Scriptable responseXML;
    private Function onreadystatechange;
    private static final String hostObjectName = "XMLHttpRequest";
    private Context context = null;
    private String methodName = null;
    private String url = null;
    private boolean async = false;
    private String username = null;
    private String password = null;
    private List<Header> requestHeaders = new ArrayList<Header>();
    private HttpMethodBase method = null;
    private Header[] responseHeaders = null;
    private String responseType = null;
    private boolean sent = false;
    private boolean error = false;
    private HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());

    public String getClassName() {
        return hostObjectName;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        XMLHttpRequestHostObject xhr = new XMLHttpRequestHostObject();
        xhr.context = cx;
        return xhr;
    }

    public short jsGet_readyState() throws ScriptException {
        return this.readyState;
    }

    public Function jsGet_onreadystatechange() throws ScriptException {
        return this.onreadystatechange;
    }

    public void jsSet_onreadystatechange(Object object) throws ScriptException {
        if (!(object instanceof Function)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"onreadystatechange", (String)"Function", (Object)object);
        }
        this.onreadystatechange = (Function)object;
    }

    public int jsGet_status() throws ScriptException {
        return this.statusLine.getStatusCode();
    }

    public String jsGet_statusText() throws ScriptException {
        return this.statusLine.getReasonPhrase();
    }

    public String jsGet_responseText() throws ScriptException {
        if (this.readyState == 3 || this.readyState == 4) {
            return this.responseText;
        }
        return "";
    }

    public Scriptable jsGet_responseXML() throws ScriptException {
        if (this.readyState != 3 && this.readyState != 4) {
            return null;
        }
        if (!(this.responseType == null || this.responseType.equals("text/xml") || this.responseType.equals("application/xml") || this.responseType.endsWith("+xml"))) {
            return null;
        }
        try {
            if (this.responseXML != null) {
                return this.responseXML;
            }
            this.responseXML = this.context.newObject((Scriptable)this, "XML", new Object[]{AXIOMUtil.stringToOM((String)this.responseText)});
            return this.responseXML;
        }
        catch (XMLStreamException e) {
            throw new ScriptException("Error while converting response of " + this.url + " to a XML", (Exception)e);
        }
    }

    public static void jsFunction_open(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "open";
        XMLHttpRequestHostObject xhr = (XMLHttpRequestHostObject)thisObj;
        int argsCount = args.length;
        if (argsCount < 2 || argsCount > 5) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        } else if (argsCount == 2) {
            XMLHttpRequestHostObject.setMethod(functionName, xhr, args[0]);
            XMLHttpRequestHostObject.setURL(functionName, xhr, args[1]);
        } else if (argsCount == 3) {
            XMLHttpRequestHostObject.setMethod(functionName, xhr, args[0]);
            XMLHttpRequestHostObject.setURL(functionName, xhr, args[1]);
            XMLHttpRequestHostObject.setAsync(functionName, xhr, args[2]);
        } else if (argsCount == 4) {
            XMLHttpRequestHostObject.setMethod(functionName, xhr, args[0]);
            XMLHttpRequestHostObject.setURL(functionName, xhr, args[1]);
            XMLHttpRequestHostObject.setUsername(functionName, xhr, args[2], "3");
            XMLHttpRequestHostObject.setPassword(functionName, xhr, args[3], "4");
        } else {
            XMLHttpRequestHostObject.setMethod(functionName, xhr, args[0]);
            XMLHttpRequestHostObject.setURL(functionName, xhr, args[1]);
            XMLHttpRequestHostObject.setAsync(functionName, xhr, args[2]);
            XMLHttpRequestHostObject.setUsername(functionName, xhr, args[3], "4");
            XMLHttpRequestHostObject.setPassword(functionName, xhr, args[4], "5");
        }
        XMLHttpRequestHostObject.updateReadyState(xhr, (short)1);
    }

    public static void jsFunction_setRequestHeader(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "setRequestHeader";
        int argsCount = args.length;
        if (argsCount != 2) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        XMLHttpRequestHostObject xhr = (XMLHttpRequestHostObject)thisObj;
        xhr.requestHeaders.add(new Header((String)args[0], (String)args[1]));
    }

    public static void jsFunction_send(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "send";
        XMLHttpRequestHostObject xhr = (XMLHttpRequestHostObject)thisObj;
        if (xhr.readyState != 1) {
            throw new ScriptException("Invalid state, cannot invoke send() method. readyState : " + xhr.readyState);
        }
        if (xhr.sent) {
            xhr.method.abort();
            throw new ScriptException("Invalid state, cannot invoke send() method while a request is active. Request aborted.");
        }
        int argsCount = args.length;
        if (argsCount > 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        Object obj = argsCount == 1 ? args[0] : null;
        xhr.send(obj);
    }

    public static void jsFunction_abort(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        XMLHttpRequestHostObject xhr = (XMLHttpRequestHostObject)thisObj;
        if (xhr.async) {
            xhr.method.abort();
        }
    }

    public static String jsFunction_getResponseHeader(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getResponseHeader";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        XMLHttpRequestHostObject xhr = (XMLHttpRequestHostObject)thisObj;
        String header = (String)args[0];
        if (xhr.readyState == 0 || xhr.readyState == 1) {
            return null;
        }
        if (xhr.error) {
            return null;
        }
        if (XMLHttpRequestHostObject.isInvalidHeader(header)) {
            return null;
        }
        if (xhr.responseHeaders == null) {
            return null;
        }
        for (Header h : xhr.responseHeaders) {
            if (!h.getName().equalsIgnoreCase(header)) continue;
            return h.getValue();
        }
        return null;
    }

    public static String jsFunction_getAllResponseHeaders(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getResponseHeader";
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        XMLHttpRequestHostObject xhr = (XMLHttpRequestHostObject)thisObj;
        if (xhr.readyState == 0 || xhr.readyState == 1) {
            return null;
        }
        if (xhr.error) {
            return null;
        }
        StringBuffer hBuf = new StringBuffer();
        String headers = "";
        if (xhr.responseHeaders == null) {
            return headers;
        }
        for (Header h : xhr.responseHeaders) {
            String header = h.getName();
            if (XMLHttpRequestHostObject.isInvalidHeader(header)) continue;
            hBuf.append(h.getName() + ": " + h.getValue() + "\r\n");
        }
        headers = hBuf.toString();
        return headers;
    }

    private static void setURL(String functionName, XMLHttpRequestHostObject xhr, Object arg) throws ScriptException {
        if (arg instanceof String) {
            int lastIndex;
            String url = (String)arg;
            String formattedUrl = url.toLowerCase();
            if (!formattedUrl.startsWith("http://") && !formattedUrl.startsWith("https://")) {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"A urls begins with either 'http://' or 'https://'", (Object)url, (boolean)false);
            }
            lastIndex = (lastIndex = url.indexOf("#")) == -1 ? url.length() : lastIndex;
            xhr.url = url.substring(0, lastIndex);
        } else {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"string", (Object)arg, (boolean)false);
        }
    }

    private static void setMethod(String functionName, XMLHttpRequestHostObject xhr, Object arg) throws ScriptException {
        if (arg instanceof String) {
            String methodName = ((String)arg).toUpperCase();
            if ("GET".equals(methodName) || "HEAD".equals(methodName) || "POST".equals(methodName) || "PUT".equals(methodName) || "DELETE".equals(methodName) || "TRACE".equals(methodName) || "OPTIONS".equals(methodName)) {
                xhr.methodName = methodName;
            } else {
                HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"GET, HEAD, POST, PUT, DELETE, TRACE or OPTIONS", (Object)methodName, (boolean)false);
            }
        } else {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)arg, (boolean)false);
        }
    }

    private static void setAsync(String functionName, XMLHttpRequestHostObject xhr, Object arg) throws ScriptException {
        if (arg instanceof Boolean) {
            xhr.async = (Boolean)arg;
        } else {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"3", (String)"boolean", (Object)arg.toString(), (boolean)false);
        }
    }

    private static void setUsername(String functionName, XMLHttpRequestHostObject xhr, Object arg, String index) throws ScriptException {
        if (arg instanceof String) {
            xhr.username = (String)arg;
        } else {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)index, (String)"string", (Object)arg.toString(), (boolean)false);
        }
    }

    private static void setPassword(String functionName, XMLHttpRequestHostObject xhr, Object arg, String index) throws ScriptException {
        if (arg instanceof String) {
            xhr.password = (String)arg;
        } else {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)index, (String)"string", (Object)arg.toString(), (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateReadyState(XMLHttpRequestHostObject xhr, short readyState) {
        xhr.readyState = readyState;
        if (xhr.async && xhr.onreadystatechange != null) {
            if (!(xhr.onreadystatechange instanceof Function)) {
                log.warn((Object)"A function must be specified for the XMLHttpRequest callback");
                return;
            }
            try {
                RhinoEngine.enterContext();
                xhr.onreadystatechange.call(xhr.context, (Scriptable)xhr, (Scriptable)xhr, new Object[0]);
            }
            catch (Exception e) {
                log.warn((Object)("Error executing XHR callback for " + xhr.url), (Throwable)e);
                e.printStackTrace();
            }
            finally {
                RhinoEngine.exitContext();
            }
        }
    }

    private void send(Object obj) throws ScriptException {
        String content;
        GetMethod method;
        if ("GET".equalsIgnoreCase(this.methodName)) {
            method = new GetMethod(this.url);
        } else if ("HEAD".equalsIgnoreCase(this.methodName)) {
            method = new HeadMethod(this.url);
        } else if ("POST".equalsIgnoreCase(this.methodName)) {
            PostMethod post = new PostMethod(this.url);
            content = XMLHttpRequestHostObject.getRequestContent(obj);
            if (content != null) {
                post.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(content.getBytes())));
            }
            method = post;
        } else if ("PUT".equalsIgnoreCase(this.methodName)) {
            PutMethod put = new PutMethod(this.url);
            content = XMLHttpRequestHostObject.getRequestContent(obj);
            if (content != null) {
                put.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(content.getBytes())));
            }
            method = put;
        } else if ("DELETE".equalsIgnoreCase(this.methodName)) {
            method = new DeleteMethod(this.url);
        } else if ("TRACE".equalsIgnoreCase(this.methodName)) {
            method = new TraceMethod(this.url);
        } else if ("OPTIONS".equalsIgnoreCase(this.methodName)) {
            method = new OptionsMethod(this.url);
        } else {
            throw new ScriptException("Unknown HTTP method : " + this.methodName);
        }
        for (Header header : this.requestHeaders) {
            method.addRequestHeader(header);
        }
        if (this.username != null) {
            this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        }
        this.method = method;
        final XMLHttpRequestHostObject xhr = this;
        if (this.async) {
            XMLHttpRequestHostObject.updateReadyState(xhr, (short)3);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        XMLHttpRequestHostObject.executeRequest(xhr);
                    }
                    catch (ScriptException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }).start();
        } else {
            XMLHttpRequestHostObject.executeRequest(xhr);
        }
    }

    private static void executeRequest(XMLHttpRequestHostObject xhr) throws ScriptException {
        try {
            xhr.httpClient.executeMethod((HttpMethod)xhr.method);
            xhr.statusLine = xhr.method.getStatusLine();
            xhr.responseHeaders = xhr.method.getResponseHeaders();
            XMLHttpRequestHostObject.updateReadyState(xhr, (short)2);
            byte[] response = xhr.method.getResponseBody();
            if (response.length > 0) {
                xhr.responseType = xhr.method.getResponseHeader("Content-Type").getValue();
                xhr.responseText = new String(response);
            }
            XMLHttpRequestHostObject.updateReadyState(xhr, (short)4);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
        finally {
            xhr.method.releaseConnection();
        }
    }

    private static String getRequestContent(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Undefined) {
            return null;
        }
        return HostObjectUtil.serializeObject((Object)obj);
    }

    private static boolean isInvalidHeader(String header) {
        return (header.equalsIgnoreCase("Set-Cookie") || header.equalsIgnoreCase("Set-Cookie2")) && !header.equals("Set-Cookie") && !header.equals("Set-Cookie2");
    }
}

