/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.ws;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.ws.util.XSLTTransformer;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WSStubHostObject
extends ScriptableObject {
    private static Log log = LogFactory.getLog(WSStubHostObject.class);
    private static final String hostObjectName = "WSStub";
    private Object services;
    private Object webService;
    private String jsString = "";

    public String getClassName() {
        return hostObjectName;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function thisObj, boolean inNewExpr) throws ScriptException {
        if (args.length == 1) {
            WSStubHostObject wsStub = new WSStubHostObject();
            String jsStubString = wsStub.genarateStubFromURL("e4x", (String)args[0]);
            Function scope = thisObj;
            cx.evaluateString((Scriptable)scope, jsStubString, "(wso2)", 1, null);
            wsStub.services = scope.get("services", (Scriptable)scope);
            if (wsStub.services == Scriptable.NOT_FOUND) {
                log.error((Object)"Error creating stub, services not found");
            }
            wsStub.webService = scope.get("WebService", (Scriptable)scope);
            if (wsStub.webService == Scriptable.NOT_FOUND) {
                log.error((Object)"Error creating stub, WebService not found");
            }
            return wsStub;
        }
        HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)"Constructor", (int)1, (boolean)true);
        return null;
    }

    public Scriptable jsGet_services() {
        return (Scriptable)this.services;
    }

    public Scriptable jsGet_webService() {
        return (Scriptable)this.webService;
    }

    public String genarateStubFromURL(String type, String url) throws ScriptException {
        GetMethod httpMethod = new GetMethod(url);
        try {
            URL wsdlURL = new URL(url);
            int statusCode = WSStubHostObject.executeHTTPMethod((HttpMethod)httpMethod, wsdlURL, null, null);
            if (statusCode != 200) {
                throw new ScriptException("An error occured while getting the WSDL at " + wsdlURL + ". Reason :" + httpMethod.getStatusLine());
            }
            InputStream inputStream = httpMethod.getResponseBodyAsStream();
            String string = this.getStub(type, this.readStream(inputStream), url);
            return string;
        }
        catch (IOException e) {
            throw new ScriptException((Exception)e);
        }
        finally {
            httpMethod.releaseConnection();
        }
    }

    private ByteArrayOutputStream readStream(InputStream ins) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[1024];
            while ((len = ins.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return baos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getStub(String type, ByteArrayOutputStream wsdlbaos, String uri) throws ScriptException {
        ByteArrayOutputStream stubOutStream = new ByteArrayOutputStream();
        try {
            OMElement documentElement = (OMElement)XMLUtils.toOM((InputStream)new ByteArrayInputStream(wsdlbaos.toByteArray()));
            OMNamespace documentElementNS = documentElement.getNamespace();
            InputStream wsdl20InputStream = null;
            if (documentElementNS == null) throw new ScriptException("Invalid WSDL");
            if ("http://schemas.xmlsoap.org/wsdl/".equals(documentElementNS.getNamespaceURI())) {
                wsdl20InputStream = XSLTTransformer.getWSDL2(new ByteArrayInputStream(wsdlbaos.toByteArray()), null);
            } else {
                if (!"http://www.w3.org/ns/wsdl".equals(documentElementNS.getNamespaceURI())) throw new ScriptException("Invalid WSDL");
                wsdl20InputStream = new ByteArrayInputStream(wsdlbaos.toByteArray());
            }
            DOMSource sigStream = XSLTTransformer.getSigStream(wsdl20InputStream, null);
            StreamResult result = new StreamResult(stubOutStream);
            HashMap<String, String> paramMap = null;
            if ("e4x".equals(type)) {
                paramMap = new HashMap<String, String>();
                paramMap.put("e4x", "true");
            }
            XSLTTransformer.generateStub(sigStream, result, paramMap);
            return stubOutStream.toString();
        }
        catch (XMLStreamException e) {
            throw new ScriptException((Exception)e);
        }
        catch (TransformerException e) {
            throw new ScriptException((Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new ScriptException((Exception)e);
        }
    }

    public static int executeHTTPMethod(HttpMethod method, URL targetURL, String username, String password) throws IOException {
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpClient httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        method.setPath(targetURL.getPath());
        method.setQueryString(targetURL.getQuery());
        method.setRequestHeader("Host", targetURL.getHost());
        method.getParams().setCookiePolicy("ignoreCookies");
        if (username != null && password != null) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(username, password);
            int port = targetURL.getPort();
            httpClient.getState().setCredentials(new AuthScope(targetURL.getHost(), port), (Credentials)creds);
        }
        return httpClient.executeMethod(method);
    }
}

