/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.stream.StreamHostObject;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WebSocketHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(WebSocketHostObject.class);
    private static final String hostObjectName = "WebSocket";
    private Context context;
    private MessageInbound inbound;
    private Function textCallback = null;
    private Function binaryCallback = null;

    public String getClassName() {
        return hostObjectName;
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        int argsCount = args.length;
        if (argsCount != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        WebSocketHostObject who = new WebSocketHostObject();
        who.context = cx;
        return who;
    }

    public void jsSet_ontext(Object outPutMessage) throws ScriptException {
        if (!(outPutMessage instanceof Function)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"ontext", (String)"function", (Object)outPutMessage);
        }
        this.textCallback = (Function)outPutMessage;
    }

    public Scriptable jsGet_ontext() {
        return this.textCallback;
    }

    public void jsSet_onbinary(Object outPutMessage) throws ScriptException {
        if (!(outPutMessage instanceof Function)) {
            HostObjectUtil.invalidProperty((String)hostObjectName, (String)"onbinary", (String)"function", (Object)outPutMessage);
        }
        this.binaryCallback = (Function)outPutMessage;
    }

    public Scriptable jsGet_onbinary() {
        return this.binaryCallback;
    }

    public static void jsFunction_send(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "send";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String) && !(args[1] instanceof StreamHostObject)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string | Stream", (Object)args[0], (boolean)false);
        }
        WebSocketHostObject who = (WebSocketHostObject)thisObj;
        if (args[0] instanceof String) {
            try {
                who.inbound.getWsOutbound().writeTextMessage(CharBuffer.wrap((String)args[0]));
            }
            catch (IOException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
        }
        StreamHostObject sho = (StreamHostObject)args[0];
        InputStream is = sho.getStream();
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                who.inbound.getWsOutbound().writeBinaryMessage(ByteBuffer.wrap(buffer, 0, length));
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException((Exception)e);
        }
    }

    public void setInbound(MessageInbound inbound) {
        this.inbound = inbound;
    }

    public void processText(CharBuffer charBuffer) {
        if (this.textCallback == null) {
            return;
        }
        this.textCallback.call(this.context, (Scriptable)this, (Scriptable)this, new Object[]{charBuffer.toString()});
    }

    public void processBinary(ByteBuffer byteBuffer) {
        if (this.binaryCallback == null) {
            return;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(byteBuffer.array());
        StreamHostObject sho = (StreamHostObject)this.context.newObject((Scriptable)this, "Stream", new Object[]{bis});
        this.binaryCallback.call(this.context, (Scriptable)this, (Scriptable)this, new Object[]{sho});
    }
}

