/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.registry;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.jaggeryjs.hostobjects.registry.CollectionHostObject;
import org.jaggeryjs.hostobjects.registry.RegistryHostObjectContext;
import org.jaggeryjs.hostobjects.registry.ResourceHostObject;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.util.HostObjectUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.common.TagCount;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.registry.search.beans.AdvancedSearchResultsBean;
import org.wso2.carbon.registry.search.beans.CustomSearchParameterBean;
import org.wso2.carbon.registry.search.services.utils.AdvancedSearchResultsBeanPopulator;
import org.wso2.carbon.registry.search.services.utils.SearchUtils;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class RegistryHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(RegistryHostObject.class);
    private static final String hostObjectName = "MetadataStore";
    private UserRegistry registry = null;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        int argsCount = args.length;
        if (args.length > 2 && args.length != 0) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)hostObjectName, (int)argsCount, (boolean)true);
        }
        RegistryHostObject rho = new RegistryHostObject();
        rho.registry = args.length == 2 ? RegistryHostObject.getRegistry((String)args[0], (String)args[1]) : RegistryHostObject.getRegistry((String)args[0]);
        return rho;
    }

    public String getClassName() {
        return hostObjectName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void jsFunction_remove(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject rho = (RegistryHostObject)thisObj;
        if (arguments.length != 1) throw new ScriptException("Invalid no. of arguments for delete() method");
        if (!(arguments[0] instanceof String)) throw new ScriptException("Path argument of method delete() should be a string");
        try {
            rho.registry.delete((String)arguments[0]);
            return;
        }
        catch (RegistryException e) {
            throw new ScriptException("Registry error occurred while executing delete() operation", (Exception)((Object)e));
        }
    }

    public static Scriptable jsFunction_get(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject rho = (RegistryHostObject)thisObj;
        if (arguments.length == 1) {
            if (arguments[0] instanceof String) {
                try {
                    Resource resource = rho.registry.get((String)arguments[0]);
                    Scriptable hostObject = resource instanceof Collection ? cx.newObject((Scriptable)rho, "Collection", new Object[]{resource}) : cx.newObject((Scriptable)rho, "Resource", new Object[]{resource});
                    return hostObject;
                }
                catch (RegistryException e) {
                    throw new ScriptException("Registry error occurred while executing get() operation", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Path argument of method get() should be a string");
        }
        if (arguments.length == 3) {
            if (arguments[0] instanceof String && arguments[1] instanceof Number && arguments[2] instanceof Number) {
                try {
                    Collection collection = rho.registry.get((String)arguments[0], ((Number)arguments[1]).intValue(), ((Number)arguments[2]).intValue());
                    CollectionHostObject cho = (CollectionHostObject)cx.newObject((Scriptable)rho, "Collection", new Object[]{collection});
                    return cho;
                }
                catch (RegistryException e) {
                    throw new ScriptException("Registry error occurred while executing get() operation", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Invalid argument types for get() method");
        }
        throw new ScriptException("Invalid no. of arguments for get() method");
    }

    public static String jsFunction_put(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject rho = (RegistryHostObject)thisObj;
        if (arguments.length == 2) {
            if (arguments[0] instanceof String && arguments[1] instanceof Scriptable) {
                ResourceHostObject reho = (ResourceHostObject)((Object)arguments[1]);
                try {
                    return rho.registry.put((String)arguments[0], reho.getResource());
                }
                catch (RegistryException e) {
                    throw new ScriptException("Registry error occurred while executing get() operation", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Invalid argument types for put() method");
        }
        throw new ScriptException("Invalid no. of arguments for put() method");
    }

    public static Scriptable jsFunction_newCollection(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject rho = (RegistryHostObject)thisObj;
        if (arguments.length == 0) {
            if (rho.registry != null) {
                try {
                    Collection collection = rho.registry.newCollection();
                    CollectionHostObject cho = (CollectionHostObject)cx.newObject((Scriptable)rho, "Collection", new Object[]{collection});
                    return cho;
                }
                catch (RegistryException e) {
                    throw new ScriptException("Error occurred while creating a new Collection", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Registry has not initialized");
        }
        throw new ScriptException("newCollection() Method doesn't accept arguments");
    }

    public static Scriptable jsFunction_newResource(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 0) {
            if (registryHostObject.registry != null) {
                try {
                    Resource resource = registryHostObject.registry.newResource();
                    ResourceHostObject rho = (ResourceHostObject)cx.newObject((Scriptable)registryHostObject, "Resource", new Object[]{resource});
                    return rho;
                }
                catch (RegistryException e) {
                    throw new ScriptException("Error occurred while creating a new Resource", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Registry has not initialized");
        }
        throw new ScriptException("newResource() Method doesn't accept arguments");
    }

    public static boolean jsFunction_resourceExists(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length == 1) {
            if (arguments[0] instanceof String) {
                try {
                    return registryHostObject.registry.resourceExists((String)arguments[0]);
                }
                catch (RegistryException e) {
                    throw new ScriptException("Error occurred while creating a new Resource", (Exception)((Object)e));
                }
            }
            throw new ScriptException("Invalid argument types for resourceExists() method");
        }
        throw new ScriptException("Invalid no. of arguments");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void jsFunction_createLink(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length != 2) throw new ScriptException("Invalid no. of arguments");
        if (!(arguments[0] instanceof String) || !(arguments[1] instanceof String)) throw new ScriptException("Invalid argument types for createLink() method");
        try {
            registryHostObject.registry.createLink((String)arguments[0], (String)arguments[1]);
            return;
        }
        catch (RegistryException e) {
            throw new ScriptException("Error occurred while creating a Link", (Exception)((Object)e));
        }
    }

    public static void jsFunction_addRating(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "addRating";
        int argsCount = args.length;
        if (argsCount != 2) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof Number)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"number", (Object)args[1], (boolean)false);
        }
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        try {
            registryHostObject.registry.rateResource((String)args[0], ((Number)args[1]).intValue());
        }
        catch (RegistryException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public static void jsFunction_addComment(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "addComment";
        int argsCount = args.length;
        if (argsCount != 2) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        try {
            registryHostObject.registry.addComment((String)args[0], new Comment((String)args[1]));
        }
        catch (RegistryException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public static Number jsFunction_getRating(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getRating";
        int argsCount = args.length;
        if (argsCount != 2) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        if (!(args[1] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"2", (String)"string", (Object)args[1], (boolean)false);
        }
        try {
            return registryHostObject.registry.getRating((String)args[0], (String)args[1]);
        }
        catch (RegistryException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public static Number jsFunction_getAvgRating(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getAvgRating";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        try {
            return Float.valueOf(registryHostObject.registry.getAverageRating((String)args[0]));
        }
        catch (RegistryException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public static Scriptable jsFunction_getComments(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "getComments";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof String)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"string", (Object)args[0], (boolean)false);
        }
        try {
            Comment[] comments;
            ArrayList<ScriptableObject> commentsArray = new ArrayList<ScriptableObject>();
            RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
            for (Comment comment : comments = registryHostObject.registry.getComments((String)args[0])) {
                ScriptableObject commentObj = (ScriptableObject)cx.newObject(thisObj);
                commentObj.put("cid", (Scriptable)commentObj, (Object)comment.getCommentID());
                commentObj.put("author", (Scriptable)commentObj, (Object)comment.getUser());
                commentObj.put("content", (Scriptable)commentObj, (Object)comment.getText());
                commentObj.put("created", (Scriptable)commentObj, (Object)comment.getCreatedTime().getTime());
                commentsArray.add(commentObj);
            }
            return cx.newArray(thisObj, commentsArray.toArray());
        }
        catch (RegistryException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public static Scriptable jsFunction_search(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws ScriptException {
        String functionName = "search";
        int argsCount = args.length;
        if (argsCount != 1) {
            HostObjectUtil.invalidNumberOfArgs((String)hostObjectName, (String)functionName, (int)argsCount, (boolean)false);
        }
        if (!(args[0] instanceof NativeObject)) {
            HostObjectUtil.invalidArgsError((String)hostObjectName, (String)functionName, (String)"1", (String)"json", (Object)args[0], (boolean)false);
        }
        NativeObject options = (NativeObject)args[0];
        CustomSearchParameterBean parameters = new CustomSearchParameterBean();
        String path = null;
        ArrayList<String[]> values = new ArrayList<String[]>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        for (Object idObj : options.getIds()) {
            String val;
            String id = (String)idObj;
            Object value = options.get(id, (Scriptable)options);
            if (value == null || value instanceof Undefined) continue;
            if ("path".equals(id)) {
                path = (String)value;
                continue;
            }
            if ("createdBefore".equals(id) || "createdAfter".equals(id) || "updatedBefore".equals(id) || "updatedAfter".equals(id)) {
                long t = value instanceof Number ? ((Number)value).longValue() : Long.parseLong(HostObjectUtil.serializeObject((Object)value));
                val = new String(dateFormat.format(new Date(t)).getBytes());
            } else {
                val = HostObjectUtil.serializeObject((Object)value);
            }
            values.add(new String[]{id, val});
        }
        parameters.setParameterValues((String[][])values.toArray((T[])new String[0][0]));
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            UserRegistry userRegistry = RegistryHostObjectContext.getRegistryService().getRegistry(registryHostObject.registry.getUserName(), tenantId);
            UserRegistry configRegistry = RegistryHostObjectContext.getRegistryService().getConfigSystemRegistry(tenantId);
            AdvancedSearchResultsBean resultsBean = registryHostObject.search((Registry)configRegistry, userRegistry, parameters);
            if (resultsBean.getResourceDataList() == null) {
                ScriptableObject error = (ScriptableObject)cx.newObject(thisObj);
                error.put("error", (Scriptable)error, (Object)true);
                error.put("description", (Scriptable)error, (Object)resultsBean.getErrorMessage());
                return error;
            }
            ArrayList<ScriptableObject> results = new ArrayList<ScriptableObject>();
            for (ResourceData resourceData : resultsBean.getResourceDataList()) {
                String resourcePath = resourceData.getResourcePath();
                if (path != null && !resourcePath.startsWith(path)) continue;
                ScriptableObject result = (ScriptableObject)cx.newObject(thisObj);
                result.put("author", (Scriptable)result, (Object)resourceData.getAuthorUserName());
                result.put("rating", (Scriptable)result, (Object)Float.valueOf(resourceData.getAverageRating()));
                result.put("created", (Scriptable)result, (Object)resourceData.getCreatedOn().getTime().getTime());
                result.put("description", (Scriptable)result, (Object)resourceData.getDescription());
                result.put("name", (Scriptable)result, (Object)resourceData.getName());
                result.put("path", (Scriptable)result, (Object)resourceData.getResourcePath());
                ArrayList<ScriptableObject> tags = new ArrayList<ScriptableObject>();
                if (resourceData.getTagCounts() != null) {
                    for (TagCount tagCount : resourceData.getTagCounts()) {
                        ScriptableObject tag = (ScriptableObject)cx.newObject(thisObj);
                        tag.put("name", (Scriptable)tag, (Object)tagCount.getKey());
                        tag.put("count", (Scriptable)tag, (Object)tagCount.getValue());
                        tags.add(tag);
                    }
                }
                result.put("tags", (Scriptable)result, (Object)cx.newArray(thisObj, tags.toArray()));
                results.add(result);
            }
            return cx.newArray(thisObj, results.toArray());
        }
        catch (RegistryException e) {
            throw new ScriptException((Exception)((Object)e));
        }
        catch (CarbonException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void jsFunction_copy(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        RegistryHostObject registryHostObject = (RegistryHostObject)thisObj;
        if (arguments.length != 2) throw new ScriptException("Invalid no. of arguments");
        if (!(arguments[0] instanceof String) || !(arguments[1] instanceof String)) throw new ScriptException("Invalid argument types for copy() method");
        try {
            registryHostObject.registry.copy((String)arguments[0], (String)arguments[1]);
            return;
        }
        catch (RegistryException e) {
            throw new ScriptException("Error occurred while coping the resource", (Exception)((Object)e));
        }
    }

    private AdvancedSearchResultsBean search(Registry configSystemRegistry, UserRegistry registry, CustomSearchParameterBean parameters) throws CarbonException {
        RegistryUtils.recordStatistics((Object[])new Object[]{parameters});
        String[][] tempParameterValues = parameters.getParameterValues();
        boolean allEmpty = true;
        for (String[] tempParameterValue : tempParameterValues) {
            if (!(tempParameterValue[1] != null & tempParameterValue[1].trim().length() > 0)) continue;
            allEmpty = false;
            if (tempParameterValue[0].equals("createdAfter") || tempParameterValue[0].equals("createdBefore") || tempParameterValue[0].equals("updatedAfter") || tempParameterValue[0].equals("updatedBefore")) {
                if (SearchUtils.validateDateInput((String)tempParameterValue[1])) continue;
                String message = tempParameterValue[0] + " contains illegal characters";
                return SearchUtils.getEmptyResultBeanWithErrorMsg((String)message);
            }
            if (tempParameterValue[0].equals("mediaType")) {
                if (!SearchUtils.validateMediaTypeInput((String)tempParameterValue[1])) continue;
                String message = tempParameterValue[0] + " contains illegal characters";
                return SearchUtils.getEmptyResultBeanWithErrorMsg((String)message);
            }
            if (tempParameterValue[0].equals("content")) {
                if (!SearchUtils.validateContentInput((String)tempParameterValue[1])) continue;
                String message = tempParameterValue[0] + " contains illegal characters";
                return SearchUtils.getEmptyResultBeanWithErrorMsg((String)message);
            }
            if (tempParameterValue[0].equals("tags")) {
                String message;
                boolean containsTag = false;
                for (String str : tempParameterValue[1].split(",")) {
                    if (str.trim().length() <= 0) continue;
                    containsTag = true;
                    break;
                }
                if (!containsTag) {
                    message = tempParameterValue[0] + " contains illegal characters";
                    return SearchUtils.getEmptyResultBeanWithErrorMsg((String)message);
                }
                if (!SearchUtils.validateTagsInput((String)tempParameterValue[1])) continue;
                message = tempParameterValue[0] + " contains illegal characters";
                return SearchUtils.getEmptyResultBeanWithErrorMsg((String)message);
            }
            if (!SearchUtils.validatePathInput((String)tempParameterValue[1])) continue;
            String message = tempParameterValue[0] + " contains illegal characters";
            return SearchUtils.getEmptyResultBeanWithErrorMsg((String)message);
        }
        if (allEmpty) {
            return SearchUtils.getEmptyResultBeanWithErrorMsg((String)"At least one field must be filled");
        }
        boolean onlyContent = true;
        for (String[] tempParameterValue : tempParameterValues) {
            if (tempParameterValue[0].equals("content") || tempParameterValue[0].equals("leftOp") || tempParameterValue[0].equals("rightOp") || tempParameterValue[1] == null || tempParameterValue[1].length() <= 0) continue;
            onlyContent = false;
            break;
        }
        for (String[] tempParameterValue : tempParameterValues) {
            ResourceData[] contentSearchResourceData;
            if (!tempParameterValue[0].equals("content") || tempParameterValue[1] == null || tempParameterValue[1].length() <= 0) continue;
            try {
                contentSearchResourceData = this.search(registry, tempParameterValue[1]);
            }
            catch (Exception e) {
                AdvancedSearchResultsBean metaDataSearchResultsBean = new AdvancedSearchResultsBean();
                metaDataSearchResultsBean.setErrorMessage(e.getMessage());
                return metaDataSearchResultsBean;
            }
            if (contentSearchResourceData != null && contentSearchResourceData.length > 0) {
                HashMap<String, ResourceData> aggregatedMap = new HashMap<String, ResourceData>();
                for (ResourceData resourceData : contentSearchResourceData) {
                    aggregatedMap.put(resourceData.getResourcePath(), resourceData);
                }
                AdvancedSearchResultsBean metaDataSearchResultsBean = AdvancedSearchResultsBeanPopulator.populate((Registry)configSystemRegistry, (UserRegistry)registry, (CustomSearchParameterBean)parameters);
                if (metaDataSearchResultsBean != null) {
                    ResourceData[] metaDataResourceData = metaDataSearchResultsBean.getResourceDataList();
                    if (metaDataResourceData != null && metaDataResourceData.length > 0) {
                        ArrayList<String> invalidKeys = new ArrayList<String>();
                        for (String key : aggregatedMap.keySet()) {
                            boolean keyFound = false;
                            for (ResourceData resourceData : metaDataResourceData) {
                                if (!resourceData.getResourcePath().equals(key)) continue;
                                keyFound = true;
                                break;
                            }
                            if (keyFound) continue;
                            invalidKeys.add(key);
                        }
                        for (String invalidKey : invalidKeys) {
                            aggregatedMap.remove(invalidKey);
                        }
                    } else if (!onlyContent) {
                        aggregatedMap.clear();
                    }
                }
                ArrayList sortedList = new ArrayList(aggregatedMap.values());
                SearchUtils.sortResourceDataList(sortedList);
                metaDataSearchResultsBean = new AdvancedSearchResultsBean();
                metaDataSearchResultsBean.setResourceDataList(sortedList.toArray(new ResourceData[sortedList.size()]));
                return metaDataSearchResultsBean;
            }
            AdvancedSearchResultsBean metaDataSearchResultsBean = new AdvancedSearchResultsBean();
            metaDataSearchResultsBean.setResourceDataList(contentSearchResourceData);
            return metaDataSearchResultsBean;
        }
        return AdvancedSearchResultsBeanPopulator.populate((Registry)configSystemRegistry, (UserRegistry)registry, (CustomSearchParameterBean)parameters);
    }

    private ResourceData[] search(UserRegistry registry, String searchQuery) throws IndexerException, RegistryException {
        SolrClient client = SolrClient.getInstance();
        SolrDocumentList results = client.query(searchQuery, registry.getTenantId());
        if (log.isDebugEnabled()) {
            log.debug((Object)("result received " + results));
        }
        ArrayList<ResourceData> filteredResults = new ArrayList<ResourceData>();
        int i = 0;
        while ((long)i < results.getNumFound()) {
            SolrDocument solrDocument = (SolrDocument)results.get(i);
            String path = this.getPathFromId((String)solrDocument.getFirstValue("id"));
            if (registry.resourceExists(path) && this.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                filteredResults.add(this.loadResourceByPath(registry, path));
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("filtered results " + filteredResults + " for user " + registry.getUserName()));
        }
        return filteredResults.toArray(new ResourceData[0]);
    }

    private String getPathFromId(String id) {
        return id.substring(0, id.lastIndexOf("tenantId"));
    }

    private ResourceData loadResourceByPath(UserRegistry registry, String path) throws RegistryException {
        Resource child;
        ResourceData resourceData = new ResourceData();
        resourceData.setResourcePath(path);
        if (path != null) {
            if ("/".equals(path)) {
                resourceData.setName("root");
            } else {
                String[] parts = path.split("/");
                resourceData.setName(parts[parts.length - 1]);
            }
        }
        resourceData.setResourceType((child = registry.get(path)) instanceof Collection ? "collection" : "resource");
        resourceData.setAuthorUserName(child.getAuthorUserName());
        resourceData.setDescription(child.getDescription());
        resourceData.setAverageRating(registry.getAverageRating(child.getPath()));
        Calendar createdDateTime = Calendar.getInstance();
        createdDateTime.setTime(child.getCreatedTime());
        resourceData.setCreatedOn(createdDateTime);
        CommonUtil.populateAverageStars((ResourceData)resourceData);
        child.discard();
        return resourceData;
    }

    private static UserRegistry getRegistry(String username, String password) throws ScriptException {
        UserRegistry registry;
        RegistryService registryService = RegistryHostObjectContext.getRegistryService();
        String tDomain = PrivilegedCarbonContext.getCurrentContext().getTenantDomain(false);
        try {
            int tId = RegistryHostObjectContext.getRealmService().getTenantManager().getTenantId(tDomain);
            registry = registryService.getGovernanceUserRegistry(username, password, tId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException(e);
        }
        if (registry == null) {
            String msg = "User governance registry cannot be retrieved";
            throw new ScriptException(msg);
        }
        return registry;
    }

    private static UserRegistry getRegistry(String username) throws ScriptException {
        UserRegistry registry;
        RegistryService registryService = RegistryHostObjectContext.getRegistryService();
        String tDomain = PrivilegedCarbonContext.getCurrentContext().getTenantDomain(false);
        try {
            int tId = RegistryHostObjectContext.getRealmService().getTenantManager().getTenantId(tDomain);
            registry = registryService.getGovernanceUserRegistry(username, tId);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ScriptException(e);
        }
        if (registry == null) {
            String msg = "User governance registry cannot be retrieved";
            throw new ScriptException(msg);
        }
        return registry;
    }

    private boolean isAuthorized(UserRegistry registry, String resourcePath, String action) throws RegistryException {
        UserRealm userRealm = registry.getUserRealm();
        String userName = registry.getUserName();
        try {
            if (!userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, action)) {
                return false;
            }
        }
        catch (UserStoreException e) {
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException("Error at Authorizing " + resourcePath + " with user " + userName + ":" + e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

