/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.email;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.FileHostObject;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.wso2.javascript.xmlimpl.XML;

public class SenderHostObject
extends ScriptableObject {
    private static final Log log = LogFactory.getLog(SenderHostObject.class);
    private Properties properties;
    private MimeMessage message;
    private String text;
    private String html;
    Multipart multipart;

    public String getClassName() {
        return "Sender";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) throws ScriptException {
        String password;
        String username;
        String host;
        Properties props;
        SenderHostObject senderHostObject = new SenderHostObject();
        senderHostObject.properties = props = new Properties();
        senderHostObject.multipart = new MimeMultipart();
        String port = null;
        int length = args.length;
        if (length == 5) {
            host = (String)args[0];
            port = (String)args[1];
            username = (String)args[2];
            password = (String)args[3];
            String tls = (String)args[4];
            if (!"tls".equals(tls)) throw new ScriptException("Fifth property has to be : tls");
            senderHostObject.setProperty("mail.smtp.starttls.enable", "true");
        } else {
            if (length != 4) throw new ScriptException("Incorrect number of arguments. Please specify host, username, password or host, port, username, password within the constructor of Sender hostobject.");
            host = (String)args[0];
            port = (String)args[1];
            username = (String)args[2];
            password = (String)args[3];
            senderHostObject.setProperty("mail.smtp.starttls.enable", "false");
        }
        if (host == null) {
            throw new ScriptException("Invalid host name. Please recheck the given details within the constructor of Sender hostobject.");
        }
        senderHostObject.setProperty("mail.smtp.host", host);
        if (port != null) {
            senderHostObject.setProperty("mail.smtp.port", port);
        }
        SMTPAuthenticator smtpAuthenticator = null;
        if (username != null) {
            smtpAuthenticator = new SMTPAuthenticator(username, password);
            senderHostObject.setProperty("mail.smtp.auth", "true");
        }
        Session session = Session.getInstance((Properties)props, smtpAuthenticator);
        senderHostObject.message = new MimeMessage(session);
        return senderHostObject;
    }

    private void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void jsSet_from(String from) throws ScriptException {
        try {
            this.message.setFrom((Address)new InternetAddress(from));
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public String jsGet_from() throws MessagingException {
        String from = null;
        Address[] addresses = this.message.getFrom();
        if (addresses != null && addresses.length > 0) {
            from = addresses[0].toString();
        }
        return from;
    }

    public String[] jsGet_to() throws ScriptException {
        Address[] addresses;
        try {
            addresses = this.message.getRecipients(Message.RecipientType.TO);
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
        String[] to = new String[addresses.length];
        for (int i = 0; i < to.length; ++i) {
            to[i] = addresses[i].toString();
        }
        return to;
    }

    public void jsSet_to(Object toObject) throws ScriptException {
        this.addRecipients(Message.RecipientType.TO, toObject);
    }

    public String[] jsGet_cc() throws ScriptException {
        Address[] addresses;
        try {
            addresses = this.message.getRecipients(Message.RecipientType.CC);
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
        String[] cc = new String[addresses.length];
        for (int i = 0; i < cc.length; ++i) {
            cc[i] = addresses[i].toString();
        }
        return cc;
    }

    public void jsSet_cc(Object ccObject) throws ScriptException {
        this.addRecipients(Message.RecipientType.CC, ccObject);
    }

    public String[] jsGet_bcc() throws ScriptException {
        Address[] addresses;
        try {
            addresses = this.message.getRecipients(Message.RecipientType.BCC);
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
        String[] bcc = new String[addresses.length];
        for (int i = 0; i < bcc.length; ++i) {
            bcc[i] = addresses[i].toString();
        }
        return bcc;
    }

    public void jsSet_bcc(Object bccObject) throws ScriptException {
        this.addRecipients(Message.RecipientType.BCC, bccObject);
    }

    public void jsSet_subject(String subject) throws ScriptException {
        try {
            this.message.setSubject(subject);
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public String jsGet_subject() throws ScriptException {
        try {
            return this.message.getSubject();
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public void jsSet_text(String text) throws ScriptException {
        this.text = text;
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        try {
            messageBodyPart.setText(text);
            this.multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public String jsGet_text() {
        return this.text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void jsSet_html(Object html) throws ScriptException {
        if (html instanceof String) {
            this.html = (String)html;
        } else {
            if (!(html instanceof XML)) throw new ScriptException("Invalid input argument. The html function accepts either a String or an XML element.");
            OMNode node = ((XML)html).getAxiomFromXML();
            if (!(node instanceof OMElement)) throw new ScriptException("Invalid input argument. The html function accepts either a String or an XML element.");
            OMElement htmlElement = (OMElement)node;
            this.html = htmlElement.toString();
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        DataHandler dataHandler = null;
        try {
            dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(this.html, "text/html"));
            messageBodyPart.setDataHandler(dataHandler);
            this.multipart.addBodyPart((BodyPart)messageBodyPart);
            return;
        }
        catch (IOException e) {
            throw new ScriptException((Exception)e);
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public String jsGet_html() {
        return this.html;
    }

    public void jsFunction_send() throws ScriptException {
        try {
            this.message.setContent(this.multipart);
            Transport.send((Message)this.message);
        }
        catch (MessagingException e) {
            throw new ScriptException((Exception)((Object)e));
        }
    }

    public static void jsFunction_addAttachment(Context cx, Scriptable thisObj, Object[] arguments, Function funObj) throws ScriptException {
        SenderHostObject senderHostObject = (SenderHostObject)thisObj;
        for (Object argument : arguments) {
            FileHostObject fileHostObject;
            Object object = argument;
            if (object instanceof FileHostObject) {
                fileHostObject = (FileHostObject)object;
            } else if (object instanceof String) {
                fileHostObject = (FileHostObject)cx.newObject((Scriptable)senderHostObject, "File", new Object[]{object});
            } else {
                throw new ScriptException("Invalid parameter. The attachment should be a FileHostObject or a string representing the path of a file");
            }
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            DataSource source = new DataSource(){

                public InputStream getInputStream() throws IOException {
                    try {
                        return fileHostObject.getInputStream();
                    }
                    catch (ScriptException e) {
                        throw new IOException(e);
                    }
                }

                public OutputStream getOutputStream() throws IOException {
                    try {
                        return fileHostObject.getOutputStream();
                    }
                    catch (ScriptException e) {
                        throw new IOException(e);
                    }
                }

                public String getContentType() {
                    return null;
                }

                public String getName() {
                    try {
                        return fileHostObject.getName();
                    }
                    catch (ScriptException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
            };
            try {
                messageBodyPart.setDataHandler(new DataHandler(source));
                messageBodyPart.setFileName(fileHostObject.getName());
                senderHostObject.multipart.addBodyPart((BodyPart)messageBodyPart);
            }
            catch (MessagingException e) {
                throw new ScriptException((Exception)((Object)e));
            }
        }
    }

    private void addRecipients(Message.RecipientType recipientType, Object recipientObject) throws ScriptException {
        block9: {
            try {
                if (recipientObject instanceof String[]) {
                    String[] to = (String[])recipientObject;
                    InternetAddress[] recipientAddresses = new InternetAddress[to.length];
                    for (int i = 0; i < to.length; ++i) {
                        recipientAddresses[i] = new InternetAddress(to[i]);
                    }
                    this.message.addRecipients(recipientType, (Address[])recipientAddresses);
                    break block9;
                }
                if (recipientObject instanceof NativeArray) {
                    NativeArray nativeArray = (NativeArray)recipientObject;
                    Object[] objects = nativeArray.getIds();
                    for (int i = 0; i < objects.length; ++i) {
                        Object o;
                        Object property;
                        Object object = objects[i];
                        if (object instanceof String) {
                            property = (String)object;
                            o = nativeArray.get((String)property, (Scriptable)nativeArray);
                        } else {
                            property = (Integer)object;
                            o = nativeArray.get(((Integer)property).intValue(), (Scriptable)nativeArray);
                        }
                        this.message.addRecipient(recipientType, (Address)new InternetAddress((String)o));
                    }
                    break block9;
                }
                if (recipientObject instanceof String) {
                    this.message.addRecipient(recipientType, (Address)new InternetAddress((String)recipientObject));
                    break block9;
                }
                throw new ScriptException("The argument to this function should be an array of email addresses or a single email address");
            }
            catch (MessagingException e) {
                throw new ScriptException((Exception)((Object)e));
            }
        }
    }

    private static class SMTPAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        private SMTPAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

