/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.tomcat.ext.valves.CarbonTomcatValve;
import org.wso2.carbon.tomcat.ext.valves.CompositeValve;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployer;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.utils.GhostWebappDeployerUtils;

public class GhostWebappDeployerValve
extends CarbonTomcatValve {
    private static final Log log = LogFactory.getLog(GhostWebappDeployerValve.class);
    private boolean isGhostOn = GhostDeployerUtils.isGhostOn();

    public void invoke(Request request, Response response, CompositeValve compositeValve) {
        if (!this.isGhostOn) {
            return;
        }
        String requestURI = request.getRequestURI();
        if (requestURI.contains("/carbon/") && !requestURI.contains("/webapp-list/webapp_info.jsp") || requestURI.contains("favicon.ico") || requestURI.contains("/fileupload/") || requestURI.startsWith("/services")) {
            this.getNext().invoke(request, response, compositeValve);
            return;
        }
        String requestedHostName = request.getServerName();
        String uriOfVirtualHost = URLMappingHolder.getInstance().getApplicationFromUrlMapping(requestedHostName);
        if (TomcatUtil.isVirtualHostRequest(requestedHostName).booleanValue() && uriOfVirtualHost == null) {
            uriOfVirtualHost = DataHolder.getHotUpdateService().getApplicationContextForHost(requestedHostName);
        }
        if (uriOfVirtualHost != null) {
            requestURI = uriOfVirtualHost;
        }
        ConfigurationContext currentCtx = requestURI.contains("/t/") ? this.getCurrentConfigurationCtxFromURI(requestURI) : DataHolder.getServerConfigContext();
        WebApplication deployedWebapp = this.getDeployedWebappFromThisURI(request.getContext().getPath(), currentCtx);
        if (deployedWebapp == null) {
            WebApplication transitWebapp;
            String ctxName = request.getContext().getPath();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for webapp in transit map with CtxName: " + ctxName));
            }
            if ((transitWebapp = GhostWebappDeployerUtils.dispatchWebAppFromTransitGhosts(ctxName, currentCtx)) != null) {
                String isBeingUnloaded;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Webapp found in transit map : " + ctxName));
                }
                if ((isBeingUnloaded = (String)transitWebapp.getProperty("isBeingUnloaded")) != null && "true".equals(isBeingUnloaded)) {
                    GhostWebappDeployerUtils.waitForWebAppToLeaveTransit(transitWebapp.getContextName(), currentCtx);
                    this.handleWebapp(transitWebapp.getWebappFile().getName(), currentCtx);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Waiting till webapp leaves transit : " + ctxName));
                    }
                    GhostWebappDeployerUtils.waitForWebAppToLeaveTransit(transitWebapp.getContextName(), currentCtx);
                    try {
                        TomcatUtil.remapRequest((HttpServletRequest)request);
                        return;
                    }
                    catch (Exception e) {
                        log.error((Object)("Error when redirecting response to " + requestURI), (Throwable)e);
                    }
                }
            }
        } else if (GhostWebappDeployerUtils.isGhostWebApp(deployedWebapp)) {
            this.handleWebapp(deployedWebapp.getWebappFile().getName(), currentCtx);
            try {
                TomcatUtil.remapRequest((HttpServletRequest)request);
                return;
            }
            catch (Exception e) {
                log.error((Object)("Error when redirecting response to " + requestURI), (Throwable)e);
            }
        } else {
            GhostWebappDeployerUtils.updateLastUsedTime(deployedWebapp);
        }
        if (!requestURI.contains("/webapp-list/webapp_info.jsp")) {
            this.getNext().invoke(request, response, compositeValve);
            return;
        }
        String webappFileName = request.getParameter("webappFileName");
        this.handleWebapp(webappFileName, currentCtx);
        this.getNext().invoke(request, response, compositeValve);
    }

    private WebApplication getDeployedWebappFromThisURI(String requestURI, ConfigurationContext cfgCtx) {
        WebApplication deployedWebapp = null;
        WebApplicationsHolder webApplicationsHolder = this.getWebApplicationHolder(cfgCtx);
        for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
            if (!requestURI.equals(webApplication.getContextName())) continue;
            deployedWebapp = webApplication;
        }
        return deployedWebapp;
    }

    private WebApplicationsHolder getWebApplicationHolder(ConfigurationContext cfgCtx) {
        WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)cfgCtx.getProperty("carbon.webapps.holder");
        return webApplicationsHolder;
    }

    private void handleWebapp(String webappFileName, ConfigurationContext cfgCtx) {
        WebApplication ghostWebapp;
        WebApplicationsHolder webApplicationsHolder;
        if (webappFileName != null && (webApplicationsHolder = this.getWebApplicationHolder(cfgCtx)) != null && (ghostWebapp = webApplicationsHolder.getStartedWebapps().get(webappFileName)) != null) {
            if (CarbonUtils.isWorkerNode() && GhostDeployerUtils.isPartialUpdateEnabled()) {
                this.handleDepSynchUpdate(cfgCtx, ghostWebapp, webApplicationsHolder);
            }
            GhostWebappDeployerUtils.deployActualWebApp(ghostWebapp, cfgCtx);
        }
    }

    private ConfigurationContext getCurrentConfigurationCtxFromURI(String uri) {
        return TenantAxisUtils.getTenantConfigurationContextFromUrl((String)uri, (ConfigurationContext)DataHolder.getServerConfigContext());
    }

    private synchronized void handleDepSynchUpdate(ConfigurationContext configurationContext, WebApplication webApplication, WebApplicationsHolder webappsHolder) {
        DeploymentSynchronizer depsync;
        String filePath;
        File fileToUpdate;
        String fileName;
        String repoPath;
        String webappType = (String)webApplication.getProperty("webappFilter");
        String deploymentDir = "webapps";
        if (webappType.equals("jaggeryWebapp")) {
            deploymentDir = "jaggeryapps";
        }
        if ((repoPath = configurationContext.getAxisConfiguration().getRepository().getPath()).contains(CarbonConstants.TENANTS_REPO) && GhostWebappDeployerUtils.isGhostWebApp(webApplication) && (fileName = (String)webApplication.getProperty("AppFileName")) != null && !(fileToUpdate = new File(filePath = repoPath + File.separator + deploymentDir + File.separator + fileName)).exists() && (depsync = DataHolder.getDeploymentSynchronizerService()) != null && CarbonUtils.isDepSyncEnabled()) {
            try {
                depsync.update(repoPath, filePath, 3);
                if (fileToUpdate.exists()) {
                    DeploymentFileData dfd = new DeploymentFileData(fileToUpdate);
                    GhostDeployer ghostDeployer = GhostDeployerUtils.getGhostDeployer((AxisConfiguration)configurationContext.getAxisConfiguration());
                    if (ghostDeployer != null && ghostDeployer.getFileData(filePath) == null) {
                        File deployedWebappFile = new File(webApplication.getWebappFile().getName());
                        if (webappsHolder.getStartedWebapps().containsKey(deployedWebappFile.getName())) {
                            webappsHolder.getStartedWebapps().remove(deployedWebappFile.getName());
                        }
                        webApplication.setWebappFile(dfd.getFile());
                        webappsHolder.getStartedWebapps().put(dfd.getFile().getName(), webApplication);
                        ghostDeployer.addFileData(dfd);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)"Deployment synchronization update failed", t);
            }
        }
    }

    private String getCtxNameFromRequestURI(String requestURI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request URI to retrieve CtxName : " + requestURI));
        }
        String ctxName = requestURI;
        if (requestURI.startsWith("/t/")) {
            String tenantDomain = MultitenantUtils.getTenantDomainFromUrl((String)requestURI);
            if (requestURI.contains("webapps") || requestURI.contains("jaxwebapps") || requestURI.contains("jaggeryapps")) {
                String subCtxName = ctxName.substring(ctxName.indexOf(tenantDomain) + tenantDomain.length() + 1);
                if (subCtxName.contains("/")) {
                    subCtxName = subCtxName.substring(subCtxName.indexOf(47) + 1);
                }
                if (subCtxName.contains("/")) {
                    subCtxName = subCtxName.substring(subCtxName.indexOf(47));
                    ctxName = requestURI.substring(0, requestURI.lastIndexOf(subCtxName));
                } else {
                    ctxName = requestURI;
                }
            }
        } else {
            ctxName = requestURI.substring(1);
            ctxName = ctxName.contains("/") ? "/".concat(ctxName.substring(0, ctxName.indexOf(47))) : "/".concat(ctxName);
        }
        return ctxName;
    }
}

