/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.io.File;
import java.net.URL;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.unknowncontent.UnknownContentBuilder;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.ModuleDeployer;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.description.Version;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.engine.Deployable;
import org.apache.axis2.engine.DeployableChain;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.transaction.TransactionConfiguration;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.util.FaultyServiceData;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.TargetResolver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecretResolver;

public class AxisConfiguration
extends AxisDescription {
    private static final Log log = LogFactory.getLog(AxisConfiguration.class);
    private HashMap<String, AxisDataLocator> dataLocators = new HashMap();
    private HashMap<String, String> dataLocatorClassNames = new HashMap();
    private final HashMap<String, AxisModule> allModules = new HashMap();
    private final HashMap<String, String> nameToversionMap = new HashMap();
    private final HashMap<String, TransportInDescription> transportsIn = new HashMap();
    private final HashMap<String, TransportOutDescription> transportsOut = new HashMap();
    private final HashMap<String, List<AxisModule>> policySupportedModules = new HashMap();
    private final ArrayList<QName> localPolicyAssertions = new ArrayList();
    private Set<AxisObserver> observerSet = null;
    private URL axis2Repository = null;
    private Map<String, AxisService> allServices = new ConcurrentHashMap<String, AxisService>();
    private Map<String, AxisService> allEndpoints = new ConcurrentHashMap<String, AxisService>();
    private List<String> globalModuleList;
    private Hashtable<String, String> faultyModules;
    private Hashtable<String, String> faultyServices;
    private final Map<String, Map<String, FaultyServiceData>> faultyServicesDueToModules = new HashMap<String, Map<String, FaultyServiceData>>();
    private List<Phase> inFaultPhases;
    private List<Phase> inPhasesUptoAndIncludingPostDispatch;
    private HashMap<String, MessageReceiver> messageReceivers;
    private HashMap<String, Builder> messageBuilders;
    private HashMap<String, MessageFormatter> messageFormatters;
    private ClassLoader moduleClassLoader;
    private HashMap<String, ModuleConfiguration> moduleConfigmap = new HashMap();
    private List<Phase> outFaultPhases;
    private List<Phase> outPhases;
    protected PhasesInfo phasesinfo;
    private ClassLoader serviceClassLoader;
    private ClassLoader systemClassLoader;
    private boolean start;
    private ArrayList<TargetResolver> targetResolvers;
    private ClusteringAgent clusteringAgent;
    private AxisConfigurator configurator;
    private TransactionConfiguration transactionConfiguration;
    private SecretResolver secretResolver;

    public AxisConfiguration() {
        this.globalModuleList = new ArrayList<String>();
        this.messageReceivers = new HashMap();
        this.messageBuilders = new HashMap();
        this.messageFormatters = new HashMap();
        this.outPhases = new ArrayList<Phase>();
        this.inFaultPhases = new ArrayList<Phase>();
        this.outFaultPhases = new ArrayList<Phase>();
        this.faultyServices = new Hashtable();
        this.faultyModules = new Hashtable();
        this.observerSet = new CopyOnWriteArraySet<AxisObserver>();
        this.inPhasesUptoAndIncludingPostDispatch = new ArrayList<Phase>();
        this.serviceClassLoader = this.systemClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.moduleClassLoader = this.systemClassLoader;
        this.phasesinfo = new PhasesInfo();
        this.targetResolvers = new ArrayList();
    }

    public void addMessageReceiver(String mepURL, MessageReceiver messageReceiver) {
        this.messageReceivers.put(mepURL, messageReceiver);
    }

    public void addMessageBuilder(String contentType, Builder messageBuilder) {
        this.messageBuilders.put(contentType, messageBuilder);
    }

    public void addMessageFormatter(String contentType, MessageFormatter messageFormatter) {
        this.messageFormatters.put(contentType, messageFormatter);
    }

    public void addModule(AxisModule module) throws AxisFault {
        module.setParent(this);
        Parameter versionParameter = module.getParameter("version");
        if (versionParameter != null) {
            String version = (String)versionParameter.getValue();
            try {
                module.setVersion(new Version(version));
            }
            catch (ParseException ex) {
                throw new AxisFault("The version number '" + version + "' specified by the " + "version" + " parameter is invalid");
            }
        }
        this.allModules.put(module.getArchiveName(), module);
        this.notifyObservers(new AxisEvent(4, null), module);
        this.registerModulePolicySupport(module);
        this.registerLocalPolicyAssertions(module);
    }

    public void deployModule(String moduleFileName) throws DeploymentException {
        File moduleFile = new File(moduleFileName);
        if (!moduleFile.exists()) {
            throw new DeploymentException("Module archive '" + moduleFileName + "' doesn't exist");
        }
        DeploymentFileData dfd = new DeploymentFileData(moduleFile, new ModuleDeployer(this));
        dfd.deploy();
    }

    public void removeModule(String module) {
        this.allModules.remove(module);
    }

    public void removeModule(String moduleName, String moduleVersion) {
        this.allModules.remove(Utils.getModuleName(moduleName, moduleVersion));
    }

    public void removeModule(String moduleName, Version moduleVersion) {
        String version = null;
        if (moduleVersion != null) {
            version = moduleVersion.toString();
        }
        this.removeModule(moduleName, version);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    public void addObservers(AxisObserver axisObserver) {
        this.observerSet.add(axisObserver);
    }

    public synchronized void addService(AxisService service) throws AxisFault {
        AxisServiceGroup axisServiceGroup = new AxisServiceGroup();
        axisServiceGroup.setServiceGroupName(service.getName());
        axisServiceGroup.setParent(this);
        axisServiceGroup.addService(service);
        this.addServiceGroup(axisServiceGroup);
    }

    public synchronized void addServiceGroup(AxisServiceGroup axisServiceGroup) throws AxisFault {
        AxisService axisService;
        axisServiceGroup.setParent(this);
        this.notifyObservers(new AxisEvent(1, axisServiceGroup), axisServiceGroup);
        Iterator<AxisService> services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            axisService = services.next();
            if (axisService.getSchemaTargetNamespace() != null) continue;
            axisService.setSchemaTargetNamespace("http://org.apache.axis2/xsd");
        }
        services = axisServiceGroup.getServices();
        while (services.hasNext()) {
            axisService = services.next();
            if (!axisService.isUseDefaultChains()) continue;
            Iterator<AxisOperation> operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation operation = operations.next();
                this.phasesinfo.setOperationPhases(operation);
            }
        }
        Iterator<AxisModule> enModule = this.getEngagedModules().iterator();
        while (enModule.hasNext()) {
            axisServiceGroup.engageModule(enModule.next());
        }
        services = axisServiceGroup.getServices();
        ArrayList<AxisService> servicesIAdded = new ArrayList<AxisService>();
        while (services.hasNext()) {
            axisService = services.next();
            this.processEndpoints(axisService, axisService.getAxisConfiguration());
            Map<String, AxisEndpoint> endpoints = axisService.getEndpoints();
            String serviceName = axisService.getName();
            try {
                this.addToAllServicesMap(axisService);
            }
            catch (AxisFault axisFault) {
                for (AxisService service : servicesIAdded) {
                    this.allServices.remove(service.getName());
                }
                throw axisFault;
            }
            servicesIAdded.add(axisService);
            if (endpoints != null) {
                for (String endpointName : endpoints.keySet()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding service to allEndpoints map: (" + serviceName + "," + endpointName + ") "));
                    }
                    this.allEndpoints.put(serviceName + "." + endpointName, axisService);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("After adding to allEndpoints map, size is " + this.allEndpoints.size()));
                }
            }
            if (axisService.isClientSide()) continue;
            this.notifyObservers(new AxisEvent(1, axisService), axisService);
        }
        this.addChild(axisServiceGroup);
    }

    public void addServiceToExistingServiceGroup(AxisService axisService, String serviceGroupName) throws AxisFault {
        Map<String, AxisEndpoint> endpoints;
        AxisServiceGroup serviceGroup = this.getServiceGroup(serviceGroupName);
        if (serviceGroup == null) {
            String message = "A ServiceGroup with the provided name " + serviceGroupName + " is not existing";
            log.error((Object)message);
            throw new AxisFault(message);
        }
        if (axisService.getSchemaTargetNamespace() == null) {
            axisService.setSchemaTargetNamespace("http://org.apache.axis2/xsd");
        }
        if (axisService.isUseDefaultChains()) {
            Iterator<AxisOperation> operations = axisService.getOperations();
            while (operations.hasNext()) {
                AxisOperation operation = operations.next();
                this.phasesinfo.setOperationPhases(operation);
            }
        }
        if ((endpoints = axisService.getEndpoints()) == null || endpoints.size() == 0) {
            org.apache.axis2.deployment.util.Utils.addEndpointsToService(axisService, axisService.getAxisConfiguration());
            endpoints = axisService.getEndpoints();
        }
        String serviceName = axisService.getName();
        this.addToAllServicesMap(axisService);
        if (endpoints != null) {
            for (String endpointName : endpoints.keySet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding service to allEndpoints map: (" + serviceName + "," + endpointName + ") "));
                }
                this.allEndpoints.put(serviceName + "." + endpointName, axisService);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("After adding to allEndpoints map, size is " + this.allEndpoints.size()));
            }
        }
        serviceGroup.addService(axisService);
        if (!axisService.isClientSide()) {
            this.notifyObservers(new AxisEvent(1, axisService), axisService);
        }
    }

    public void addToAllServicesMap(AxisService axisService) throws AxisFault {
        String serviceName = axisService.getName();
        AxisService oldService = this.allServices.get(serviceName);
        if (oldService == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding service to allServices map: [" + serviceName + "] "));
            }
            this.allServices.put(serviceName, axisService);
            if (log.isTraceEnabled()) {
                log.trace((Object)("After adding to allServices map, size is " + this.allServices.size() + " call stack is " + JavaUtils.stackToString(new Exception())));
            }
        } else if (oldService != axisService) {
            throw new AxisFault(Messages.getMessage("twoservicecannothavesamename", axisService.getName() + " [" + axisService.getFileName() + "]"));
        }
    }

    public AxisServiceGroup removeServiceGroup(String serviceGroupName) throws AxisFault {
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)this.getChild(serviceGroupName);
        if (axisServiceGroup == null) {
            throw new AxisFault(Messages.getMessage("invalidservicegroupname", serviceGroupName));
        }
        Iterator<AxisService> services = axisServiceGroup.getServices();
        boolean isClientSide = false;
        while (services.hasNext()) {
            AxisService axisService = services.next();
            this.allServices.remove(axisService.getName());
            if (!axisService.isClientSide()) {
                this.notifyObservers(new AxisEvent(0, axisService), axisService);
            } else {
                isClientSide = true;
            }
            String serviceName = axisService.getName();
            for (String s : axisService.getEndpoints().keySet()) {
                String key = serviceName + "." + s;
                this.allEndpoints.remove(key);
            }
        }
        this.removeChild(serviceGroupName);
        if (!isClientSide) {
            this.notifyObservers(new AxisEvent(0, axisServiceGroup), axisServiceGroup);
        }
        return axisServiceGroup;
    }

    public void addTransportIn(TransportInDescription transport) throws AxisFault {
        if (transport.getReceiver() == null) {
            throw new AxisFault("Transport Receiver can not be null for the transport " + transport.getName());
        }
        this.transportsIn.put(transport.getName(), transport);
    }

    public void addTransportOut(TransportOutDescription transport) throws AxisFault {
        if (transport.getSender() == null) {
            throw new AxisFault("Transport sender can not be null for the transport " + transport.getName());
        }
        this.transportsOut.put(transport.getName(), transport);
    }

    public void engageModule(QName moduleref) throws AxisFault {
        this.engageModule(moduleref.getLocalPart());
    }

    public void engageModule(String moduleref) throws AxisFault {
        AxisModule module = this.getModule(moduleref);
        if (module == null) {
            throw new AxisFault(Messages.getMessage("modulenotavailble", moduleref));
        }
        this.engageModule(module);
    }

    public void engageModule(String moduleName, String versionID) throws AxisFault {
        String actualName = Utils.getModuleName(moduleName, versionID);
        AxisModule module = this.getModule(actualName);
        if (module == null) {
            throw new AxisFault(Messages.getMessage("refertoinvalidmodule"));
        }
        this.engageModule(module);
    }

    @Override
    public void onEngage(AxisModule module, AxisDescription engager) throws AxisFault {
        Iterator<AxisServiceGroup> servicegroups = this.getServiceGroups();
        while (servicegroups.hasNext()) {
            AxisServiceGroup serviceGroup = servicegroups.next();
            serviceGroup.engageModule(module, engager);
        }
    }

    @Override
    public void onDisengage(AxisModule module) throws AxisFault {
        PhaseResolver phaseResolver = new PhaseResolver(this);
        phaseResolver.disengageModuleFromGlobalChains(module);
        Iterator<AxisServiceGroup> serviceGroups = this.getServiceGroups();
        while (serviceGroups.hasNext()) {
            AxisServiceGroup axisServiceGroup = serviceGroups.next();
            axisServiceGroup.disengageModule(module);
        }
    }

    public void notifyObservers(AxisEvent event, AxisService service) {
        if (service.isClientSide()) {
            return;
        }
        for (AxisObserver observer : this.observerSet) {
            try {
                observer.serviceUpdate(event, service);
            }
            catch (Throwable e) {
                log.error((Object)"Error occured while notifying observer", e);
            }
        }
    }

    public void notifyObservers(AxisEvent event, AxisModule moule) {
        for (AxisObserver anObserversList : this.observerSet) {
            try {
                anObserversList.moduleUpdate(event, moule);
            }
            catch (Throwable e) {
                log.error((Object)"Error occured while notifying observer", e);
            }
        }
    }

    public void notifyObservers(AxisEvent event, AxisServiceGroup serviceGroup) {
        for (AxisObserver anObserversList : this.observerSet) {
            try {
                anObserversList.serviceGroupUpdate(event, serviceGroup);
            }
            catch (Throwable e) {
                log.error((Object)"Error occured while notifying observer", e);
            }
        }
    }

    public synchronized void removeService(String name) throws AxisFault {
        AxisService service = this.allServices.remove(name);
        if (service != null) {
            AxisServiceGroup serviceGroup = service.getAxisServiceGroup();
            serviceGroup.removeService(name);
            log.debug((Object)Messages.getMessage("serviceremoved", name));
        }
    }

    public void addGlobalModuleRef(String moduleName) {
        this.globalModuleList.add(moduleName);
    }

    public void engageGlobalModules() throws AxisFault {
        for (String aGlobalModuleList : this.globalModuleList) {
            this.engageModule(aGlobalModuleList);
        }
    }

    public Hashtable<String, String> getFaultyModules() {
        return this.faultyModules;
    }

    public Hashtable<String, String> getFaultyServices() {
        return this.faultyServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFaultyServiceDuetoModule(String moduleName, FaultyServiceData faultyServiceData) {
        Map<String, Map<String, FaultyServiceData>> map = this.faultyServicesDueToModules;
        synchronized (map) {
            if (this.faultyServicesDueToModules.containsKey(moduleName)) {
                Map<String, FaultyServiceData> faultyServicesMap = this.faultyServicesDueToModules.get(moduleName);
                faultyServicesMap.put(faultyServiceData.getServiceGroupName(), faultyServiceData);
            } else {
                HashMap<String, FaultyServiceData> faultyServicesMap = new HashMap<String, FaultyServiceData>();
                faultyServicesMap.put(faultyServiceData.getServiceGroupName(), faultyServiceData);
                this.faultyServicesDueToModules.put(moduleName, faultyServicesMap);
            }
            String serviceStatus = "Error:\nEngaged module not found :" + moduleName;
            String serviceLocation = null;
            if (faultyServiceData.getCurrentDeploymentFile() != null) {
                serviceLocation = faultyServiceData.getCurrentDeploymentFile().getFile().getAbsolutePath();
            }
            if (serviceLocation == null) {
                serviceLocation = faultyServiceData.getServiceGroupName();
            }
            this.faultyServices.put(serviceLocation, serviceStatus);
        }
    }

    public Map<String, FaultyServiceData> getFaultyServicesDuetoModule(String moduleName) {
        if (this.faultyServicesDueToModules.containsKey(moduleName)) {
            return this.faultyServicesDueToModules.get(moduleName);
        }
        return new HashMap<String, FaultyServiceData>(1);
    }

    public Map<String, Map<String, FaultyServiceData>> getFaultyServicesDuetoModules() {
        return this.faultyServicesDueToModules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFaultyServiceDuetoModule(String moduleName, String serviceGroupName) {
        Map<String, Map<String, FaultyServiceData>> map = this.faultyServicesDueToModules;
        synchronized (map) {
            Map<String, FaultyServiceData> faultyServicesDueToModule = this.faultyServicesDueToModules.get(moduleName);
            FaultyServiceData faultyServiceData = faultyServicesDueToModule.get(serviceGroupName);
            if (faultyServicesDueToModule != null) {
                faultyServicesDueToModule.remove(serviceGroupName);
                String serviceLocation = null;
                if (faultyServiceData.getCurrentDeploymentFile() != null) {
                    serviceLocation = faultyServiceData.getCurrentDeploymentFile().getFile().getAbsolutePath();
                }
                if (serviceLocation == null) {
                    serviceLocation = faultyServiceData.getServiceGroupName();
                }
                this.faultyServices.remove(serviceLocation);
                if (faultyServicesDueToModule.isEmpty()) {
                    this.faultyServicesDueToModules.remove(moduleName);
                }
            }
        }
    }

    public void removeFaultyService(String key) {
        for (String fullFileName : this.faultyServices.keySet()) {
            if (fullFileName.indexOf(key) < 0) continue;
            this.faultyServices.remove(fullFileName);
            return;
        }
    }

    public List<Phase> getOutFlowPhases() {
        return this.outPhases;
    }

    public List<Phase> getInFaultFlowPhases() {
        return this.inFaultPhases;
    }

    public List<Phase> getInFlowPhases() {
        return this.inPhasesUptoAndIncludingPostDispatch;
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return this.messageReceivers.get(mepURL);
    }

    public Builder getMessageBuilder(String contentType) {
        Builder builder = null;
        if (this.messageBuilders.isEmpty()) {
            return null;
        }
        if (contentType != null) {
            builder = this.messageBuilders.get(contentType);
            if (builder == null) {
                builder = this.messageBuilders.get(contentType.toLowerCase());
            }
            if (builder == null) {
                Iterator<Map.Entry<String, Builder>> iterator = this.messageBuilders.entrySet().iterator();
                while (iterator.hasNext() && builder == null) {
                    Map.Entry<String, Builder> entry = iterator.next();
                    String key = entry.getKey();
                    if (!contentType.matches(key)) continue;
                    builder = entry.getValue();
                }
            }
        }
        return builder;
    }

    public Builder getMessageBuilder(String contentType, boolean defaultBuilder) {
        Builder builder = this.getMessageBuilder(contentType);
        if (builder == null && defaultBuilder) {
            builder = new UnknownContentBuilder();
        }
        return builder;
    }

    public MessageFormatter getMessageFormatter(String contentType) {
        MessageFormatter formatter = null;
        if (this.messageFormatters.isEmpty()) {
            return null;
        }
        if (contentType != null) {
            formatter = this.messageFormatters.get(contentType);
            if (formatter == null) {
                formatter = this.messageFormatters.get(contentType.toLowerCase());
            }
            if (formatter == null) {
                Iterator<Map.Entry<String, MessageFormatter>> iterator = this.messageFormatters.entrySet().iterator();
                while (iterator.hasNext() && formatter == null) {
                    Map.Entry<String, MessageFormatter> entry = iterator.next();
                    String key = entry.getKey();
                    if (!contentType.matches(key)) continue;
                    formatter = entry.getValue();
                }
            }
        }
        return formatter;
    }

    public AxisModule getModule(String name) {
        AxisModule module = this.allModules.get(name);
        if (module != null) {
            return module;
        }
        String defaultModuleVersion = this.getDefaultModuleVersion(name);
        if (defaultModuleVersion != null && (module = this.allModules.get(Utils.getModuleName(name, defaultModuleVersion))) != null) {
            return module;
        }
        return null;
    }

    public AxisModule getModule(String moduleName, String moduleVersion) {
        if (moduleVersion == null || moduleVersion.trim().length() == 0) {
            moduleVersion = this.getDefaultModuleVersion(moduleName);
        }
        return this.allModules.get(Utils.getModuleName(moduleName, moduleVersion));
    }

    public ClassLoader getModuleClassLoader() {
        return this.moduleClassLoader;
    }

    public ModuleConfiguration getModuleConfig(String moduleName) {
        return this.moduleConfigmap.get(moduleName);
    }

    public HashMap<String, AxisModule> getModules() {
        return this.allModules;
    }

    public List<String> getGlobalModules() {
        return this.globalModuleList;
    }

    public List<Phase> getOutFaultFlowPhases() {
        return this.outFaultPhases;
    }

    public PhasesInfo getPhasesInfo() {
        return this.phasesinfo;
    }

    public URL getRepository() {
        return this.axis2Repository;
    }

    public AxisService getService(String name) throws AxisFault {
        AxisService axisService = this.allServices.get(name);
        if (axisService != null) {
            if (axisService.isActive()) {
                return axisService;
            }
            throw new AxisFault(Messages.getMessage("serviceinactive", name));
        }
        axisService = this.allEndpoints.get(name);
        if (axisService != null) {
            if (axisService.isActive()) {
                return axisService;
            }
            throw new AxisFault(Messages.getMessage("serviceinactive", name));
        }
        return null;
    }

    public AxisService getServiceForActivation(String serviceName) {
        AxisService axisService = this.allServices.get(serviceName);
        if (axisService != null) {
            return axisService;
        }
        axisService = this.allEndpoints.get(serviceName);
        return axisService;
    }

    public ClassLoader getServiceClassLoader() {
        return this.serviceClassLoader;
    }

    public AxisServiceGroup getServiceGroup(String serviceNameAndGroupString) {
        return (AxisServiceGroup)this.getChild(serviceNameAndGroupString);
    }

    public Iterator<AxisServiceGroup> getServiceGroups() {
        return this.getChildren();
    }

    public HashMap<String, AxisService> getServices() {
        HashMap<String, AxisService> hashMap = new HashMap<String, AxisService>(this.allServices.size());
        Iterator<String> i$ = this.allServices.keySet().iterator();
        while (i$.hasNext()) {
            String s;
            String key = s = i$.next();
            hashMap.put(key, this.allServices.get(key));
        }
        return hashMap;
    }

    public ClassLoader getSystemClassLoader() {
        return this.systemClassLoader;
    }

    public TransportInDescription getTransportIn(String name) {
        return this.transportsIn.get(name);
    }

    public TransportOutDescription getTransportOut(String name) {
        return this.transportsOut.get(name);
    }

    public HashMap<String, TransportInDescription> getTransportsIn() {
        return this.transportsIn;
    }

    public HashMap<String, TransportOutDescription> getTransportsOut() {
        return this.transportsOut;
    }

    public boolean isEngaged(QName qname) {
        return this.isEngaged(qname.getLocalPart());
    }

    @Override
    public boolean isEngaged(String moduleId) {
        AxisModule module = this.getModule(moduleId);
        if (module == null) {
            return false;
        }
        boolean isEngaged = super.isEngaged(module);
        if (!isEngaged) {
            AxisModule defaultModule = this.getDefaultModule(moduleId);
            isEngaged = this.engagedModules != null && this.engagedModules.values().contains(defaultModule);
        }
        return isEngaged;
    }

    @Override
    public boolean isEngaged(AxisModule axisModule) {
        boolean isEngaged = super.isEngaged(axisModule);
        if (!isEngaged) {
            isEngaged = this.engagedModules != null && this.engagedModules.values().contains(axisModule);
        }
        return isEngaged;
    }

    public void setGlobalOutPhase(List<Phase> outPhases) {
        this.outPhases = outPhases;
    }

    public void setInFaultPhases(List<Phase> list) {
        this.inFaultPhases = list;
    }

    public void setInPhasesUptoAndIncludingPostDispatch(List<Phase> inPhasesUptoAndIncludingPostDispatch) {
        this.inPhasesUptoAndIncludingPostDispatch = inPhasesUptoAndIncludingPostDispatch;
    }

    public void setModuleClassLoader(ClassLoader classLoader) {
        this.moduleClassLoader = classLoader;
    }

    public void setOutFaultPhases(List<Phase> list) {
        this.outFaultPhases = list;
    }

    public void setPhasesInfo(PhasesInfo phasesInfo) {
        this.phasesinfo = phasesInfo;
    }

    public void setRepository(URL axis2Repository) {
        this.axis2Repository = axis2Repository;
    }

    public void setServiceClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setSystemClassLoader(ClassLoader classLoader) {
        this.systemClassLoader = classLoader;
    }

    public void addDefaultModuleVersion(String moduleName, String moduleVersion) {
        if (this.nameToversionMap.get(moduleName) == null) {
            this.nameToversionMap.put(moduleName, moduleVersion);
        }
    }

    public String getDefaultModuleVersion(String moduleName) {
        return this.nameToversionMap.get(moduleName);
    }

    public AxisModule getDefaultModule(String moduleName) {
        String defaultModuleVersion = this.getDefaultModuleVersion(moduleName);
        if (defaultModuleVersion == null) {
            return this.allModules.get(moduleName);
        }
        return this.allModules.get(moduleName + "-" + defaultModuleVersion);
    }

    public ClusteringAgent getClusteringAgent() {
        return this.clusteringAgent;
    }

    public void setClusteringAgent(ClusteringAgent clusteringAgent) {
        this.clusteringAgent = clusteringAgent;
    }

    public TransactionConfiguration getTransactionConfiguration() {
        return this.transactionConfiguration;
    }

    public void setTransactionConfig(TransactionConfiguration transactionConfiguration) {
        this.transactionConfiguration = transactionConfiguration;
    }

    @Override
    public Object getKey() {
        return this.toString();
    }

    public void stopService(String serviceName) throws AxisFault {
        AxisService service = this.allServices.get(serviceName);
        if (service == null) {
            throw new AxisFault(Messages.getMessage("servicenamenotvalid", serviceName));
        }
        service.setActive(false);
        this.notifyObservers(new AxisEvent(2, service), service);
    }

    public void startService(String serviceName) throws AxisFault {
        AxisService service = this.allServices.get(serviceName);
        if (service == null) {
            throw new AxisFault(Messages.getMessage("servicenamenotvalid", serviceName));
        }
        service.setActive(true);
        this.notifyObservers(new AxisEvent(3, service), service);
    }

    public List<AxisModule> getModulesForPolicyNamesapce(String namesapce) {
        return this.policySupportedModules.get(namesapce);
    }

    public void registerModulePolicySupport(AxisModule axisModule) {
        String[] namespaces = axisModule.getSupportedPolicyNamespaces();
        if (namespaces == null) {
            return;
        }
        for (String namespace : namespaces) {
            List<AxisModule> modulesList = this.policySupportedModules.get(namespace);
            if (modulesList != null) {
                modulesList.add(axisModule);
                continue;
            }
            modulesList = new ArrayList<AxisModule>();
            modulesList.add(axisModule);
            this.policySupportedModules.put(namespace, modulesList);
        }
    }

    public void registerLocalPolicyAssertions(AxisModule axisModule) {
        QName[] localPolicyAssertions = axisModule.getLocalPolicyAssertions();
        if (localPolicyAssertions == null) {
            return;
        }
        for (QName localPolicyAssertion : localPolicyAssertions) {
            this.addLocalPolicyAssertion(localPolicyAssertion);
        }
    }

    public ArrayList<AxisObserver> getObserversList() {
        AxisObserver[] array = this.observerSet.toArray(new AxisObserver[this.observerSet.size()]);
        ArrayList<AxisObserver> observers = new ArrayList<AxisObserver>(array.length);
        observers.addAll(Arrays.asList(array));
        return observers;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public TargetResolver getTargetResolverChain() {
        if (this.targetResolvers.isEmpty()) {
            return null;
        }
        return new TargetResolver(){

            @Override
            public void resolveTarget(MessageContext messageContext) {
                for (TargetResolver tr : AxisConfiguration.this.targetResolvers) {
                    tr.resolveTarget(messageContext);
                }
            }
        };
    }

    public void addTargetResolver(TargetResolver tr) {
        this.targetResolvers.add(tr);
    }

    public void addLocalPolicyAssertion(QName name) {
        this.localPolicyAssertions.add(name);
    }

    public List<QName> getLocalPolicyAssertions() {
        return this.localPolicyAssertions;
    }

    public void removeLocalPolicyAssertion(QName name) {
        this.localPolicyAssertions.remove(name);
    }

    public boolean isAssertionLocal(QName name) {
        return this.localPolicyAssertions.contains(name);
    }

    public void addDataLocatorClassNames(String dialect, String classname) {
        this.dataLocatorClassNames.put(dialect, classname);
    }

    public void addDataLocator(String dialect, AxisDataLocator dataLocator) {
        this.dataLocators.put(dialect, dataLocator);
    }

    public AxisDataLocator getDataLocator(String dialect) {
        return this.dataLocators.get(dialect);
    }

    public String getDataLocatorClassName(String dialect) {
        return this.dataLocatorClassNames.get(dialect);
    }

    public void validateSystemPredefinedPhases() throws DeploymentException {
        PhasesInfo phasesInfo = this.getPhasesInfo();
        this.setInPhasesUptoAndIncludingPostDispatch(phasesInfo.getGlobalInflow());
        this.setInFaultPhases(phasesInfo.getGlobalInFaultPhases());
        this.setGlobalOutPhase(phasesInfo.getGlobalOutPhaseList());
        this.setOutFaultPhases(phasesInfo.getOUT_FaultPhases());
    }

    public AxisConfigurator getConfigurator() {
        return this.configurator;
    }

    public void setConfigurator(AxisConfigurator configurator) {
        this.configurator = configurator;
    }

    public void cleanup() {
        if (this.configurator != null) {
            this.configurator.cleanup();
        }
        if (this.clusteringAgent != null) {
            this.clusteringAgent.stop();
        }
        this.policySupportedModules.clear();
        this.moduleConfigmap.clear();
        this.allEndpoints.clear();
        this.allModules.clear();
        this.allServices.clear();
        this.outPhases.clear();
        this.messageReceivers.clear();
        this.targetResolvers.clear();
        if (this.engagedModules != null) {
            this.engagedModules.clear();
        }
        this.configurator = null;
    }

    public void insertPhase(Deployable d, int flow) throws AxisFault {
        switch (flow) {
            case 1: {
                List<Phase> phaseList = this.phasesinfo.getINPhases();
                phaseList = this.findAndInsertPhase(d, phaseList);
                if (phaseList == null) break;
                this.phasesinfo.setINPhases(phaseList);
                break;
            }
            case 2: {
                List<Phase> phaseList = this.phasesinfo.getOUTPhases();
                phaseList = this.findAndInsertPhase(d, phaseList);
                if (phaseList == null) break;
                this.phasesinfo.setOUTPhases(phaseList);
                break;
            }
            case 4: {
                List<Phase> phaseList = this.phasesinfo.getOutFaultPhaseList();
                phaseList = this.findAndInsertPhase(d, phaseList);
                if (phaseList == null) break;
                this.phasesinfo.setOUT_FaultPhases(phaseList);
                break;
            }
            case 3: {
                List<Phase> phaseList = this.phasesinfo.getIN_FaultPhases();
                phaseList = this.findAndInsertPhase(d, phaseList);
                if (phaseList == null) break;
                this.phasesinfo.setIN_FaultPhases(phaseList);
                break;
            }
        }
    }

    private List<Phase> findAndInsertPhase(Deployable d, List<Phase> phaseList) throws AxisFault {
        DeployableChain ec = new DeployableChain();
        String last = null;
        for (Phase phase : phaseList) {
            String name = phase.getName();
            Deployable existing = new Deployable(name);
            existing.setTarget(phase);
            if (last != null) {
                ec.addRelationship(last, name);
            }
            last = name;
            try {
                ec.deploy(existing);
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
        try {
            ec.deploy(d);
            if (d.getTarget() == null) {
                Phase phase = new Phase();
                phase.setName(d.getName());
                d.setTarget(phase);
            }
            ec.rebuild();
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        phaseList = ec.getChain();
        return phaseList;
    }

    private void processEndpoints(AxisService axisService, AxisConfiguration axisConfiguration) throws AxisFault {
        Map<String, AxisEndpoint> enspoints = axisService.getEndpoints();
        if (enspoints == null || enspoints.size() == 0) {
            org.apache.axis2.deployment.util.Utils.addEndpointsToService(axisService, axisConfiguration);
        }
    }

    public boolean isChildFirstClassLoading() {
        boolean childFirstClassLoading = false;
        Parameter isChildFirstClassLoading = this.getParameter("EnableChildFirstClassLoading");
        if (isChildFirstClassLoading != null) {
            childFirstClassLoading = JavaUtils.isTrueExplicitly(isChildFirstClassLoading.getValue());
        }
        return childFirstClassLoading;
    }

    public SecretResolver getSecretResolver() {
        return this.secretResolver;
    }

    public void setSecretResolver(SecretResolver secretResolver) {
        this.secretResolver = secretResolver;
    }
}

