/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.axis2.classloader.AbstractResourceHandle;
import org.apache.axis2.classloader.JarFileUrlStreamHandler;

public class JarResourceHandle
extends AbstractResourceHandle {
    private final JarFile jarFile;
    private final JarEntry jarEntry;
    private final URL url;
    private final URL codeSource;

    public JarResourceHandle(JarFile jarFile, JarEntry jarEntry, URL codeSource) throws MalformedURLException {
        this.jarFile = jarFile;
        this.jarEntry = jarEntry;
        this.url = JarFileUrlStreamHandler.createUrl(jarFile, jarEntry, codeSource);
        this.codeSource = codeSource;
    }

    @Override
    public String getName() {
        return this.jarEntry.getName();
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public URL getCodeSourceUrl() {
        return this.codeSource;
    }

    @Override
    public boolean isDirectory() {
        return this.jarEntry.isDirectory();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.jarFile.getInputStream(this.jarEntry);
    }

    @Override
    public int getContentLength() {
        return (int)this.jarEntry.getSize();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    @Override
    public Attributes getAttributes() throws IOException {
        return this.jarEntry.getAttributes();
    }

    @Override
    public Certificate[] getCertificates() {
        return this.jarEntry.getCertificates();
    }
}

