/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.TestCase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.util.TestHarness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractSolrTestCase
extends TestCase {
    protected SolrConfig solrConfig;
    protected TestHarness h;
    protected TestHarness.LocalRequestFactory lrf;
    protected File dataDir;
    public static Logger log = LoggerFactory.getLogger(AbstractSolrTestCase.class);

    public abstract String getSchemaFile();

    public abstract String getSolrConfigFile();

    public void setUp() throws Exception {
        log.info("####SETUP_START " + this.getName());
        this.dataDir = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + ((Object)((Object)this)).getClass().getName() + "-" + System.currentTimeMillis());
        this.dataDir.mkdirs();
        String configFile = this.getSolrConfigFile();
        if (configFile != null) {
            this.solrConfig = TestHarness.createConfig(this.getSolrConfigFile());
            this.h = new TestHarness(this.dataDir.getAbsolutePath(), this.solrConfig, this.getSchemaFile());
            this.lrf = this.h.getRequestFactory("standard", 0, 20, "version", "2.2");
        }
        log.info("####SETUP_END " + this.getName());
    }

    public void postSetUp() {
        log.info("####POSTSETUP " + this.getName());
    }

    public void preTearDown() {
        log.info("####PRETEARDOWN " + this.getName());
    }

    public void tearDown() throws Exception {
        String skip;
        log.info("####TEARDOWN_START " + this.getName());
        if (this.h != null) {
            this.h.close();
        }
        if (null != (skip = System.getProperty("solr.test.leavedatadir")) && 0 != skip.trim().length()) {
            System.err.println("NOTE: per solr.test.leavedatadir, dataDir will not be removed: " + this.dataDir.getAbsolutePath());
        } else if (!AbstractSolrTestCase.recurseDelete(this.dataDir)) {
            System.err.println("!!!! WARNING: best effort to remove " + this.dataDir.getAbsolutePath() + " FAILED !!!!!");
        }
    }

    public void assertU(String update) {
        this.assertU(null, update);
    }

    public void assertU(String message, String update) {
        this.checkUpdateU(message, update, true);
    }

    public void assertFailedU(String update) {
        this.assertFailedU(null, update);
    }

    public void assertFailedU(String message, String update) {
        this.checkUpdateU(message, update, false);
    }

    private void checkUpdateU(String message, String update, boolean shouldSucceed) {
        try {
            String m;
            String string = m = null == message ? "" : message + " ";
            if (shouldSucceed) {
                String res = this.h.validateUpdate(update);
                if (res != null) {
                    AbstractSolrTestCase.fail((String)(m + "update was not successful: " + res));
                }
            } else {
                String res = this.h.validateErrorUpdate(update);
                if (res != null) {
                    AbstractSolrTestCase.fail((String)(m + "update succeeded, but should have failed: " + res));
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid XML", e);
        }
    }

    public void assertQ(SolrQueryRequest req, String ... tests) {
        this.assertQ(null, req, tests);
    }

    public void assertQ(String message, SolrQueryRequest req, String ... tests) {
        try {
            String m = null == message ? "" : message + " ";
            String response = this.h.query(req);
            String results = this.h.validateXPath(response, tests);
            if (null != results) {
                AbstractSolrTestCase.fail((String)(m + "query failed XPath: " + results + "\n xml response was: " + response + "\n request was: " + req.getParamString()));
            }
        }
        catch (XPathExpressionException e1) {
            throw new RuntimeException("XPath is invalid", e1);
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public void assertQEx(String message, SolrQueryRequest req, int code) {
        try {
            this.h.query(req);
            AbstractSolrTestCase.fail((String)message);
        }
        catch (SolrException sex) {
            AbstractSolrTestCase.assertEquals((int)code, (int)sex.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public String optimize(String ... args) {
        return TestHarness.optimize(args);
    }

    public String commit(String ... args) {
        return TestHarness.commit(args);
    }

    public String adoc(String ... fieldsAndValues) {
        Doc d = this.doc(fieldsAndValues);
        return this.add(d, new String[0]);
    }

    public String adoc(SolrInputDocument sdoc) {
        ArrayList<String> fields = new ArrayList<String>();
        for (SolrInputField sf : sdoc) {
            for (Object o : sf.getValues()) {
                fields.add(sf.getName());
                fields.add(o.toString());
            }
        }
        return this.adoc(fields.toArray(new String[fields.size()]));
    }

    public String add(Doc doc, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                r.write("<add>");
                r.write(doc.xml);
                r.write("</add>");
            } else {
                XML.writeUnescapedXML(r, "add", doc.xml, args);
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public String delI(String id) {
        return TestHarness.deleteById(id);
    }

    public String delQ(String q) {
        return TestHarness.deleteByQuery(q);
    }

    public Doc doc(String ... fieldsAndValues) {
        Doc d = new Doc();
        d.xml = TestHarness.makeSimpleDoc(fieldsAndValues).toString();
        return d;
    }

    public SolrQueryRequest req(String ... q) {
        return this.lrf.makeRequest(q);
    }

    public SolrQueryRequest req(String[] params, String ... moreParams) {
        String[] allParams = moreParams;
        if (params.length != 0) {
            int len = params.length + moreParams.length;
            allParams = new String[len];
            System.arraycopy(params, 0, allParams, 0, params.length);
            System.arraycopy(moreParams, 0, allParams, params.length, moreParams.length);
        }
        return this.lrf.makeRequest(allParams);
    }

    public static boolean recurseDelete(File f) {
        if (f.isDirectory()) {
            for (File sub : f.listFiles()) {
                if (AbstractSolrTestCase.recurseDelete(sub)) continue;
                return false;
            }
        }
        return f.delete();
    }

    public static class Doc {
        public String xml;

        public String toString() {
            return this.xml;
        }
    }
}

