/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.StringHelper;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ElevationComparatorSource;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.VersionedFile;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryElevationComponent
extends SearchComponent
implements SolrCoreAware {
    private static Logger log = LoggerFactory.getLogger(QueryElevationComponent.class);
    static final String FIELD_TYPE = "queryFieldType";
    static final String CONFIG_FILE = "config-file";
    static final String FORCE_ELEVATION = "forceElevation";
    static final String EXCLUDE = "exclude";
    static final String ENABLE = "enableElevation";
    private SolrParams initArgs = null;
    private Analyzer analyzer = null;
    private String idField = null;
    boolean forceElevation = false;
    final Map<IndexReader, Map<String, ElevationObj>> elevationCache = new WeakHashMap<IndexReader, Map<String, ElevationObj>>();

    @Override
    public void init(NamedList args) {
        this.initArgs = SolrParams.toSolrParams(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(SolrCore core) {
        SchemaField sf;
        String a = this.initArgs.get(FIELD_TYPE);
        if (a != null) {
            FieldType ft = core.getSchema().getFieldTypes().get(a);
            if (ft == null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown FieldType: '" + a + "' used in QueryElevationComponent");
            }
            this.analyzer = ft.getQueryAnalyzer();
        }
        if ((sf = core.getSchema().getUniqueKeyField()) == null || !(sf.getType() instanceof StrField)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent requires the schema to have a uniqueKeyField implemented using StrField");
        }
        this.idField = StringHelper.intern(sf.getName());
        this.forceElevation = this.initArgs.getBool(FORCE_ELEVATION, this.forceElevation);
        try {
            Map<IndexReader, Map<String, ElevationObj>> map = this.elevationCache;
            synchronized (map) {
                this.elevationCache.clear();
                String f = this.initArgs.get(CONFIG_FILE);
                if (f == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent must specify argument: 'config-file' -- path to elevate.xml");
                }
                File fC = new File(core.getResourceLoader().getConfigDir(), f);
                File fD = new File(core.getDataDir(), f);
                if (fC.exists() == fD.exists()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent missing config file: '" + f + "\n" + "either: " + fC.getAbsolutePath() + " or " + fD.getAbsolutePath() + " must exist, but not both.");
                }
                if (fC.exists()) {
                    log.info("Loading QueryElevation from: " + fC.getAbsolutePath());
                    Config cfg = new Config(core.getResourceLoader(), f);
                    this.elevationCache.put(null, this.loadElevationMap(cfg));
                } else {
                    RefCounted<SolrIndexSearcher> searchHolder = null;
                    try {
                        searchHolder = core.getNewestSearcher(false);
                        SolrIndexReader reader = searchHolder.get().getReader();
                        this.getElevationMap(reader, core);
                        Object var11_12 = null;
                        if (searchHolder != null) {
                            searchHolder.decref();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_13 = null;
                        if (searchHolder != null) {
                            searchHolder.decref();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing QueryElevationComponent.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ElevationObj> getElevationMap(IndexReader reader, SolrCore core) throws Exception {
        Map<IndexReader, Map<String, ElevationObj>> map = this.elevationCache;
        synchronized (map) {
            Map<String, ElevationObj> map2 = this.elevationCache.get(null);
            if (map2 != null) {
                return map2;
            }
            map2 = this.elevationCache.get(reader);
            if (map2 == null) {
                String f = this.initArgs.get(CONFIG_FILE);
                if (f == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "QueryElevationComponent must specify argument: config-file");
                }
                log.info("Loading QueryElevation from data dir: " + f);
                InputStream is = VersionedFile.getLatestFile(core.getDataDir(), f);
                Config cfg = new Config(core.getResourceLoader(), f, is, null);
                map2 = this.loadElevationMap(cfg);
                this.elevationCache.put(reader, map2);
            }
            return map2;
        }
    }

    private Map<String, ElevationObj> loadElevationMap(Config cfg) throws IOException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        HashMap<String, ElevationObj> map = new HashMap<String, ElevationObj>();
        NodeList nodes = (NodeList)cfg.evaluate("elevate/query", XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String qstr = DOMUtil.getAttr(node, "text", "missing query 'text'");
            NodeList children = null;
            try {
                children = (NodeList)xpath.evaluate("doc", node, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "query requires '<doc .../>' child");
            }
            ArrayList<String> include = new ArrayList<String>();
            ArrayList<String> exclude = new ArrayList<String>();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                String id = DOMUtil.getAttr(child, "id", "missing 'id'");
                String e = DOMUtil.getAttr(child, EXCLUDE, null);
                if (e != null && Boolean.valueOf(e).booleanValue()) {
                    exclude.add(id);
                    continue;
                }
                include.add(id);
            }
            ElevationObj elev = new ElevationObj(qstr, include, exclude);
            if (map.containsKey(elev.analyzed)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Boosting query defined twice for query: '" + elev.text + "' (" + elev.analyzed + "')");
            }
            map.put(elev.analyzed, elev);
        }
        return map;
    }

    void setTopQueryResults(IndexReader reader, String query, String[] ids, String[] ex) throws IOException {
        Map<String, ElevationObj> elev;
        if (ids == null) {
            ids = new String[]{};
        }
        if (ex == null) {
            ex = new String[]{};
        }
        if ((elev = this.elevationCache.get(reader)) == null) {
            elev = new HashMap<String, ElevationObj>();
            this.elevationCache.put(reader, elev);
        }
        ElevationObj obj = new ElevationObj(query, Arrays.asList(ids), Arrays.asList(ex));
        elev.put(obj.analyzed, obj);
    }

    String getAnalyzedQuery(String query) throws IOException {
        if (this.analyzer == null) {
            return query;
        }
        StringBuilder norm = new StringBuilder();
        TokenStream tokens = this.analyzer.reusableTokenStream("", new StringReader(query));
        tokens.reset();
        Token token = tokens.next();
        while (token != null) {
            norm.append(new String(token.termBuffer(), 0, token.termLength()));
            token = tokens.next();
        }
        return norm.toString();
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        if (!params.getBool(ENABLE, true)) {
            return;
        }
        boolean force = params.getBool(FORCE_ELEVATION, this.forceElevation);
        Query query = rb.getQuery();
        String qstr = rb.getQueryString();
        if (query == null || qstr == null) {
            return;
        }
        qstr = this.getAnalyzedQuery(qstr);
        SolrIndexReader reader = req.getSearcher().getReader();
        ElevationObj booster = null;
        try {
            booster = this.getElevationMap(reader, req.getCore()).get(qstr);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading elevation", (Throwable)ex);
        }
        if (booster != null) {
            BooleanQuery newq = new BooleanQuery(true);
            newq.add(query, BooleanClause.Occur.SHOULD);
            newq.add(booster.include, BooleanClause.Occur.SHOULD);
            if (booster.exclude != null) {
                for (BooleanClause bq : booster.exclude) {
                    newq.add(bq);
                }
            }
            rb.setQuery(newq);
            SortSpec sortSpec = rb.getSortSpec();
            if (sortSpec.getSort() == null) {
                sortSpec.setSort(new Sort(new SortField[]{new SortField(this.idField, booster.comparatorSource, false), new SortField(null, 0, false)}));
            } else {
                boolean modify = false;
                SortField[] current = sortSpec.getSort().getSort();
                ArrayList<SortField> sorts = new ArrayList<SortField>(current.length + 1);
                if (force && current[0].getType() != 0) {
                    sorts.add(new SortField(this.idField, booster.comparatorSource, false));
                    modify = true;
                }
                for (SortField sf : current) {
                    if (sf.getType() == 0) {
                        sorts.add(new SortField(this.idField, booster.comparatorSource, sf.getReverse()));
                        modify = true;
                    }
                    sorts.add(sf);
                }
                if (modify) {
                    sortSpec.setSort(new Sort(sorts.toArray(new SortField[sorts.size()])));
                }
            }
        }
        if (rb.isDebug()) {
            ArrayList<String> match = null;
            if (booster != null) {
                match = new ArrayList<String>(booster.priority.size());
                for (Object o : booster.include.clauses()) {
                    TermQuery tq = (TermQuery)((BooleanClause)o).getQuery();
                    match.add(tq.getTerm().text());
                }
            }
            SimpleOrderedMap<Object> dbg = new SimpleOrderedMap<Object>();
            dbg.add("q", qstr);
            dbg.add("match", match);
            rb.addDebugInfo("queryBoosting", dbg);
        }
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
    }

    @Override
    public String getDescription() {
        return "Query Boosting -- boost particular documents for a given query";
    }

    @Override
    public String getVersion() {
        return "$Revision: 949888 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: QueryElevationComponent.java 949888 2010-05-31 23:24:40Z hossman $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/component/QueryElevationComponent.java $";
    }

    @Override
    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://wiki.apache.org/solr/QueryElevationComponent")};
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ElevationObj {
        final String text;
        final String analyzed;
        final BooleanClause[] exclude;
        final BooleanQuery include;
        final Map<String, Integer> priority;
        final FieldComparatorSource comparatorSource;

        ElevationObj(String qstr, List<String> elevate, List<String> exclude) throws IOException {
            this.text = qstr;
            this.analyzed = QueryElevationComponent.this.getAnalyzedQuery(this.text);
            this.include = new BooleanQuery();
            this.include.setBoost(0.0f);
            this.priority = new HashMap<String, Integer>();
            int max = elevate.size() + 5;
            for (String id : elevate) {
                TermQuery tq = new TermQuery(new Term(QueryElevationComponent.this.idField, id));
                this.include.add(tq, BooleanClause.Occur.SHOULD);
                this.priority.put(id, max--);
            }
            if (exclude == null || exclude.isEmpty()) {
                this.exclude = null;
            } else {
                this.exclude = new BooleanClause[exclude.size()];
                for (int i = 0; i < exclude.size(); ++i) {
                    TermQuery tq = new TermQuery(new Term(QueryElevationComponent.this.idField, exclude.get(i)));
                    this.exclude[i] = new BooleanClause(tq, BooleanClause.Occur.MUST_NOT);
                }
            }
            this.comparatorSource = new ElevationComparatorSource(this.priority);
        }
    }
}

