/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.Indexer;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class AsyncIndexer
implements Runnable {
    private static Log log = LogFactory.getLog(AsyncIndexer.class);
    private final SolrClient client;
    private LinkedBlockingQueue<File2Index> queue = new LinkedBlockingQueue();
    private boolean canAcceptFiles = true;
    int poolSize = 50;

    public void addFile(File2Index file2Index) {
        if (this.canAcceptFiles) {
            this.queue.offer(file2Index);
        } else {
            log.warn((Object)("Can't accept resource for indexing. Shutdown in progress: path=" + file2Index.path));
        }
    }

    protected AsyncIndexer() throws RegistryException {
        try {
            this.client = SolrClient.getInstance();
            Utils.setWaitBeforeShutdownObserver(new WaitBeforeShutdownObserver(){

                public void startingShutdown() {
                    AsyncIndexer.this.canAcceptFiles = false;
                    do {
                        AsyncIndexer.this.indexFile();
                    } while (AsyncIndexer.this.queue.size() != 0);
                }

                public boolean isTaskComplete() {
                    return AsyncIndexer.this.queue.size() <= 0;
                }
            });
        }
        catch (IndexerException e) {
            throw new RegistryException("Error initializing Async Indexer " + e.getMessage(), (Throwable)e);
        }
    }

    public SolrClient getClient() {
        return this.client;
    }

    @Override
    public void run() {
        this.indexFile();
    }

    private boolean indexFile() {
        try {
            if (!this.canAcceptFiles) {
                return false;
            }
            long batchSize = IndexingManager.getInstance().getBatchSize();
            ArrayList<IndexingTask> taskList = new ArrayList<IndexingTask>();
            for (long i = 0L; this.queue.size() > 0 && i <= batchSize; ++i) {
                IndexingTask indexingTask = new IndexingTask(this.queue.take());
                taskList.add(indexingTask);
            }
            if (taskList.size() <= 0) {
                return true;
            }
            this.uploadFiles(taskList);
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                return false;
            }
            log.error((Object)"Error while indexing.", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void uploadFiles(List<IndexingTask> tasks) throws RegistryException {
        this.poolSize = IndexingManager.getInstance().getIndexerPoolSize();
        if (this.poolSize <= 0) {
            for (IndexingTask task : tasks) {
                task.run();
            }
            return;
        } else {
            ExecutorService executorService = Executors.newFixedThreadPool(this.poolSize);
            try {
                for (IndexingTask task : tasks) {
                    executorService.submit(task);
                }
                return;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) return;
                log.debug((Object)"Failed to submit indexing task ", (Throwable)e);
                return;
            }
            finally {
                executorService.shutdown();
            }
        }
    }

    protected static class IndexingTask
    implements Runnable {
        private File2Index fileData;

        protected IndexingTask(File2Index fileData) {
            this.fileData = fileData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.fileData.tenantId);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(this.fileData.tenantDomain);
                this.doWork(this.fileData);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }

        private boolean doWork(File2Index file2Index) {
            try {
                Indexer indexer = IndexingManager.getInstance().getIndexerForMediaType(file2Index.mediaType);
                try {
                    AsyncIndexer asyncIndexer = new AsyncIndexer();
                    asyncIndexer.getClient().indexDocument(file2Index, indexer);
                }
                catch (Exception e) {
                    log.warn((Object)("Could not index the resource: path=" + file2Index.path + ", media type=" + file2Index.mediaType));
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error while indexing.", e);
            }
            return true;
        }
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    public static class File2Index {
        public byte[] data;
        public String mediaType;
        public String path;
        public String lcName;
        public String lcState;
        public int tenantId;
        public String tenantDomain;

        public File2Index(byte[] data, String mediaType, String path, int tenantId, String tenantDomain) {
            this.data = data;
            this.mediaType = mediaType;
            this.path = path;
            this.tenantId = tenantId;
            this.tenantDomain = tenantDomain;
        }

        public File2Index(byte[] data, String mediaType, String path, int tenantId, String tenantDomain, String lcName, String lcState) {
            this.data = data;
            this.mediaType = mediaType;
            this.path = path;
            this.tenantId = tenantId;
            this.tenantDomain = tenantDomain;
            this.lcName = lcName;
            this.lcState = lcState;
        }
    }
}

