/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.base.AbstractTransportListener;
import org.apache.axis2.transport.base.ProtocolEndpoint;

public abstract class AbstractTransportListenerEx<E extends ProtocolEndpoint>
extends AbstractTransportListener {
    private List<E> serviceEndpoints = new ArrayList();
    private E globalEndpoint;

    @Override
    public final void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        super.init(cfgCtx, transportIn);
        this.doInit();
        E endpoint = this.createEndpoint();
        ((ProtocolEndpoint)endpoint).init(this, null);
        if (((ProtocolEndpoint)endpoint).loadConfiguration(transportIn)) {
            this.globalEndpoint = endpoint;
        }
    }

    protected abstract void doInit() throws AxisFault;

    @Override
    public void start() throws AxisFault {
        super.start();
        if (this.globalEndpoint != null) {
            this.startEndpoint(this.globalEndpoint);
        }
    }

    @Override
    public void stop() throws AxisFault {
        super.stop();
        if (this.globalEndpoint != null) {
            this.stopEndpoint(this.globalEndpoint);
        }
    }

    @Override
    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (serviceName.indexOf(46) != -1) {
            serviceName = serviceName.substring(0, serviceName.indexOf(46));
        }
        for (ProtocolEndpoint endpoint : this.serviceEndpoints) {
            AxisService service = endpoint.getService();
            if (!service.getName().equals(serviceName)) continue;
            return endpoint.getEndpointReferences(service, ip);
        }
        if (this.globalEndpoint != null) {
            AxisService service = this.cfgCtx.getAxisConfiguration().getService(serviceName);
            if (service == null) {
                return null;
            }
            return ((ProtocolEndpoint)this.globalEndpoint).getEndpointReferences(service, ip);
        }
        return null;
    }

    public final Collection<E> getEndpoints() {
        if (this.globalEndpoint == null) {
            return Collections.unmodifiableCollection(this.serviceEndpoints);
        }
        ArrayList<E> endpoints = new ArrayList<E>(this.serviceEndpoints.size() + 1);
        endpoints.add(this.globalEndpoint);
        endpoints.addAll(this.serviceEndpoints);
        return endpoints;
    }

    protected abstract E createEndpoint();

    @Override
    protected final void startListeningForService(AxisService service) throws AxisFault {
        E endpoint = this.createEndpoint();
        ((ProtocolEndpoint)endpoint).init(this, service);
        if (!((ProtocolEndpoint)endpoint).loadConfiguration(service)) {
            if (this.globalEndpoint != null) {
                return;
            }
            throw new AxisFault("Service doesn't have configuration information for transport " + this.getTransportName());
        }
        this.startEndpoint(endpoint);
        this.serviceEndpoints.add(endpoint);
    }

    protected abstract void startEndpoint(E var1) throws AxisFault;

    @Override
    protected final void stopListeningForService(AxisService service) {
        for (ProtocolEndpoint endpoint : this.serviceEndpoints) {
            if (service != endpoint.getService()) continue;
            this.stopEndpoint(endpoint);
            this.serviceEndpoints.remove(endpoint);
            return;
        }
        if (this.globalEndpoint == null) {
            this.log.error((Object)("Unable to stop service : " + service.getName() + " - unable to find the corresponding protocol endpoint"));
        }
    }

    protected abstract void stopEndpoint(E var1);
}

