/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.hostobjects.file;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.hostobjects.file.JavaScriptFile;
import org.jaggeryjs.hostobjects.file.JavaScriptFileImpl;
import org.jaggeryjs.hostobjects.file.JavaScriptFileManager;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;

public class JavaScriptFileManagerImpl
implements JavaScriptFileManager {
    private static final Log log = LogFactory.getLog(JavaScriptFileManagerImpl.class);

    @Override
    public JavaScriptFile getJavaScriptFile(Object object) throws ScriptException {
        if (object instanceof String) {
            String uri = (String)object;
            return new JavaScriptFileImpl(uri, this.getFile(uri).getAbsolutePath());
        }
        String msg = "Unsupported parameter to the File constructor : " + object.getClass();
        log.error((Object)msg);
        throw new ScriptException(msg);
    }

    @Override
    public File getFile(String uri) throws ScriptException {
        File file;
        if (uri.startsWith("file://")) {
            try {
                file = FileUtils.toFile((URL)new URL(uri));
            }
            catch (MalformedURLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new ScriptException((Exception)e);
            }
        } else {
            String oldPath = uri;
            if ((uri = FilenameUtils.normalizeNoEndSeparator((String)uri)) == null) {
                String msg = "Invalid file URI : " + oldPath;
                log.error((Object)msg);
                throw new ScriptException(msg);
            }
            file = new File(uri);
        }
        return file;
    }
}

