/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.KerberosTokenPrincipal;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSDocInfoStore;
import org.apache.ws.security.WSParameterCallback;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.kerberos.KrbSession;
import org.apache.ws.security.kerberos.KrbSessionCache;
import org.apache.ws.security.kerberos.KrbTicketDecoder;
import org.apache.ws.security.message.CredentialsCallbackHandler;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KerberosTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog(KerberosTokenProcessor.class);
    private String tokenId;
    private Subject subject;
    private KerberosTokenPrincipal lastPrincipalFound;
    GSSContext gssContext = null;

    public KerberosTokenProcessor(Vector returnResults) {
        for (int j = 0; j < returnResults.size(); ++j) {
            WSSecurityEngineResult wser = (WSSecurityEngineResult)returnResults.get(j);
            Integer actInt = (Integer)wser.get("action");
            if (5632 == actInt) {
                this.lastPrincipalFound = (KerberosTokenPrincipal)wser.get("principal");
                break;
            }
            if (4608 == actInt) {
                this.lastPrincipalFound = (KerberosTokenPrincipal)wser.get("principal");
                break;
            }
            if (5120 != actInt) continue;
            this.lastPrincipalFound = (KerberosTokenPrincipal)wser.get("principal");
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler handler, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        WSDocInfoStore.store(wsDocInfo);
        X509Certificate[] returnCert = new X509Certificate[1];
        HashSet returnElements = new HashSet();
        TreeSet protectedElements = new TreeSet();
        byte[][] signatureValue = new byte[1][];
        KerberosTokenPrincipal lastPrincipalFound = null;
        this.tokenId = elem.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        boolean remove = WSDocInfoStore.store(wsDocInfo);
        for (int j = 0; j < returnResults.size(); ++j) {
            WSSecurityEngineResult wser = (WSSecurityEngineResult)returnResults.get(j);
            Integer actInt = (Integer)wser.get("action");
            if (5632 == actInt) {
                lastPrincipalFound = (KerberosTokenPrincipal)wser.getPrincipal();
                break;
            }
            if (4608 == actInt) {
                lastPrincipalFound = (KerberosTokenPrincipal)wser.getPrincipal();
                break;
            }
            if (5120 != actInt) continue;
            lastPrincipalFound = (KerberosTokenPrincipal)wser.getPrincipal();
            break;
        }
        try {
            if (lastPrincipalFound == null) {
                lastPrincipalFound = this.validateToken(elem, crypto, returnCert, returnElements, protectedElements, signatureValue, handler);
            }
            this.lastPrincipalFound = lastPrincipalFound;
        }
        finally {
            if (remove) {
                WSDocInfoStore.delete(wsDocInfo);
            }
        }
        returnResults.add(0, new WSSecurityEngineResult(4608, (Principal)lastPrincipalFound, null, returnElements, protectedElements, null));
    }

    protected KerberosTokenPrincipal validateToken(Element elem, Crypto crypto, X509Certificate[] returnCert, Set returnElements, Set protectedElements, byte[][] signatureValue, CallbackHandler handler) throws WSSecurityException {
        SecretKey secretKey = null;
        KerberosTokenPrincipal principal = null;
        try {
            this.authenticate(handler);
            KerberosSecurity ks = this.createSecurityToken(elem);
            GSSContext context = this.acceptSecurityContext(ks);
            secretKey = this.getSessionKey(ks.getToken());
            if (log.isDebugEnabled()) {
                log.debug((Object)("security context accepted with " + ((Object)context.getSrcName()).toString() + "," + context.getSrcName().getStringNameType().toString()));
            }
            principal = new KerberosTokenPrincipal(((Object)context.getSrcName()).toString());
            principal.setTokenElement(elem);
            if (secretKey == null) {
                log.error((Object)"null secret key");
                throw new WSSecurityException(3, "nullSecretKey", new Object[]{"null secret key"});
            }
            principal.setSessionKey(secretKey.getEncoded());
            principal.setSecretKey(secretKey);
            KrbSession kerberosSession = new KrbSession(ks.getSHA1(), secretKey);
            kerberosSession.setClientPrincipalName(((Object)context.getSrcName()).toString());
            kerberosSession.setServerPrincipalName(((Object)context.getTargName()).toString());
            KrbSessionCache.getInstance().addSession(kerberosSession);
            principal.setClientPrincipalName(kerberosSession.getClientPrincipalName());
            principal.setServicePrincipalName(kerberosSession.getServerPrincipalName());
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WSSecurityException(3, "kerberosAcceptCtxFailed", new Object[]{e.getMessage()});
        }
        catch (LoginException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WSSecurityException(3, "kerberosLoginFailed", new Object[]{e.getMessage()});
        }
        catch (GSSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WSSecurityException(3, "kerberosSTCreateFailed", new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WSSecurityException(3, "kerberosSTCreateFailed", new Object[]{e.getMessage()});
        }
        return principal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Principal verifyXMLSignature(Element elem, Crypto crypto, X509Certificate[] returnCert, Set returnElements, List protectedElements, byte[][] signatureValue, CallbackHandler cb) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"KerberosTokenProcessor.verifyXMLSignature invoked");
        }
        XMLSignature sig = null;
        try {
            sig = new XMLSignature(elem, null);
        }
        catch (XMLSecurityException e) {
            log.error((Object)"Fail to build the XMLSignature");
            throw new WSSecurityException(6, "noXMLSig");
        }
        sig.addResourceResolver(EnvelopeIdResolver.getInstance());
        KeyInfo info = sig.getKeyInfo();
        SecretKey secretKey = null;
        KerberosTokenPrincipal principal = null;
        if (info == null) throw new WSSecurityException(3, "unsupportedKeyInfo");
        Node node = WSSecurityUtil.getDirectChild(info.getElement(), "SecurityTokenReference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (node == null) {
            throw new WSSecurityException(3, "unsupportedKeyInfo");
        }
        SecurityTokenReference secRef = new SecurityTokenReference((Element)node);
        WSDocInfo wsDocInfo = WSDocInfoStore.lookup(elem.getOwnerDocument());
        if (!secRef.containsReference()) throw new WSSecurityException(3, "unsupportedKeyInfo", new Object[]{node.toString()});
        Element token = secRef.getTokenElement(elem.getOwnerDocument(), wsDocInfo, cb);
        QName el = new QName(token.getNamespaceURI(), token.getLocalName());
        if (!el.equals(WSSecurityEngine.binaryToken)) throw new WSSecurityException(4, "unsupportedKeyInfo", new Object[]{el.getNamespaceURI()});
        try {
            if (this.lastPrincipalFound == null) {
                this.authenticate(cb);
                KerberosSecurity ks = this.createSecurityToken(token);
                GSSContext context = this.acceptSecurityContext(ks);
                secretKey = this.getSessionKey(ks.getToken());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("security context accepted with " + ((Object)context.getSrcName()).toString() + "," + context.getSrcName().getStringNameType()));
                }
                principal = new KerberosTokenPrincipal(((Object)context.getSrcName()).toString());
                principal.setTokenElement(token);
                principal.setSessionKey(secretKey.getEncoded());
                principal.setSecretKey(secretKey);
                KrbSession kerberosSession = new KrbSession(ks.getSHA1(), secretKey);
                kerberosSession.setClientPrincipalName(((Object)context.getSrcName()).toString());
                kerberosSession.setServerPrincipalName(((Object)context.getTargName()).toString());
                KrbSessionCache.getInstance().addSession(kerberosSession);
                principal.setClientPrincipalName(kerberosSession.getClientPrincipalName());
                principal.setServicePrincipalName(kerberosSession.getServerPrincipalName());
            } else {
                secretKey = this.lastPrincipalFound.getSecretKey();
            }
        }
        catch (RuntimeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WSSecurityException(3, "kerberosAcceptCtxFailed", new Object[]{e.getMessage()});
        }
        catch (LoginException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WSSecurityException(3, "kerberosLoginFailed", new Object[]{e.getMessage()});
        }
        catch (GSSException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WSSecurityException(3, "kerberosSTCreateFailed", new Object[]{e.getMessage()});
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new WSSecurityException(3, "kerberosSTCreateFailed", new Object[]{e.getMessage()});
        }
        if (secretKey == null) {
            throw new WSSecurityException(6);
        }
        try {
            boolean signatureOk = false;
            signatureOk = sig.checkSignatureValue(secretKey);
            if (!signatureOk) throw new WSSecurityException(6);
            signatureValue[0] = sig.getSignatureValue();
            SignedInfo si = sig.getSignedInfo();
            int numReferences = si.getLength();
            for (int i = 0; i < numReferences; ++i) {
                Reference siRef;
                try {
                    siRef = si.item(i);
                }
                catch (XMLSecurityException e3) {
                    throw new WSSecurityException(6);
                }
                String uri = siRef.getURI();
                if (uri != null && !"".equals(uri)) {
                    Element se = WSSecurityUtil.getElementByWsuId(elem.getOwnerDocument(), uri);
                    if (se == null) {
                        se = WSSecurityUtil.getElementByGenId(elem.getOwnerDocument(), uri);
                    }
                    if (se == null) {
                        throw new WSSecurityException(6);
                    }
                    returnElements.add(WSSecurityUtil.getIDfromReference(uri));
                    continue;
                }
                returnElements.add(siRef);
            }
            return principal;
        }
        catch (XMLSignatureException e1) {
            throw new WSSecurityException(6);
        }
    }

    private void authenticate(CallbackHandler handler) throws LoginException {
        Callback[] cb = new WSPasswordCallback[]{new WSPasswordCallback("servicePrincipalUnknown", 9)};
        String password = null;
        Callback[] para = new WSParameterCallback[]{new WSParameterCallback(1)};
        try {
            handler.handle(cb);
            if (((WSPasswordCallback)cb[0]).getPassword() != null && !"".equals(((WSPasswordCallback)cb[0]).getPassword())) {
                password = ((WSPasswordCallback)cb[0]).getPassword();
            } else {
                handler.handle(para);
                password = ((WSParameterCallback)para[0]).getStringValue();
            }
            if (password == null) {
                throw new LoginException("noPasswordForUser");
            }
        }
        catch (IOException e) {
            throw new LoginException("errorInGettingPasswordForUser");
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException("errorInGettingPasswordForUser");
        }
        LoginContext loginContext = new LoginContext("Server", new CredentialsCallbackHandler(password));
        loginContext.login();
        this.subject = loginContext.getSubject();
    }

    private KerberosSecurity createSecurityToken(Element element) throws WSSecurityException {
        BinarySecurity token = new BinarySecurity(element);
        String type = token.getValueType();
        KerberosSecurity krbTkn = null;
        if ("http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ".equals(type)) {
            krbTkn = new KerberosSecurity(element);
            return krbTkn;
        }
        throw new WSSecurityException(1, "unsupportedBinaryTokenType", new Object[]{type});
    }

    private GSSContext acceptSecurityContext(final KerberosSecurity ks) throws GSSException {
        Subject.doAs(this.subject, new PrivilegedAction<GSSContext>(){

            @Override
            public GSSContext run() {
                try {
                    GSSManager gssManager = null;
                    gssManager = GSSManager.getInstance();
                    KerberosTokenProcessor.this.gssContext = gssManager.createContext((GSSCredential)null);
                    byte[] token = ks.getToken();
                    KerberosTokenProcessor.this.gssContext.acceptSecContext(token, 0, token.length);
                    return KerberosTokenProcessor.this.gssContext;
                }
                catch (GSSException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        return this.gssContext;
    }

    protected SecretKey getSessionKey(byte[] serviceTicket) throws Exception {
        KrbTicketDecoder decoder = new KrbTicketDecoder(serviceTicket, this.subject);
        return decoder.getSessionKey();
    }

    public String getId() {
        return this.tokenId;
    }

    public KerberosTokenPrincipal getLastPrincipalFound() {
        return this.lastPrincipalFound;
    }
}

