/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.solr.analysis.BufferedTokenStream;
import org.apache.solr.analysis.CommonGramsFilter;

public class CommonGramsQueryFilter
extends BufferedTokenStream {
    private Token prev = new Token();

    public CommonGramsQueryFilter(CommonGramsFilter input) {
        super(input);
    }

    public void reset() throws IOException {
        super.reset();
        this.prev = new Token();
    }

    public Token process(Token token) throws IOException {
        Token next = this.peek(1);
        if (next == null) {
            if (this.prev == null) {
                return token;
            }
            if (this.prev != null && this.prev.type() != "gram") {
                return token;
            }
            return null;
        }
        if (next != null && next.type() == "gram") {
            token = this.read();
            this.prev.reinit(token.termBuffer(), 0, token.termLength(), token.startOffset(), token.endOffset(), token.type());
            token.setPositionIncrement(1);
            return token;
        }
        this.prev.reinit(token.termBuffer(), 0, token.termLength(), token.startOffset(), token.endOffset(), token.type());
        assert (token.type() == "word");
        return token;
    }
}

