/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding;

import java.awt.Image;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.axis2.java.security.AccessController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JAXBContextFromClasses {
    private static final Log log = LogFactory.getLog(JAXBContextFromClasses.class);
    private static List<Class> commonArrayClasses = new ArrayList<Class>();

    private JAXBContextFromClasses() {
    }

    public static JAXBContext newInstance(Class[] classArray, ClassLoader cl, Map<String, ?> properties) throws JAXBException {
        return JAXBContextFromClasses.newInstance(classArray, cl, properties, new ArrayList<String>());
    }

    public static JAXBContext newInstance(Class[] classArray, ClassLoader cl, Map<String, ?> properties, List<String> classRefs) throws JAXBException {
        JAXBContext jaxbContext = null;
        try {
            if (log.isDebugEnabled()) {
                if (classArray == null || classArray.length == 0) {
                    log.debug((Object)"Try to construct JAXBContext with 0 input classes.");
                } else {
                    log.debug((Object)("Try to construct JAXBContext with " + classArray.length + " input classes."));
                }
            }
            jaxbContext = JAXBContextFromClasses._newInstance(classArray, cl, properties);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully constructed JAXBContext " + jaxbContext));
            }
        }
        catch (Throwable t) {
            ArrayList<Class> original = new ArrayList<Class>();
            for (int i = 0; i < classArray.length; ++i) {
                original.add(classArray[i]);
            }
            ArrayList<Class> best = new ArrayList<Class>();
            jaxbContext = JAXBContextFromClasses.findBestSet(original, cl, best, properties, classRefs);
        }
        return jaxbContext;
    }

    private static JAXBContext _newInstance(final Class[] classArray, final ClassLoader cl, final Map<String, ?> properties) throws Throwable {
        JAXBContext jaxbContext;
        try {
            jaxbContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws JAXBException {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader savedClassLoader = currentThread.getContextClassLoader();
                    try {
                        currentThread.setContextClassLoader(cl);
                        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])classArray, (Map)properties);
                        return jAXBContext;
                    }
                    finally {
                        currentThread.setContextClassLoader(savedClassLoader);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        catch (Throwable t) {
            throw t;
        }
        return jaxbContext;
    }

    static void separate(List<Class> original, List<Class> primary, List<Class> secondary, List<String> classRefs) {
        for (int i = 0; i < original.size(); ++i) {
            Package pkg;
            Class cls = original.get(i);
            String clsName = cls.getCanonicalName();
            if (commonArrayClasses.contains(cls)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("This looks like a JAXB common class. Adding it to primary list:" + cls.getName()));
                }
                primary.add(cls);
                continue;
            }
            if (classRefs.contains(clsName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("This is a referenced class. Adding it to primary list:" + clsName));
                }
                if ((pkg = cls.getPackage()) != null && pkg.getName().endsWith(".jaxws")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("This looks like a jaxws generated Class. Adding it to the front of the primary list:" + cls.getName()));
                    }
                    primary.add(0, cls);
                    continue;
                }
                primary.add(cls);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("This class is not referenced by the web service. Adding it to secondary list:" + cls.getName()));
            }
            if ((pkg = cls.getPackage()) != null && pkg.getName().endsWith(".jaxws")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("This looks like a jaxws generated Class. Adding it to the front of the secondary list:" + cls.getName()));
                }
                secondary.add(0, cls);
                continue;
            }
            secondary.add(cls);
        }
    }

    static JAXBContext findBestSet(List<Class> original, ClassLoader cl, List<Class> best, Map<String, ?> properties, List<String> classRefs) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Could not construct JAXBContext with the initial list.");
            log.debug((Object)"Now trying to construct JAXBContext with only the valid classes in the list");
        }
        JAXBContext jc = null;
        Class[] clsArray = new Class[]{};
        ArrayList<Class> primary = new ArrayList<Class>();
        ArrayList<Class> secondary = new ArrayList<Class>();
        JAXBContextFromClasses.separate(original, primary, secondary, classRefs);
        best.addAll(primary);
        if (best.size() > 0) {
            try {
                jc = JAXBContextFromClasses._newInstance(best.toArray(clsArray), cl, properties);
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The JAXBContext creation failed with the primary list");
                    log.debug((Object)"Will try a more brute force algorithm");
                    log.debug((Object)("  The reason is " + t));
                }
                secondary.addAll(primary);
                best.clear();
            }
        }
        for (int i = 0; i < secondary.size(); ++i) {
            Class cls = secondary.get(i);
            best.add(cls);
            try {
                jc = JAXBContextFromClasses._newInstance(best.toArray(clsArray), cl, properties);
                continue;
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The following class is not a JAXB class: " + cls.getCanonicalName()));
                    log.debug((Object)"  JAXBContext creation continues without this class.");
                    log.debug((Object)("  The reason is " + t));
                }
                best.remove(cls);
            }
        }
        return jc;
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation) {
        return (Annotation)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotation);
            }
        });
    }

    static {
        commonArrayClasses.add(boolean[].class);
        commonArrayClasses.add(byte[].class);
        commonArrayClasses.add(char[].class);
        commonArrayClasses.add(double[].class);
        commonArrayClasses.add(float[].class);
        commonArrayClasses.add(int[].class);
        commonArrayClasses.add(long[].class);
        commonArrayClasses.add(short[].class);
        commonArrayClasses.add(String[].class);
        commonArrayClasses.add(Object[].class);
        commonArrayClasses.add(Image[].class);
        commonArrayClasses.add(BigDecimal[].class);
        commonArrayClasses.add(BigInteger[].class);
        commonArrayClasses.add(Calendar[].class);
        commonArrayClasses.add(QName[].class);
    }
}

