/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IndexMergeTool {
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("Usage: IndexMergeTool <mergedIndex> <index1> <index2> [index3] ...");
            System.exit(1);
        }
        File mergedIndex = new File(args[0]);
        IndexWriter writer = new IndexWriter(mergedIndex, (Analyzer)new SimpleAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
        Directory[] indexes = new Directory[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            indexes[i - 1] = FSDirectory.open(new File(args[i]));
        }
        System.out.println("Merging...");
        writer.addIndexes(indexes);
        System.out.println("Optimizing...");
        writer.optimize();
        writer.close();
        System.out.println("Done.");
    }
}

