/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.list.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WebAppDataExtractor {
    private Map<String, String> jaxWSMap = new HashMap<String, String>();
    private Map<String, String> jaxRSMap = new HashMap<String, String>();
    private String serviceListPath = "";
    private String cxfConfigFileLocation = "WEB-INF/cxf-servlet.xml";
    private String jaxservletUrlPattern = "services";
    private static final Log log = LogFactory.getLog(WebAppDataExtractor.class);

    public Map<String, String> getJaxWSMap() {
        return this.jaxWSMap;
    }

    public void setJaxWSMap(Map<String, String> jaxWSMap) {
        this.jaxWSMap = jaxWSMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getServletXML(InputStream inputStream) {
        this.jaxWSMap.clear();
        this.jaxRSMap.clear();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            OMElement temp;
            ZipEntry entry;
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            while ((entry = zipInputStream.getNextEntry()) != null) {
                int count;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buff = new byte[1024];
                while ((count = zipInputStream.read(buff)) != -1) {
                    baos.write(buff, 0, count);
                }
                String filename = entry.getName();
                byte[] bytes = baos.toByteArray();
                map.put(filename, bytes);
            }
            String webXmlString = WebAppDataExtractor.stripNonValidXMLCharacters(new String((byte[])map.get("WEB-INF/web.xml")));
            this.processWebXml(webXmlString);
            String configFile = "";
            if (!map.containsKey(this.cxfConfigFileLocation)) {
                return;
            }
            configFile = new String((byte[])map.get(this.cxfConfigFileLocation));
            configFile = WebAppDataExtractor.stripNonValidXMLCharacters(configFile);
            OMElement element = AXIOMUtil.stringToOM((String)configFile);
            Iterator iterator = element.getChildrenWithName(new QName("http://cxf.apache.org/jaxws", "endpoint"));
            while (iterator.hasNext()) {
                temp = (OMElement)iterator.next();
                this.jaxWSMap.put(temp.getAttribute(new QName("id")).getAttributeValue(), temp.getAttribute(new QName("address")).getAttributeValue());
            }
            iterator = element.getChildrenWithName(new QName("http://cxf.apache.org/jaxws", "server"));
            while (iterator.hasNext()) {
                temp = (OMElement)iterator.next();
                this.jaxWSMap.put(temp.getAttribute(new QName("id")).getAttributeValue(), temp.getAttribute(new QName("address")).getAttributeValue());
            }
            iterator = element.getChildrenWithName(new QName("http://cxf.apache.org/jaxrs", "server"));
            while (iterator.hasNext()) {
                temp = (OMElement)iterator.next();
                this.jaxRSMap.put(temp.getAttribute(new QName("id")).getAttributeValue(), temp.getAttribute(new QName("address")).getAttributeValue());
            }
            this.setServiceListPath(this.processServiceListPathWebXml(webXmlString));
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static String stripNonValidXMLCharacters(String in) {
        StringBuilder out = new StringBuilder();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public List getWSDLs(String serverURL) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> iterator = this.jaxWSMap.keySet().iterator();
        while (iterator.hasNext()) {
            list.add(serverURL + this.jaxservletUrlPattern + this.jaxWSMap.get(iterator.next()) + "?wsdl");
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public List getWADLs(String serverURL) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> iterator = this.jaxRSMap.keySet().iterator();
        while (iterator.hasNext()) {
            list.add(serverURL + this.jaxservletUrlPattern + this.jaxRSMap.get(iterator.next()) + "?_wadl");
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public String getServiceListPath() {
        return this.serviceListPath;
    }

    private void setServiceListPath(String serviceListPathInitParam) {
        boolean emptyAddress = false;
        for (String address : this.jaxRSMap.values()) {
            if (!"/".equals(address)) continue;
            emptyAddress = true;
        }
        for (String address : this.jaxWSMap.values()) {
            if (!"/".equals(address)) continue;
            emptyAddress = true;
        }
        this.serviceListPath = emptyAddress ? (!"".equals(serviceListPathInitParam) ? serviceListPathInitParam : "/services") : serviceListPathInitParam;
    }

    private void processWebXml(String stream) {
        try {
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(stream));
            DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = b.parse(is);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String configLocationParam = xPath.evaluate("/web-app/servlet/init-param[param-name[contains(text(),'config-location')]]/param-value/text()", doc.getDocumentElement());
            if (configLocationParam == null || configLocationParam == "") {
                configLocationParam = xPath.evaluate("/web-app/context-param[param-name[contains(text(),'contextConfigLocation')]]/param-value/text()", doc.getDocumentElement());
            }
            String cxfServletName = xPath.evaluate("/web-app/servlet[servlet-class[contains(text(),'org.apache.cxf.transport.servlet.CXFServlet')]]/servlet-name/text()", doc.getDocumentElement());
            String jaxservletUrlPattern = xPath.evaluate("/web-app/servlet-mapping[servlet-name/text()=\"" + cxfServletName + "\"]/url-pattern/text()", doc.getDocumentElement());
            this.cxfConfigFileLocation = !"".equals(configLocationParam) && configLocationParam != null ? configLocationParam : "WEB-INF/cxf-servlet.xml";
            if (!"".equals(jaxservletUrlPattern) && jaxservletUrlPattern != null) {
                if (jaxservletUrlPattern.endsWith("/*")) {
                    jaxservletUrlPattern = jaxservletUrlPattern.substring(0, jaxservletUrlPattern.length() - 2);
                }
                if (jaxservletUrlPattern.startsWith("/")) {
                    jaxservletUrlPattern = jaxservletUrlPattern.substring(1);
                }
                this.jaxservletUrlPattern = jaxservletUrlPattern;
            } else {
                this.jaxservletUrlPattern = "services";
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private String processServiceListPathWebXml(String stream) {
        try {
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(stream));
            DocumentBuilder b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = b.parse(is);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String serviceListPathParam = xPath.evaluate("/web-app/servlet/init-param[param-name[contains(text(), 'service-list-path')]]/param-value/text()", doc.getDocumentElement());
            if (!"".equals(serviceListPathParam) && serviceListPathParam != null) {
                return serviceListPathParam;
            }
            return "";
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            return "";
        }
    }
}

