/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadDumpHandler
extends RequestHandlerBase {
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        NamedList<SimpleOrderedMap<Object>> lst;
        ThreadInfo[] tinfos;
        SimpleOrderedMap system = new SimpleOrderedMap();
        rsp.add("system", system);
        ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();
        SimpleOrderedMap<Integer> nl = new SimpleOrderedMap<Integer>();
        nl.add("current", tmbean.getThreadCount());
        nl.add("peak", tmbean.getPeakThreadCount());
        nl.add("daemon", tmbean.getDaemonThreadCount());
        system.add("threadCount", nl);
        long[] tids = tmbean.findMonitorDeadlockedThreads();
        if (tids != null) {
            tinfos = tmbean.getThreadInfo(tids, Integer.MAX_VALUE);
            lst = new NamedList<SimpleOrderedMap<Object>>();
            for (ThreadInfo ti : tinfos) {
                lst.add("thread", ThreadDumpHandler.getThreadInfo(ti, tmbean));
            }
            system.add("deadlocks", lst);
        }
        tids = tmbean.getAllThreadIds();
        tinfos = tmbean.getThreadInfo(tids, Integer.MAX_VALUE);
        lst = new NamedList();
        for (ThreadInfo ti : tinfos) {
            lst.add("thread", ThreadDumpHandler.getThreadInfo(ti, tmbean));
        }
        system.add("threadDump", lst);
        rsp.setHttpCaching(false);
    }

    private static SimpleOrderedMap<Object> getThreadInfo(ThreadInfo ti, ThreadMXBean tmbean) throws IOException {
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        long tid = ti.getThreadId();
        info.add("id", tid);
        info.add("name", ti.getThreadName());
        info.add("state", ti.getThreadState().toString());
        if (ti.getLockName() != null) {
            info.add("lock", ti.getLockName());
        }
        if (ti.isSuspended()) {
            info.add("suspended", true);
        }
        if (ti.isInNative()) {
            info.add("native", true);
        }
        if (tmbean.isThreadCpuTimeSupported()) {
            info.add("cpuTime", ThreadDumpHandler.formatNanos(tmbean.getThreadCpuTime(tid)));
            info.add("userTime", ThreadDumpHandler.formatNanos(tmbean.getThreadUserTime(tid)));
        }
        if (ti.getLockOwnerName() != null) {
            SimpleOrderedMap<Object> owner = new SimpleOrderedMap<Object>();
            owner.add("name", ti.getLockOwnerName());
            owner.add("id", ti.getLockOwnerId());
        }
        int i = 0;
        String[] trace = new String[ti.getStackTrace().length];
        for (StackTraceElement ste : ti.getStackTrace()) {
            trace[i++] = ste.toString();
        }
        info.add("stackTrace", trace);
        return info;
    }

    private static String formatNanos(long ns) {
        return String.format("%.4fms", (double)ns / 1000000.0);
    }

    @Override
    public String getDescription() {
        return "Thread Dump";
    }

    @Override
    public String getVersion() {
        return "$Revision: 790580 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: ThreadDumpHandler.java 790580 2009-07-02 13:20:22Z markrmiller $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/admin/ThreadDumpHandler.java $";
    }
}

