/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.list.ui;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

public class WebAppDataExtractor {
    private Map<String, String> jaxWSMap = new HashMap<String, String>();
    private Map<String, String> jaxRSMap = new HashMap<String, String>();

    public Map<String, String> getJaxWSMap() {
        return this.jaxWSMap;
    }

    public void setJaxWSMap(Map<String, String> jaxWSMap) {
        this.jaxWSMap = jaxWSMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getServletXML(InputStream inputStream) throws Exception {
        this.jaxWSMap.clear();
        this.jaxRSMap.clear();
        byte[] buffer = new byte[2048];
        ZipInputStream stream = new ZipInputStream(inputStream);
        try {
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                OMElement temp;
                if (!entry.getName().equals("WEB-INF/cxf-servlet.xml")) continue;
                int len = 0;
                String output = "";
                while ((len = stream.read(buffer)) > 0) {
                    output = output + new String(buffer);
                    buffer = new byte[2048];
                }
                output = WebAppDataExtractor.stripNonValidXMLCharacters(output);
                OMElement element = AXIOMUtil.stringToOM((String)output);
                Iterator iterator = element.getChildrenWithName(new QName("http://cxf.apache.org/jaxws", "endpoint"));
                while (iterator.hasNext()) {
                    temp = (OMElement)iterator.next();
                    this.jaxWSMap.put(temp.getAttribute(new QName("id")).getAttributeValue(), temp.getAttribute(new QName("address")).getAttributeValue());
                }
                iterator = element.getChildrenWithName(new QName("http://cxf.apache.org/jaxrs", "server"));
                while (iterator.hasNext()) {
                    temp = (OMElement)iterator.next();
                    this.jaxRSMap.put(temp.getAttribute(new QName("id")).getAttributeValue(), temp.getAttribute(new QName("address")).getAttributeValue());
                }
            }
        }
        finally {
            stream.close();
        }
    }

    private static String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public List getWSDLs(String serverURL) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> iterator = this.jaxWSMap.keySet().iterator();
        while (iterator.hasNext()) {
            list.add(serverURL + "services" + this.jaxWSMap.get(iterator.next()) + "?wsdl");
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public List getWADLs(String serverURL) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> iterator = this.jaxRSMap.keySet().iterator();
        while (iterator.hasNext()) {
            list.add(serverURL + "services" + this.jaxRSMap.get(iterator.next()) + "?_wadl");
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }
}

