/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.tomcat.ext.utils.URLMappingHolder;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.TomcatUtil;
import org.wso2.carbon.webapp.mgt.WebContextParameter;

public class WebApplication {
    private static final Log log = LogFactory.getLog(WebApplication.class);
    public static final String ENABLE_SAAS = "carbon.enable.saas";
    private Context context;
    private File webappFile;
    private long lastModifiedTime;
    private Exception faultReason;
    private String state;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private TomcatGenericWebappsDeployer tomcatGenericWebappsDeployer;
    private boolean isThisGhost = false;

    public WebApplication(TomcatGenericWebappsDeployer tomcatGenericWebappsDeployer, Context context, File webappFile) {
        this.tomcatGenericWebappsDeployer = tomcatGenericWebappsDeployer;
        this.context = context;
        this.setWebappFile(webappFile);
        this.setLastModifiedTime(webappFile.lastModified());
    }

    public void setServletContextParameters(List<WebContextParameter> parameters) {
        for (WebContextParameter parameter : parameters) {
            this.context.getServletContext().setInitParameter(parameter.getName(), parameter.getValue());
        }
    }

    public File getWebappFile() {
        return this.webappFile;
    }

    public void setWebappFile(File webappFile) {
        this.webappFile = webappFile;
    }

    public String getContextName() {
        return this.context.getName();
    }

    public String getDisplayName() {
        return this.context.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.context.setDisplayName(name);
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Exception getFaultReason() {
        return this.faultReason;
    }

    public void setFaultReason(Exception faultReason) {
        this.faultReason = faultReason;
    }

    public void setProperty(String key, Object value) {
        if (key != null) {
            this.properties.put(key, value);
        }
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public TomcatGenericWebappsDeployer getTomcatGenericWebappsDeployer() {
        return this.tomcatGenericWebappsDeployer;
    }

    public boolean reload() {
        try {
            this.handleHotUpdateToHost("reload");
        }
        catch (CarbonException e) {
            log.error((Object)"error while reloading context for the hosts", (Throwable)e);
        }
        return this.reload(this.context);
    }

    private boolean reload(Context contextOfWepap) {
        if (contextOfWepap.getAvailable()) {
            contextOfWepap.reload();
            log.info((Object)("Reloaded webapp: " + contextOfWepap));
            return true;
        }
        return false;
    }

    public boolean stop() throws CarbonException {
        this.handleHotUpdateToHost("stop");
        return this.stop(this.context);
    }

    private boolean stop(Context contextOfWepap) throws CarbonException {
        try {
            if (contextOfWepap.getAvailable()) {
                contextOfWepap.stop();
                this.setState("Stopped");
                log.info((Object)("Stopped webapp: " + contextOfWepap));
                return true;
            }
        }
        catch (Exception e) {
            throw new CarbonException("Cannot temporarilly stop webapp " + contextOfWepap, (Throwable)e);
        }
        return false;
    }

    public boolean start() throws CarbonException {
        this.handleHotUpdateToHost("start");
        return this.start(this.context);
    }

    private boolean start(Context contextOfWepap) throws CarbonException {
        try {
            if (!contextOfWepap.getAvailable()) {
                contextOfWepap.start();
                this.setState("Started");
                log.info((Object)("Started webapp: " + contextOfWepap));
                return true;
            }
        }
        catch (Exception e) {
            throw new CarbonException("Cannot start webapp " + contextOfWepap, (Throwable)e);
        }
        return false;
    }

    public void lazyUnload() throws CarbonException {
        this.handleHotUpdateToHost("lazyUnload");
        this.lazyUnload(this.context);
    }

    private void lazyUnload(Context context) throws CarbonException {
        Host host = DataHolder.getCarbonTomcatService().getTomcat().getHost();
        try {
            if (context.getAvailable()) {
                context.setRealm(null);
                context.stop();
                context.destroy();
                host.removeChild((Container)context);
                log.info((Object)("Unloaded webapp: " + context));
            } else if (LifecycleState.STOPPED.equals((Object)context.getState())) {
                context.setRealm(null);
                context.destroy();
                host.removeChild((Container)context);
                log.info((Object)("Unloaded webapp: " + context));
            }
        }
        catch (Exception e) {
            throw new CarbonException("Cannot lazy unload webapp " + this.context, (Throwable)e);
        }
    }

    public void undeploy() throws CarbonException {
        File warFile;
        File webappDir;
        PrivilegedCarbonContext currentCarbonAppContextHolder = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        currentCarbonAppContextHolder.setApplicationName(TomcatUtil.getApplicationNameFromContext(this.context.getBaseName()));
        this.lazyUnload();
        if (this.webappFile.getAbsolutePath().endsWith(".war")) {
            String filePath = this.webappFile.getAbsolutePath();
            webappDir = new File(filePath.substring(0, filePath.lastIndexOf(46)));
            warFile = this.webappFile;
        } else {
            webappDir = this.webappFile;
            warFile = new File(this.webappFile.getAbsolutePath().concat(".war"));
        }
        if (TomcatUtil.checkUnpackWars() && webappDir.exists() && !this.webappFile.isDirectory() && !FileManipulator.deleteDir((File)webappDir)) {
            throw new CarbonException("exploded Webapp directory " + webappDir + " deletion failed");
        }
        if (TomcatUtil.checkUnpackWars() && this.webappFile.isDirectory() && warFile.exists() && !FileManipulator.deleteDir((File)warFile)) {
            throw new CarbonException("Webapp file " + warFile + " deletion failed");
        }
    }

    private void handleHotUpdateToHost(String nameOfOperation) throws CarbonException {
        if (DataHolder.getHotUpdateService() != null) {
            List mappings = URLMappingHolder.getInstance().getUrlMappingsPerApplication(this.context.getName());
            Engine engine = DataHolder.getCarbonTomcatService().getTomcat().getEngine();
            for (String hostName : mappings) {
                Context hostContext;
                Host host = (Host)engine.findChild(hostName);
                if (host == null || (hostContext = (Context)host.findChild("/")) == null) continue;
                if (nameOfOperation.equalsIgnoreCase("start")) {
                    this.start(hostContext);
                    continue;
                }
                if (nameOfOperation.equalsIgnoreCase("stop")) {
                    this.stop(hostContext);
                    continue;
                }
                if (nameOfOperation.equalsIgnoreCase("reload")) {
                    this.reload(hostContext);
                    continue;
                }
                if (nameOfOperation.equalsIgnoreCase("lazyunload")) {
                    this.lazyUnload(hostContext);
                    DataHolder.getHotUpdateService().removeHost(hostName);
                    continue;
                }
                if (!nameOfOperation.equalsIgnoreCase("delete")) continue;
                DataHolder.getHotUpdateService().deleteHost(hostName);
            }
        }
    }

    public void delete() throws CarbonException {
        this.handleHotUpdateToHost("delete");
        this.undeploy();
        if (this.webappFile.isFile() && !this.webappFile.delete()) {
            throw new CarbonException("Webapp file " + this.webappFile + " deletion failed");
        }
        if (this.webappFile.isDirectory() && !FileManipulator.deleteDir((File)this.webappFile)) {
            throw new CarbonException("Webapp Directory " + this.webappFile + " deletion failed");
        }
    }

    protected File getAppBase() {
        File appBase = null;
        File file = new File(DataHolder.getCarbonTomcatService().getTomcat().getHost().getAppBase());
        try {
            appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            appBase = file;
        }
        return appBase;
    }

    private String getConfigFile(String path) {
        String basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    private File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        Context host = null;
        Context engine = null;
        for (Context container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            configBase = new File(configBase, engine.getName());
        }
        if (host != null) {
            configBase = new File(configBase, host.getName());
        }
        return configBase;
    }

    private String getDocBase(String path) {
        String basename = path.equals("") ? "ROOT" : path.substring(1);
        return basename;
    }

    public void expireAllSessions() {
        Session[] sessions;
        for (Session session : sessions = this.context.getManager().findSessions()) {
            session.expire();
        }
    }

    public void expireSessions(long maxLifetimeMillis) {
        Session[] sessions;
        for (Session session : sessions = this.context.getManager().findSessions()) {
            if (System.currentTimeMillis() - session.getCreationTime() < maxLifetimeMillis) continue;
            session.expire();
        }
    }

    public void expireSessions(String[] sessionIDs) throws CarbonException {
        Manager manager = this.context.getManager();
        try {
            for (String sessionID : sessionIDs) {
                manager.findSession(sessionID).expire();
            }
        }
        catch (IOException e) {
            throw new CarbonException("Cannot expire sessions", (Throwable)e);
        }
    }

    public List<HttpSession> getSessions() {
        Session[] tomcatSessions = this.context.getManager().findSessions();
        ArrayList<HttpSession> sessions = new ArrayList<HttpSession>();
        for (Session tomcatSession : tomcatSessions) {
            sessions.add(new HttpSession(tomcatSession));
        }
        return sessions;
    }

    public HttpSession getSession(String sessionId) throws CarbonException {
        Session session;
        try {
            session = this.context.getManager().findSession(sessionId);
        }
        catch (IOException e) {
            throw new CarbonException("Cannot find session " + sessionId, (Throwable)e);
        }
        if (session != null) {
            return new HttpSession(session);
        }
        return null;
    }

    public Statistics getStatistics() {
        return new Statistics(this.context.getManager());
    }

    public String toString() {
        return this.context + ".File[" + this.webappFile.getAbsolutePath() + "]";
    }

    public Context getContext() {
        return this.context;
    }

    public void setIsGhostWebapp(boolean isThisGhost) {
        this.isThisGhost = isThisGhost;
    }

    public static class HttpSession {
        private Session tomcatSession;

        public HttpSession(Session tomcatSession) {
            this.tomcatSession = tomcatSession;
        }

        public String getSessionId() {
            return this.tomcatSession.getId();
        }

        public String getAuthType() {
            return this.tomcatSession.getAuthType();
        }

        public long getCreationTime() {
            return this.tomcatSession.getCreationTime();
        }

        public long getLastAccessedTime() {
            return this.tomcatSession.getLastAccessedTime();
        }

        public long getMaxInactiveInterval() {
            return this.tomcatSession.getMaxInactiveInterval();
        }

        public void expire() {
            this.tomcatSession.expire();
        }
    }

    public final class Statistics {
        private Manager sessionManager;

        private Statistics(Manager sessionManager) {
            this.sessionManager = sessionManager;
        }

        public int getMaxActiveSessions() {
            return this.sessionManager.getMaxActive();
        }

        public int getMaxSessionInactivityInterval() {
            return this.sessionManager.getMaxInactiveInterval();
        }

        public int getMaxSessionLifetime() {
            return this.sessionManager.getSessionMaxAliveTime();
        }

        public int getAvgSessionLifetime() {
            return this.sessionManager.getSessionAverageAliveTime();
        }

        public int getRejectedSessions() {
            return this.sessionManager.getRejectedSessions();
        }

        public int getActiveSessions() {
            if (GhostDeployerUtils.isGhostOn()) {
                if (WebApplication.this.isThisGhost || this.sessionManager == null) {
                    return 0;
                }
                return this.sessionManager.getActiveSessions();
            }
            return this.sessionManager.getActiveSessions();
        }

        public long getExpiredSessions() {
            return this.sessionManager.getExpiredSessions();
        }
    }
}

