/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.Host;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;
import org.wso2.carbon.webapp.mgt.utils.GhostWebappDeployerUtils;

public abstract class AbstractWebappDeployer
extends AbstractDeployer {
    private static final Log log = LogFactory.getLog(AbstractWebappDeployer.class);
    protected String webappsDir;
    protected String extension;
    protected TomcatGenericWebappsDeployer tomcatWebappDeployer;
    protected final List<WebContextParameter> servletContextParameters = new ArrayList<WebContextParameter>();
    protected ConfigurationContext configContext;
    protected AxisConfiguration axisConfig;
    protected WebApplicationsHolder webappsHolder;
    private boolean isGhostOn;

    public void init(ConfigurationContext configCtx) {
        this.configContext = configCtx;
        this.axisConfig = configCtx.getAxisConfiguration();
        String repoPath = configCtx.getAxisConfiguration().getRepository().getPath();
        File webappsDirFile = new File(repoPath + File.separator + this.webappsDir);
        if (!webappsDirFile.exists() && !webappsDirFile.mkdirs()) {
            log.warn((Object)("Could not create directory " + webappsDirFile.getAbsolutePath()));
        }
        PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getCurrentContext((ConfigurationContext)configCtx);
        int tenantId = privilegedCarbonContext.getTenantId();
        String tenantDomain = privilegedCarbonContext.getTenantDomain();
        String webContextPrefix = tenantDomain != null ? "/t/" + tenantDomain + "/" + this.webappsDir + "/" : "";
        this.webappsHolder = (WebApplicationsHolder)configCtx.getProperty("carbon.webapps.holder");
        if (this.webappsHolder == null) {
            this.webappsHolder = new WebApplicationsHolder(new File(this.webappsDir));
            configCtx.setProperty("carbon.webapps.holder", (Object)this.webappsHolder);
        }
        this.tomcatWebappDeployer = this.createTomcatGenericWebappDeployer(webContextPrefix, tenantId, tenantDomain);
        configCtx.setProperty("servlet.context.parameters.list", this.servletContextParameters);
        this.isGhostOn = GhostDeployerUtils.isGhostOn();
    }

    protected abstract TomcatGenericWebappsDeployer createTomcatGenericWebappDeployer(String var1, int var2, String var3);

    protected abstract String getType();

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        if (!this.isSkippedWebapp(deploymentFileData.getFile())) {
            String webappName = deploymentFileData.getFile().getName();
            if (!this.isGhostOn) {
                this.deployThisWebApp(deploymentFileData);
            } else {
                String absoluteFilePath = deploymentFileData.getAbsolutePath();
                File ghostFile = GhostWebappDeployerUtils.getGhostFile(absoluteFilePath, this.axisConfig);
                if (ghostFile == null || !ghostFile.exists()) {
                    this.deployThisWebApp(deploymentFileData);
                    WebApplication webApplication = GhostWebappDeployerUtils.findDeployedWebapp(this.configContext, webappName);
                    if (webApplication != null) {
                        GhostWebappDeployerUtils.updateLastUsedTime(webApplication);
                        if (!CarbonUtils.isWorkerNode()) {
                            GhostWebappDeployerUtils.serializeWebApp(webApplication, this.axisConfig, absoluteFilePath);
                        }
                    }
                } else {
                    WebApplication ghostWebApplication = GhostWebappDeployerUtils.createGhostWebApp(ghostFile, deploymentFileData.getFile(), this.tomcatWebappDeployer, this.configContext);
                    String ghostWebappFileName = deploymentFileData.getFile().getName();
                    if (!this.webappsHolder.getStartedWebapps().containsKey(ghostWebappFileName)) {
                        WebApplicationsHolder webappsHolder = (WebApplicationsHolder)this.configContext.getProperty("carbon.webapps.holder");
                        log.info((Object)("Deploying Ghost webapp : " + ghostWebappFileName));
                        webappsHolder.getStartedWebapps().put(ghostWebappFileName, ghostWebApplication);
                        webappsHolder.getFaultyWebapps().remove(ghostWebappFileName);
                    }
                }
            }
        }
    }

    private void deployThisWebApp(DeploymentFileData deploymentFileData) throws DeploymentException {
        try {
            ArrayList<Object> listeners = new ArrayList<Object>(1);
            this.tomcatWebappDeployer.deploy(deploymentFileData.getFile(), (ArrayList)this.configContext.getProperty("servlet.context.parameters.list"), listeners);
            super.deploy(deploymentFileData);
            WebApplication webApplication = GhostWebappDeployerUtils.findDeployedWebapp(this.configContext, deploymentFileData.getFile().getName());
            if (webApplication != null) {
                webApplication.setProperty("webappFilter", this.getType());
            }
        }
        catch (Exception e) {
            String msg = "Error occurred while deploying webapp : " + deploymentFileData.getFile().getAbsolutePath();
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
    }

    public void undeploy(String fileName) throws DeploymentException {
        block7: {
            File webappToUndeploy = new File(fileName);
            if (this.isHotUpdating(webappToUndeploy)) {
                this.handleUndeployment(fileName, webappToUndeploy);
                DeploymentSynchronizer depSynchService = DataHolder.getDeploymentSynchronizerService();
                if (fileName.contains(File.separator + "webapps" + File.separator) && !fileName.contains("tenants")) {
                    String fileToCommit = fileName.substring(0, fileName.lastIndexOf("webapps"));
                    try {
                        if (!CarbonUtils.isDepSyncEnabled() || CarbonUtils.isWorkerNode() || depSynchService == null || !depSynchService.isAutoCommitOn(fileToCommit) || !fileName.endsWith(".war")) break block7;
                        try {
                            depSynchService.commit(fileToCommit, fileToCommit + "webapps" + File.separator);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error occurred while committing : " + fileToCommit), (Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error occurred while committing : " + fileToCommit), (Throwable)e);
                    }
                }
            } else {
                this.handleUndeployment(fileName, webappToUndeploy);
            }
        }
    }

    public void cleanup() throws DeploymentException {
        for (String filePath : this.deploymentFileDataMap.keySet()) {
            try {
                this.tomcatWebappDeployer.lazyUnload(new File(filePath));
            }
            catch (CarbonException e) {
                String msg = "Error occurred during cleaning up webapps";
                log.error((Object)msg, (Throwable)e);
                throw new DeploymentException(msg, (Throwable)e);
            }
        }
        if (this.isGhostOn && this.webappsHolder != null) {
            for (WebApplication webApplication : this.webappsHolder.getStartedWebapps().values()) {
                try {
                    this.tomcatWebappDeployer.lazyUnload(webApplication.getWebappFile());
                }
                catch (CarbonException e) {
                    String msg = "Error occurred during cleaning up webapps";
                    log.error((Object)msg, (Throwable)e);
                    throw new DeploymentException(msg, (Throwable)e);
                }
            }
        }
    }

    private boolean isSkippedWebapp(File webappFile) {
        String webappFilePath = webappFile.getPath();
        boolean isSkipped = true;
        if ("war".equals(this.extension)) {
            webappFilePath = webappFilePath.substring(0, webappFilePath.lastIndexOf("."));
            File explodedFile = new File(webappFilePath);
            isSkipped = explodedFile.exists();
        } else {
            if (webappFilePath.contains("jaxwebapps") || webappFilePath.contains("jaggeryapps")) {
                return false;
            }
            Host host = DataHolder.getCarbonTomcatService().getTomcat().getHost();
            String webappContext = "/" + webappFile.getName();
            boolean isExistingFaultyApp = this.isExistingFaultyApp(webappFile.getName());
            if (host.findChild(webappContext) == null && webappFile.isDirectory() && !isExistingFaultyApp) {
                isSkipped = false;
            }
        }
        return isSkipped;
    }

    private boolean isHotUpdating(File file) {
        return file.exists();
    }

    private void handleUndeployment(String fileName, File webappToUndeploy) throws DeploymentException {
        try {
            this.tomcatWebappDeployer.undeploy(webappToUndeploy);
            if (this.isGhostOn && !GhostWebappDeployerUtils.skipUndeploy(fileName)) {
                File ghostFile = GhostWebappDeployerUtils.getGhostFile(fileName, this.axisConfig);
                File dummyContextDir = GhostWebappDeployerUtils.getDummyContextFile(fileName, this.axisConfig);
                if (ghostFile != null && ghostFile.exists() && !ghostFile.delete()) {
                    log.error((Object)("Error while deleting Ghost webapp file : " + ghostFile.getAbsolutePath()));
                }
                if (dummyContextDir != null && dummyContextDir.exists() && !dummyContextDir.delete()) {
                    log.error((Object)("Error while deleting dummy context file : " + dummyContextDir.getAbsolutePath()));
                }
            }
        }
        catch (CarbonException e) {
            String msg = "Error occurred during undeploying webapp: " + fileName;
            log.error((Object)msg, (Throwable)e);
            throw new DeploymentException(msg, (Throwable)e);
        }
        super.undeploy(fileName);
    }

    public boolean isExistingFaultyApp(String fileName) {
        if (this.webappsHolder.getFaultyWebapps() != null) {
            if (this.webappsHolder.getFaultyWebapps().get(fileName) != null) {
                return true;
            }
            if (this.webappsHolder.getFaultyWebapps().get(fileName + ".war") != null) {
                return true;
            }
        }
        return false;
    }
}

