/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemAccessor;
import javax.xml.xquery.XQItemType;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.evpull.StaxToEventBridge;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xqj.ObjectConverter;
import net.sf.saxon.xqj.SaxonDuration;
import net.sf.saxon.xqj.SaxonXMLGregorianCalendar;
import net.sf.saxon.xqj.SaxonXQDataFactory;
import net.sf.saxon.xqj.SaxonXQItemAccessor;
import net.sf.saxon.xqj.SaxonXQItemType;
import org.w3c.dom.Node;

public class StandardObjectConverter
implements ObjectConverter {
    SaxonXQDataFactory dataFactory;
    Configuration config;

    public StandardObjectConverter(SaxonXQDataFactory factory) {
        this.dataFactory = factory;
        this.config = factory.getConfiguration();
    }

    public Object toObject(XQItemAccessor xqItemAccessor) throws XQException {
        Item item = ((SaxonXQItemAccessor)((Object)xqItemAccessor)).getSaxonItem();
        if (item instanceof AtomicValue) {
            AtomicValue p = (AtomicValue)item;
            int t = p.getItemType(this.config.getTypeHierarchy()).getPrimitiveType();
            switch (t) {
                case 529: {
                    return p.getStringValue();
                }
                case 528: {
                    return ((Base64BinaryValue)p).getBinaryValue();
                }
                case 514: {
                    return ((BooleanValue)p).getBooleanValue();
                }
                case 521: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 519: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 515: {
                    return ((DecimalValue)p).getDecimalValue();
                }
                case 517: {
                    return new Double(((DoubleValue)p).getDoubleValue());
                }
                case 518: {
                    return new SaxonDuration((DurationValue)p);
                }
                case 516: {
                    return new Float(((FloatValue)p).getFloatValue());
                }
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 527: {
                    return ((HexBinaryValue)p).getBinaryValue();
                }
                case 532: {
                    if (p instanceof BigIntegerValue) {
                        return ((BigIntegerValue)p).asBigInteger();
                    }
                    int sub = ((AtomicType)p.getItemType(null)).getFingerprint();
                    switch (sub) {
                        case 532: 
                        case 533: 
                        case 534: 
                        case 539: 
                        case 540: 
                        case 541: {
                            return BigInteger.valueOf(((Int64Value)p).longValue());
                        }
                        case 538: {
                            return new Byte((byte)((Int64Value)p).longValue());
                        }
                        case 536: 
                        case 543: {
                            return new Integer((int)((Int64Value)p).longValue());
                        }
                        case 535: 
                        case 542: {
                            return new Long(((Int64Value)p).longValue());
                        }
                        case 537: 
                        case 544: {
                            return new Short((short)((Int64Value)p).longValue());
                        }
                    }
                    throw new XQException("Unrecognized integer subtype " + sub);
                }
                case 530: {
                    return ((QualifiedNameValue)p).makeQName(this.config);
                }
                case 513: 
                case 631: {
                    return p.getStringValue();
                }
                case 520: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 634: {
                    return new SaxonDuration((DurationValue)p);
                }
                case 633: {
                    return new SaxonDuration((DurationValue)p);
                }
            }
            throw new XQException("unsupported type");
        }
        return NodeOverNodeInfo.wrap((NodeInfo)item);
    }

    public Item convertToItem(Object value) throws XQException {
        try {
            if (value instanceof Boolean) {
                return BooleanValue.get((Boolean)value);
            }
            if (value instanceof byte[]) {
                return new HexBinaryValue((byte[])value);
            }
            if (value instanceof Byte) {
                return new Int64Value(((Byte)value).byteValue(), BuiltInAtomicType.BYTE, false);
            }
            if (value instanceof Float) {
                return new FloatValue(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return new DoubleValue((Double)value);
            }
            if (value instanceof Integer) {
                return new Int64Value(((Integer)value).intValue(), BuiltInAtomicType.INT, false);
            }
            if (value instanceof Long) {
                return new Int64Value((Long)value, BuiltInAtomicType.LONG, false);
            }
            if (value instanceof Short) {
                return new Int64Value(((Short)value).shortValue(), BuiltInAtomicType.SHORT, false);
            }
            if (value instanceof String) {
                return new StringValue((String)value);
            }
            if (value instanceof BigDecimal) {
                return new DecimalValue((BigDecimal)value);
            }
            if (value instanceof BigInteger) {
                return new BigIntegerValue((BigInteger)value);
            }
            if (value instanceof SaxonDuration) {
                return ((SaxonDuration)value).getDurationValue();
            }
            if (value instanceof Duration) {
                return DurationValue.makeDuration(value.toString()).asAtomic();
            }
            if (value instanceof SaxonXMLGregorianCalendar) {
                return ((SaxonXMLGregorianCalendar)value).toCalendarValue();
            }
            if (value instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar g = (XMLGregorianCalendar)value;
                QName gtype = g.getXMLSchemaType();
                if (gtype.equals(DatatypeConstants.DATETIME)) {
                    return DateTimeValue.makeDateTimeValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.DATE)) {
                    return DateValue.makeDateValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.TIME)) {
                    return TimeValue.makeTimeValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GYEAR)) {
                    return GYearValue.makeGYearValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GYEARMONTH)) {
                    return GYearMonthValue.makeGYearMonthValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GMONTH)) {
                    return GMonthValue.makeGMonthValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GMONTHDAY)) {
                    return GMonthDayValue.makeGMonthDayValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GDAY)) {
                    return GDayValue.makeGDayValue(gtype.toString()).asAtomic();
                }
                throw new AssertionError((Object)"Unknown Gregorian date type");
            }
            if (value instanceof QName) {
                QName q = (QName)value;
                return new QNameValue(q.getPrefix(), q.getNamespaceURI(), q.getLocalPart(), BuiltInAtomicType.QNAME, null);
            }
            if (value instanceof Node) {
                JPConverter jp = DOMObjectModel.getInstance().getJPConverter(Node.class);
                return Value.asItem(jp.convert(value, new EarlyEvaluationContext(this.config, null)));
            }
            if (value instanceof Source) {
                TinyBuilder b = new TinyBuilder();
                PipelineConfiguration pipe = this.config.makePipelineConfiguration();
                b.setPipelineConfiguration(pipe);
                new Sender(pipe).send((Source)value, b);
                NodeInfo node = b.getCurrentRoot();
                ((Builder)b).reset();
                return node;
            }
            if (value instanceof XMLStreamReader) {
                StaxToEventBridge bridge = new StaxToEventBridge();
                bridge.setXMLStreamReader((XMLStreamReader)value);
                PipelineConfiguration pipe = this.config.makePipelineConfiguration();
                bridge.setPipelineConfiguration(pipe);
                TinyBuilder b = new TinyBuilder();
                b.setPipelineConfiguration(pipe);
                new Sender(pipe).send(new PullEventSource(bridge), b);
                NodeInfo node = b.getCurrentRoot();
                ((Builder)b).reset();
                return node;
            }
            throw new XPathException("Java object cannot be converted to an XQuery value");
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause(e);
            throw xqe;
        }
    }

    public Item convertToItem(Object value, XQItemType type) throws XQException {
        if (((SaxonXQItemType)type).getSaxonItemType() instanceof ExternalObjectType) {
            return new ObjectValue(value, (ExternalObjectType)((SaxonXQItemType)type).getSaxonItemType());
        }
        throw new XQException("Supplied Java object cannot be converted to an XQItem");
    }
}

