/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.QueryTermScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.highlight.GapFragmenter;
import org.apache.solr.highlight.HtmlFormatter;
import org.apache.solr.highlight.SolrFormatter;
import org.apache.solr.highlight.SolrFragmenter;
import org.apache.solr.highlight.SolrHighlighter;
import org.apache.solr.highlight.TermOffsetsTokenStream;
import org.apache.solr.highlight.TokenOrderingFilter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.PluginInfoInitialized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSolrHighlighter
extends SolrHighlighter
implements PluginInfoInitialized {
    private SolrCore solrCore;
    private boolean initialized = false;

    public DefaultSolrHighlighter() {
    }

    public DefaultSolrHighlighter(SolrCore solrCore) {
        this.solrCore = solrCore;
    }

    @Override
    public void init(PluginInfo info) {
        this.formatters.clear();
        this.fragmenters.clear();
        SolrFragmenter frag = this.solrCore.initPlugins(info.getChildren("fragmenter"), this.fragmenters, SolrFragmenter.class, null);
        if (frag == null) {
            frag = new GapFragmenter();
        }
        this.fragmenters.put("", frag);
        this.fragmenters.put(null, frag);
        SolrFormatter fmt = this.solrCore.initPlugins(info.getChildren("formatter"), this.formatters, SolrFormatter.class, null);
        if (fmt == null) {
            fmt = new HtmlFormatter();
        }
        this.formatters.put("", fmt);
        this.formatters.put(null, fmt);
        this.initialized = true;
    }

    @Override
    @Deprecated
    public void initalize(SolrConfig config) {
        if (this.initialized) {
            return;
        }
        GapFragmenter frag = new GapFragmenter();
        this.fragmenters.put("", frag);
        this.fragmenters.put(null, frag);
        HtmlFormatter fmt = new HtmlFormatter();
        this.formatters.put("", fmt);
        this.formatters.put(null, fmt);
    }

    protected Highlighter getPhraseHighlighter(Query query, String fieldName, SolrQueryRequest request, CachingTokenFilter tokenStream) throws IOException {
        SolrParams params = request.getParams();
        Highlighter highlighter = null;
        highlighter = new Highlighter(this.getFormatter(fieldName, params), this.getSpanQueryScorer(query, fieldName, tokenStream, request));
        highlighter.setTextFragmenter(this.getFragmenter(fieldName, params));
        return highlighter;
    }

    protected Highlighter getHighlighter(Query query, String fieldName, SolrQueryRequest request) {
        SolrParams params = request.getParams();
        Highlighter highlighter = new Highlighter(this.getFormatter(fieldName, params), this.getQueryScorer(query, fieldName, request));
        highlighter.setTextFragmenter(this.getFragmenter(fieldName, params));
        return highlighter;
    }

    private QueryScorer getSpanQueryScorer(Query query, String fieldName, TokenStream tokenStream, SolrQueryRequest request) throws IOException {
        boolean reqFieldMatch = request.getParams().getFieldBool(fieldName, "hl.requireFieldMatch", false);
        Boolean highlightMultiTerm = request.getParams().getBool("hl.highlightMultiTerm", true);
        if (highlightMultiTerm == null) {
            highlightMultiTerm = false;
        }
        QueryScorer scorer = reqFieldMatch ? new QueryScorer(query, fieldName) : new QueryScorer(query, null);
        scorer.setExpandMultiTermQuery(highlightMultiTerm);
        return scorer;
    }

    private Scorer getQueryScorer(Query query, String fieldName, SolrQueryRequest request) {
        boolean reqFieldMatch = request.getParams().getFieldBool(fieldName, "hl.requireFieldMatch", false);
        if (reqFieldMatch) {
            return new QueryTermScorer(query, request.getSearcher().getReader(), fieldName);
        }
        return new QueryTermScorer(query);
    }

    protected int getMaxSnippets(String fieldName, SolrParams params) {
        return params.getFieldInt(fieldName, "hl.snippets", 1);
    }

    protected boolean isMergeContiguousFragments(String fieldName, SolrParams params) {
        return params.getFieldBool(fieldName, "hl.mergeContiguous", false);
    }

    protected Formatter getFormatter(String fieldName, SolrParams params) {
        String str = params.getFieldParam(fieldName, "hl.formatter");
        SolrFormatter formatter = (SolrFormatter)this.formatters.get(str);
        if (formatter == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown formatter: " + str);
        }
        return formatter.getFormatter(fieldName, params);
    }

    protected Fragmenter getFragmenter(String fieldName, SolrParams params) {
        String fmt = params.getFieldParam(fieldName, "hl.fragmenter");
        SolrFragmenter frag = (SolrFragmenter)this.fragmenters.get(fmt);
        if (frag == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fragmenter: " + fmt);
        }
        return frag.getFragmenter(fieldName, params);
    }

    @Override
    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest req, String[] defaultFields) throws IOException {
        SolrParams params = req.getParams();
        if (!this.isHighlightingEnabled(params)) {
            return null;
        }
        SolrIndexSearcher searcher = req.getSearcher();
        IndexSchema schema = searcher.getSchema();
        SimpleOrderedMap<Object> fragments = new SimpleOrderedMap<Object>();
        String[] fieldNames = this.getHighlightFields(query, req, defaultFields);
        HashSet<String> fset = new HashSet<String>();
        for (String f : fieldNames) {
            fset.add(f);
        }
        SchemaField keyField = schema.getUniqueKeyField();
        if (null != keyField) {
            fset.add(keyField.getName());
        }
        DocIterator iterator = docs.iterator();
        for (int i = 0; i < docs.size(); ++i) {
            int docId = iterator.nextDoc();
            Document doc = searcher.doc(docId, fset);
            SimpleOrderedMap<Object> docSummaries = new SimpleOrderedMap<Object>();
            for (String fieldName : fieldNames) {
                String[] altTexts;
                String alternateField;
                String[] docTexts = doc.getValues(fieldName = fieldName.trim());
                if (docTexts == null) continue;
                TokenStream tstream = null;
                int numFragments = this.getMaxSnippets(fieldName, params);
                boolean mergeContiguousFragments = this.isMergeContiguousFragments(fieldName, params);
                String[] summaries = null;
                ArrayList<TextFragment> frags = new ArrayList<TextFragment>();
                TermOffsetsTokenStream tots = null;
                for (int j = 0; j < docTexts.length; ++j) {
                    Highlighter highlighter;
                    try {
                        if (tots == null) {
                            TokenStream tvStream = TokenSources.getTokenStream(searcher.getReader(), docId, fieldName);
                            if (tvStream != null) {
                                tots = new TermOffsetsTokenStream(tvStream);
                                tstream = tots.getMultiValuedTokenStream(docTexts[j].length());
                            } else {
                                tstream = this.createAnalyzerTStream(schema, fieldName, docTexts[j]);
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        tstream = this.createAnalyzerTStream(schema, fieldName, docTexts[j]);
                    }
                    if (Boolean.valueOf(req.getParams().get("hl.usePhraseHighlighter", "true")).booleanValue()) {
                        tstream = new CachingTokenFilter(tstream);
                        highlighter = this.getPhraseHighlighter(query, fieldName, req, (CachingTokenFilter)tstream);
                        tstream.reset();
                    } else {
                        highlighter = this.getHighlighter(query, fieldName, req);
                    }
                    int maxCharsToAnalyze = params.getFieldInt(fieldName, "hl.maxAnalyzedChars", 51200);
                    if (maxCharsToAnalyze < 0) {
                        highlighter.setMaxDocCharsToAnalyze(docTexts[j].length());
                    } else {
                        highlighter.setMaxDocCharsToAnalyze(maxCharsToAnalyze);
                    }
                    try {
                        TextFragment[] bestTextFragments = highlighter.getBestTextFragments(tstream, docTexts[j], mergeContiguousFragments, numFragments);
                        for (int k = 0; k < bestTextFragments.length; ++k) {
                            if (bestTextFragments[k] == null || !(bestTextFragments[k].getScore() > 0.0f)) continue;
                            frags.add(bestTextFragments[k]);
                        }
                        continue;
                    }
                    catch (InvalidTokenOffsetsException e) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
                    }
                }
                Collections.sort(frags, new Comparator<TextFragment>(){

                    @Override
                    public int compare(TextFragment arg0, TextFragment arg1) {
                        return Math.round(arg1.getScore() - arg0.getScore());
                    }
                });
                if (frags.size() > 0) {
                    ArrayList<String> fragTexts = new ArrayList<String>();
                    for (TextFragment fragment : frags) {
                        if (fragment != null && fragment.getScore() > 0.0f) {
                            fragTexts.add(fragment.toString());
                        }
                        if (fragTexts.size() < numFragments) continue;
                        break;
                    }
                    if ((summaries = fragTexts.toArray(new String[0])).length > 0) {
                        docSummaries.add(fieldName, summaries);
                    }
                }
                if (summaries != null && summaries.length != 0 || (alternateField = req.getParams().getFieldParam(fieldName, "hl.alternateField")) == null || alternateField.length() <= 0 || (altTexts = doc.getValues(alternateField)) == null || altTexts.length <= 0) continue;
                int alternateFieldLen = req.getParams().getFieldInt(fieldName, "hl.maxAlternateFieldLength", 0);
                if (alternateFieldLen <= 0) {
                    docSummaries.add(fieldName, altTexts);
                    continue;
                }
                ArrayList<String> altList = new ArrayList<String>();
                int len = 0;
                for (String altText : altTexts) {
                    altList.add(len + altText.length() > alternateFieldLen ? new String(altText.substring(0, alternateFieldLen - len)) : altText);
                    if ((len += altText.length()) >= alternateFieldLen) break;
                }
                docSummaries.add(fieldName, altList);
            }
            String printId = schema.printableUniqueKey(doc);
            fragments.add(printId == null ? null : printId, docSummaries);
        }
        return fragments;
    }

    private TokenStream createAnalyzerTStream(IndexSchema schema, String fieldName, String docText) throws IOException {
        TokenStream ts = schema.getAnalyzer().reusableTokenStream(fieldName, new StringReader(docText));
        ts.reset();
        TokenOrderingFilter tstream = new TokenOrderingFilter(ts, 10);
        return tstream;
    }
}

