/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.LucenePackage;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemInfoHandler
extends RequestHandlerBase {
    private static Logger log = LoggerFactory.getLogger(SystemInfoHandler.class);
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.add("core", SystemInfoHandler.getCoreInfo(req.getCore()));
        rsp.add("lucene", SystemInfoHandler.getLuceneInfo());
        rsp.add("jvm", SystemInfoHandler.getJvmInfo());
        rsp.add("system", SystemInfoHandler.getSystemInfo());
        rsp.setHttpCaching(false);
    }

    private static SimpleOrderedMap<Object> getCoreInfo(SolrCore core) throws Exception {
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        IndexSchema schema = core.getSchema();
        info.add("schema", schema != null ? schema.getSchemaName() : "no schema!");
        InetAddress addr = InetAddress.getLocalHost();
        info.add("host", addr.getCanonicalHostName());
        info.add("now", new Date());
        info.add("start", new Date(core.getStartTime()));
        SimpleOrderedMap<String> dirs = new SimpleOrderedMap<String>();
        dirs.add("instance", new File(core.getResourceLoader().getInstanceDir()).getAbsolutePath());
        dirs.add("data", new File(core.getDataDir()).getAbsolutePath());
        dirs.add("index", new File(core.getIndexDir()).getAbsolutePath());
        info.add("directory", dirs);
        return info;
    }

    public static SimpleOrderedMap<Object> getSystemInfo() throws Exception {
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        info.add("name", os.getName());
        info.add("version", os.getVersion());
        info.add("arch", os.getArch());
        SystemInfoHandler.addGetterIfAvaliable(os, "systemLoadAverage", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "openFileDescriptorCount", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "maxFileDescriptorCount", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "committedVirtualMemorySize", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "totalPhysicalMemorySize", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "totalSwapSpaceSize", info);
        SystemInfoHandler.addGetterIfAvaliable(os, "processCpuTime", info);
        try {
            if (!os.getName().toLowerCase().startsWith("windows")) {
                info.add("uname", SystemInfoHandler.execute("uname -a"));
                info.add("ulimit", SystemInfoHandler.execute("ulimit -n"));
                info.add("uptime", SystemInfoHandler.execute("uptime"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return info;
    }

    static void addGetterIfAvaliable(Object obj, String getter, NamedList<Object> info) {
        try {
            String n = Character.toUpperCase(getter.charAt(0)) + getter.substring(1);
            Method m = obj.getClass().getMethod("get" + n, new Class[0]);
            Object v = m.invoke(obj, (Object[])null);
            if (v != null) {
                info.add(getter, v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String execute(String cmd) {
        String string;
        DataInputStream in = null;
        Reader reader = null;
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            in = new DataInputStream(process.getInputStream());
            string = IOUtils.toString((InputStream)in);
            Object var6_7 = null;
        }
        catch (Exception ex) {
            String string2;
            try {
                string2 = "(error executing: " + cmd + ")";
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly((InputStream)in);
            return string2;
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    public static SimpleOrderedMap<Object> getJvmInfo() {
        SimpleOrderedMap<Object> jvm = new SimpleOrderedMap<Object>();
        jvm.add("version", System.getProperty("java.vm.version"));
        jvm.add("name", System.getProperty("java.vm.name"));
        Runtime runtime = Runtime.getRuntime();
        jvm.add("processors", runtime.availableProcessors());
        long used = runtime.totalMemory() - runtime.freeMemory();
        DecimalFormat df = new DecimalFormat("#.#");
        double percentUsed = (double)used / (double)runtime.maxMemory() * 100.0;
        SimpleOrderedMap<String> mem = new SimpleOrderedMap<String>();
        mem.add("free", SystemInfoHandler.humanReadableUnits(runtime.freeMemory(), df));
        mem.add("total", SystemInfoHandler.humanReadableUnits(runtime.totalMemory(), df));
        mem.add("max", SystemInfoHandler.humanReadableUnits(runtime.maxMemory(), df));
        mem.add("used", SystemInfoHandler.humanReadableUnits(used, df) + " (%" + df.format(percentUsed) + ")");
        jvm.add("memory", mem);
        SimpleOrderedMap<Object> jmx = new SimpleOrderedMap<Object>();
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            jmx.add("bootclasspath", mx.getBootClassPath());
            jmx.add("classpath", mx.getClassPath());
            jmx.add("commandLineArgs", mx.getInputArguments());
            jmx.add("startTime", new Date(mx.getStartTime()));
            jmx.add("upTimeMS", mx.getUptime());
        }
        catch (Exception e) {
            log.warn("Error getting JMX properties", (Throwable)e);
        }
        jvm.add("jmx", jmx);
        return jvm;
    }

    private static SimpleOrderedMap<Object> getLuceneInfo() throws Exception {
        SimpleOrderedMap<Object> info = new SimpleOrderedMap<Object>();
        String solrImplVersion = "";
        String solrSpecVersion = "";
        String luceneImplVersion = "";
        String luceneSpecVersion = "";
        Package p = SolrCore.class.getPackage();
        StringWriter tmp = new StringWriter();
        solrImplVersion = p.getImplementationVersion();
        if (null != solrImplVersion) {
            XML.escapeCharData(solrImplVersion, tmp);
            solrImplVersion = tmp.toString();
        }
        tmp = new StringWriter();
        solrSpecVersion = p.getSpecificationVersion();
        if (null != solrSpecVersion) {
            XML.escapeCharData(solrSpecVersion, tmp);
            solrSpecVersion = tmp.toString();
        }
        p = LucenePackage.class.getPackage();
        tmp = new StringWriter();
        luceneImplVersion = p.getImplementationVersion();
        if (null != luceneImplVersion) {
            XML.escapeCharData(luceneImplVersion, tmp);
            luceneImplVersion = tmp.toString();
        }
        tmp = new StringWriter();
        luceneSpecVersion = p.getSpecificationVersion();
        if (null != luceneSpecVersion) {
            XML.escapeCharData(luceneSpecVersion, tmp);
            luceneSpecVersion = tmp.toString();
        }
        info.add("solr-spec-version", solrSpecVersion);
        info.add("solr-impl-version", solrImplVersion);
        info.add("lucene-spec-version", luceneSpecVersion);
        info.add("lucene-impl-version", luceneImplVersion);
        return info;
    }

    @Override
    public String getDescription() {
        return "Get System Info";
    }

    @Override
    public String getVersion() {
        return "$Revision: 790580 $";
    }

    @Override
    public String getSourceId() {
        return "$Id: SystemInfoHandler.java 790580 2009-07-02 13:20:22Z markrmiller $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/handler/admin/SystemInfoHandler.java $";
    }

    private static String humanReadableUnits(long bytes, DecimalFormat df) {
        String newSizeAndUnits = bytes / 0x40000000L > 0L ? String.valueOf(df.format((float)bytes / 1.0737418E9f)) + " GB" : (bytes / 0x100000L > 0L ? String.valueOf(df.format((float)bytes / 1048576.0f)) + " MB" : (bytes / 1024L > 0L ? String.valueOf(df.format((float)bytes / 1024.0f)) + " KB" : String.valueOf(bytes) + " bytes"));
        return newSizeAndUnits;
    }
}

