/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.processor;

import java.io.IOException;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.Base64;
import org.w3c.dom.Element;

public class UsernameTokenProcessor
implements Processor {
    private static Log log = LogFactory.getLog((String)UsernameTokenProcessor.class.getName());
    private String utId;
    private UsernameToken ut;
    private boolean handleCustomPasswordTypes;
    private boolean allowNamespaceQualifiedPasswordTypes;
    private boolean passwordsAreEncoded;

    public void handleToken(Element elem, Crypto crypto, Crypto decCrypto, CallbackHandler cb, WSDocInfo wsDocInfo, Vector returnResults, WSSConfig wsc) throws WSSecurityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Found UsernameToken list element");
        }
        this.handleCustomPasswordTypes = wsc.getHandleCustomPasswordTypes();
        this.allowNamespaceQualifiedPasswordTypes = wsc.getAllowNamespaceQualifiedPasswordTypes();
        this.passwordsAreEncoded = wsc.getPasswordsAreEncoded();
        WSUsernameTokenPrincipal lastPrincipalFound = this.handleUsernameToken(elem, cb);
        returnResults.add(0, new WSSecurityEngineResult(1, lastPrincipalFound, null, null, null));
        this.utId = this.ut.getID();
    }

    public WSUsernameTokenPrincipal handleUsernameToken(Element token, CallbackHandler cb) throws WSSecurityException {
        WSPasswordCallback pwCb;
        if (cb == null) {
            throw new WSSecurityException(0, "noCallback");
        }
        this.ut = new UsernameToken(token, this.allowNamespaceQualifiedPasswordTypes);
        this.ut.setPasswordsAreEncoded(this.passwordsAreEncoded);
        String user = this.ut.getName();
        String password = this.ut.getPassword();
        String nonce = this.ut.getNonce();
        String createdTime = this.ut.getCreated();
        String pwType = this.ut.getPasswordType();
        if (log.isDebugEnabled()) {
            log.debug((Object)("UsernameToken user " + user));
            log.debug((Object)("UsernameToken password type " + pwType));
        }
        Callback[] callbacks = new Callback[1];
        String origPassword = null;
        if (this.ut.isHashed()) {
            pwCb = new WSPasswordCallback(user, null, pwType, 2);
            callbacks[0] = pwCb;
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new WSSecurityException(5, null, null, e);
            }
            catch (UnsupportedCallbackException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new WSSecurityException(5, null, null, e);
            }
            origPassword = pwCb.getPassword();
            if (origPassword == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Callback supplied no password for: " + user));
                }
                throw new WSSecurityException(5);
            }
            String passDigest = this.passwordsAreEncoded ? UsernameToken.doPasswordDigest(nonce, createdTime, Base64.decode(origPassword)) : UsernameToken.doPasswordDigest(nonce, createdTime, origPassword);
            if (!passDigest.equals(password)) {
                throw new WSSecurityException(5);
            }
            this.ut.setRawPassword(origPassword);
        } else {
            if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText".equals(pwType) && pwType != null && !this.handleCustomPasswordTypes) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Authentication failed as handleCustomUsernameTokenTypes is false");
                }
                throw new WSSecurityException(5);
            }
            pwCb = new WSPasswordCallback(user, password, pwType, 5);
            callbacks[0] = pwCb;
            try {
                cb.handle(callbacks);
            }
            catch (IOException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new WSSecurityException(5, null, null, e);
            }
            catch (UnsupportedCallbackException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
                throw new WSSecurityException(5, null, null, e);
            }
            origPassword = pwCb.getPassword();
            this.ut.setRawPassword(origPassword);
        }
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(user, this.ut.isHashed());
        principal.setNonce(nonce);
        principal.setPassword(password);
        principal.setCreatedTime(createdTime);
        principal.setPasswordType(pwType);
        return principal;
    }

    public String getId() {
        return this.utId;
    }

    public UsernameToken getUt() {
        return this.ut;
    }

    public byte[] getDerivedKey(CallbackHandler cb) throws WSSecurityException {
        String password = this.ut.getRawPassword();
        if (password == null) {
            password = "";
        }
        byte[] saltValue = this.ut.getSalt();
        int iteration = this.ut.getIteration();
        if (this.passwordsAreEncoded) {
            return UsernameToken.generateDerivedKey(Base64.decode(password), saltValue, iteration);
        }
        return UsernameToken.generateDerivedKey(password, saltValue, iteration);
    }
}

