/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.search.services;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.registry.common.ResourceData;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.dataaccess.QueryProcessor;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.MediaTypesUtils;
import org.wso2.carbon.registry.search.services.MetadataSearchService;

public class XPathQueryProcessor
implements QueryProcessor {
    public static final String XPATH_QUERY_MEDIA_TYPE = "application/vnd.wso2.xpath.query";
    private static final String NO_CONTAINMENT_SUFFIX = "(.)";
    private MetadataSearchService service;

    public XPathQueryProcessor(MetadataSearchService service) {
        this.service = service;
    }

    public Collection executeQuery(Registry registry, Resource resource, Map map) throws RegistryException {
        if (map != null && map.containsKey("query") && XPATH_QUERY_MEDIA_TYPE.equals(map.get("mediaType"))) {
            Set<String> paths;
            String[] parts;
            String query = ((String)map.get("query")).substring(1);
            int partsRead = 0;
            if (query.indexOf(47) == 0) {
                parts = (query = query.substring(1)).split("/");
                paths = this.executeQueryForPart(parts[0]);
                partsRead = paths.size() == 0 ? Integer.MAX_VALUE : 1;
            } else {
                paths = Collections.singleton("/");
                parts = query.split("/");
            }
            if (parts.length > partsRead) {
                if (partsRead == 1) {
                    parts = query.substring(query.indexOf("/") + 1).split("/");
                }
                for (int i = 0; i < parts.length; ++i) {
                    String relation;
                    Set<String> matches;
                    String part = parts[i];
                    if (part.contains("[")) {
                        matches = this.executeQueryForPart("%" + part.substring(part.indexOf("[")));
                        relation = part.substring(0, part.indexOf("["));
                    } else {
                        relation = part;
                        matches = null;
                    }
                    HashSet<String> associations = new HashSet<String>();
                    HashSet<String> temp = new HashSet<String>();
                    for (String path : paths) {
                        Association[] list;
                        if (relation.endsWith(NO_CONTAINMENT_SUFFIX)) {
                            list = registry.getAssociations(path, relation.substring(0, relation.length() - NO_CONTAINMENT_SUFFIX.length()));
                        } else {
                            list = registry.getAssociations(path, relation);
                            String resourcePath = path + "/" + relation;
                            if (registry.resourceExists(resourcePath)) {
                                if (i == parts.length - 1) {
                                    Resource containedResource = registry.get(resourcePath);
                                    if (containedResource instanceof Collection) {
                                        String[] children = ((Collection)containedResource).getChildren();
                                        if (children != null) {
                                            temp.addAll(Arrays.asList(children));
                                        }
                                    } else {
                                        temp.add(resourcePath);
                                    }
                                } else {
                                    temp.add(resourcePath);
                                }
                            }
                        }
                        for (Association association : list) {
                            if (!association.getSourcePath().equals(path) || !association.getDestinationPath().startsWith("/")) continue;
                            associations.add(association.getDestinationPath());
                        }
                    }
                    temp.addAll(associations);
                    if (matches != null) {
                        temp.retainAll(matches);
                    }
                    paths = temp;
                }
            }
            return new CollectionImpl(paths.toArray(new String[paths.size()]));
        }
        if (resource != null && XPATH_QUERY_MEDIA_TYPE.equals(resource.getMediaType())) {
            throw new UnsupportedOperationException("Query-resource model is not supported");
        }
        throw new RegistryException("Unable to process XPath query. Pre-conditions have not been set due to some unknown reason.");
    }

    protected Set<String> executeQueryForPart(String part) throws RegistryException {
        HashSet<String> paths = new HashSet<String>();
        String[] subParts = part.split("\\[");
        String mediaType = MediaTypesUtils.getMimeTypeFromHumanReadableMediaType((String)subParts[0]);
        Map<String, String> base = mediaType == null || mediaType.equals(subParts[0]) ? Collections.singletonMap("resourcePath", subParts[0]) : Collections.singletonMap("mediaType", mediaType);
        if (subParts.length > 1) {
            String[] predicateParts;
            String predicates = subParts[1].substring(0, subParts[1].length() - 1).trim();
            for (String predicatePart : predicateParts = predicates.split(" or ")) {
                ResourceData[] results;
                Map<String, String> input = this.parsePredicatePart(base, predicatePart);
                for (ResourceData result : results = (ResourceData[])this.service.search(CurrentSession.getTenantId(), input)) {
                    paths.add(result.getResourcePath());
                }
            }
        } else {
            ResourceData[] results;
            for (ResourceData result : results = (ResourceData[])this.service.search(CurrentSession.getTenantId(), base)) {
                paths.add(result.getResourcePath());
            }
        }
        return paths;
    }

    protected Map<String, String> parsePredicatePart(Map<String, String> base, String predicatePart) {
        String[] expressions;
        HashMap<String, String> input = new HashMap<String, String>(base);
        for (String expression : expressions = predicatePart.trim().split(" and ")) {
            String[] temp;
            String expr = expression.trim();
            if (expr.contains("!=")) {
                temp = this.fixParams(expr.split("!="));
                this.addNegatedItemsToInput(input, temp);
                continue;
            }
            if (expr.contains(">=")) {
                temp = this.fixParams(expr.split(">="));
                input.put("propertyName", temp[0]);
                input.put("rightPropertyValue", temp[1]);
                input.put("rightOp", "ge");
                continue;
            }
            if (expr.contains(">")) {
                temp = this.fixParams(expr.split(">"));
                input.put("propertyName", temp[0]);
                input.put("rightPropertyValue", temp[1]);
                input.put("rightOp", "gt");
                continue;
            }
            if (expr.contains("<=")) {
                temp = this.fixParams(expr.split("<="));
                input.put("propertyName", temp[0]);
                input.put("leftPropertyValue", temp[1]);
                input.put("leftOp", "le");
                continue;
            }
            if (!expr.contains("=")) continue;
            temp = this.fixParams(expr.split("="));
            input.put(temp[0], temp[1]);
        }
        return input;
    }

    protected void addNegatedItemsToInput(Map<String, String> input, String[] temp) {
        if (temp[0].equals("author")) {
            input.put("authorNameNegate", Boolean.toString(true));
        } else if (temp[0].equals("updater")) {
            input.put("updaterNameNegate", Boolean.toString(true));
        } else if (temp[0].equals("mediaType")) {
            input.put("mediaTypeNegate", Boolean.toString(true));
        } else if (temp[0].startsWith("created")) {
            input.put("createdRangeNegate", Boolean.toString(true));
        } else if (temp[0].startsWith("updated")) {
            input.put("updatedRangeNegate", Boolean.toString(true));
        } else {
            return;
        }
        input.put(temp[0], temp[1]);
    }

    protected String[] fixParams(String[] temp) {
        String[] strings = Arrays.copyOf(temp, temp.length);
        strings[0] = strings[0].trim();
        if (strings[0].startsWith("@")) {
            strings[0] = strings[0].substring(1);
        }
        strings[1] = strings[1].trim();
        if (strings[1].indexOf(39) == 0) {
            strings[1] = strings[1].substring(1, strings[1].length() - 1);
        }
        return strings;
    }
}

