/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.rpc.receivers.ejb;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.threadpool.DefaultThreadFactory;

public class EJB3Util {
    public static final String EJB_JNDI_NAME = "beanJndiName";
    public static final String EJB_REMOTE_INTERFACE_NAME = "remoteInterfaceName";
    public static final String EJB_LOCAL_INTERFACE_NAME = "localInterfaceName";
    public static final String EJB_INITIAL_CONTEXT_FACTORY = "jndiContextClass";
    public static final String EJB_PROVIDER_URL = "providerUrl";
    public static final String EJB_JNDI_USERNAME = "jndiUser";
    public static final String EJB_JNDI_PASSWORD = "jndiPassword";
    private static ExecutorService workerPool = null;

    protected static Object makeNewServiceObject(MessageContext msgContext) throws AxisFault {
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch stopLatch = new CountDownLatch(1);
        EJBClientWorker worker = new EJBClientWorker(msgContext, startLatch, stopLatch);
        workerPool.execute(worker);
        startLatch.countDown();
        try {
            stopLatch.await();
        }
        catch (InterruptedException e) {
            throw AxisFault.makeFault(e);
        }
        if (worker.getException() != null) {
            throw AxisFault.makeFault(worker.getException());
        }
        return worker.getReturnedValue();
    }

    static {
        workerPool = new ThreadPoolExecutor(1, 50, 150L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(new ThreadGroup("EJB provider thread group"), "EJBProvider"));
    }

    private static class EJBClientWorker
    implements Runnable {
        private MessageContext msgContext = null;
        private CountDownLatch startLatch = null;
        private CountDownLatch stopLatch = null;
        private static InitialContext cached_context = null;
        private Exception exception = null;
        private Object returnedValue = null;

        public EJBClientWorker(MessageContext msgContext, CountDownLatch startLatch, CountDownLatch stopLatch) {
            this.msgContext = msgContext;
            this.startLatch = startLatch;
            this.stopLatch = stopLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Parameter interfaceName;
                this.startLatch.await();
                final AxisService service = this.msgContext.getAxisService();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(service.getClassLoader());
                        return null;
                    }
                });
                Parameter remoteName = service.getParameter(EJB3Util.EJB_REMOTE_INTERFACE_NAME);
                Parameter localName = service.getParameter(EJB3Util.EJB_LOCAL_INTERFACE_NAME);
                Parameter jndiName = service.getParameter(EJB3Util.EJB_JNDI_NAME);
                Parameter parameter = interfaceName = remoteName != null ? remoteName : localName;
                if (jndiName == null || jndiName.getValue() == null) {
                    throw new AxisFault("jndi name is not specified");
                }
                if (interfaceName == null || interfaceName.getValue() == null) {
                    throw new AxisFault("ejb remote/local home class name is not specified");
                }
                this.returnedValue = remoteName != null ? this.createRemoteEJB(this.msgContext, ((String)jndiName.getValue()).trim(), ((String)interfaceName.getValue()).trim()) : this.createLocalEJB(this.msgContext, ((String)jndiName.getValue()).trim(), ((String)interfaceName.getValue()).trim());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.exception = e;
            }
            finally {
                this.stopLatch.countDown();
            }
        }

        private Object createRemoteEJB(MessageContext msgContext, String beanJndiName, String interfaceName) throws Exception {
            Class<?> cls = this.getContextClassLoader().loadClass(interfaceName);
            Object ejbRemote = this.getEJBInterface(msgContext.getAxisService(), beanJndiName);
            return cls.cast(ejbRemote);
        }

        private Object createLocalEJB(MessageContext msgContext, String beanJndiName, String interfaceName) throws Exception {
            Class<?> cls = this.getContextClassLoader().loadClass(interfaceName);
            Object ejbLocal = this.getEJBInterface(msgContext.getAxisService(), beanJndiName);
            return cls.cast(ejbLocal);
        }

        private Object getEJBInterface(AxisService service, String beanJndiName) throws AxisFault {
            Object ejbRemote = null;
            try {
                InitialContext context;
                Parameter contextUrl;
                Parameter factoryClass;
                Parameter password;
                Properties properties = null;
                Parameter username = service.getParameter(EJB3Util.EJB_JNDI_USERNAME);
                if (username != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.security.principal", ((String)username.getValue()).trim());
                }
                if ((password = service.getParameter(EJB3Util.EJB_JNDI_PASSWORD)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.security.credentials", ((String)password.getValue()).trim());
                }
                if ((factoryClass = service.getParameter(EJB3Util.EJB_INITIAL_CONTEXT_FACTORY)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.factory.initial", ((String)factoryClass.getValue()).trim());
                }
                if ((contextUrl = service.getParameter(EJB3Util.EJB_PROVIDER_URL)) != null) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setProperty("java.naming.provider.url", ((String)contextUrl.getValue()).trim());
                }
                if ((context = this.getContext(properties)) == null) {
                    throw new AxisFault("cannot create initial context");
                }
                try {
                    ejbRemote = this.lookUpEJBInterface(context, beanJndiName);
                }
                catch (Exception e) {
                    ejbRemote = this.lookUpEJBInterface(context, beanJndiName);
                }
                if (ejbRemote == null) {
                    throw new AxisFault("cannot find jndi home");
                }
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            return ejbRemote;
        }

        private InitialContext getCachedContext() throws NamingException {
            if (cached_context == null) {
                cached_context = new InitialContext();
            }
            return cached_context;
        }

        private InitialContext getContext(Properties properties) throws AxisFault, NamingException {
            return properties == null ? this.getCachedContext() : new InitialContext(properties);
        }

        private Object lookUpEJBInterface(InitialContext context, String beanJndiName) throws AxisFault, NamingException {
            return context.lookup(beanJndiName);
        }

        private ClassLoader getContextClassLoader() {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }

        public Exception getException() {
            return this.exception;
        }

        public Object getReturnedValue() {
            return this.returnedValue;
        }
    }
}

