/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.databinding;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.net.URLDecoder;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlType;
import javax.xml.ws.Holder;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.message.databinding.ClassFinder;
import org.apache.axis2.jaxws.message.databinding.JAXBContextFromClasses;
import org.apache.axis2.jaxws.message.databinding.JAXBUtilsMonitor;
import org.apache.axis2.jaxws.message.factory.ClassFinderFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.ClassUtils;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBUtils {
    private static final Log log = LogFactory.getLog(JAXBUtils.class);
    private static Map<String, SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>>> jaxbMap = new ConcurrentHashMap<String, SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>>>();
    private static Pool<JAXBContext, Marshaller> mpool = new Pool();
    private static Pool<JAXBContext, Unmarshaller> upool = new Pool();
    private static Pool<JAXBContext, JAXBIntrospector> ipool = new Pool();
    private static boolean ENABLE_MARSHALL_POOLING = true;
    private static boolean ENABLE_UNMARSHALL_POOLING = true;
    private static boolean ENABLE_INTROSPECTION_POOLING = false;
    private static int MAX_LOAD_FACTOR = 32;
    private static final Map<String, List<Class>> specialMap = new HashMap<String, List<Class>>();
    public static final String DEFAULT_NAMESPACE_REMAP;
    private static String[] commonArrayClasses;

    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages) throws JAXBException {
        return JAXBUtils.getJAXBContext(contextPackages, (Holder<CONSTRUCTION_TYPE>)new Holder(), contextPackages.toString(), null, null);
    }

    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages, ClassLoader cacheKey) throws JAXBException {
        return JAXBUtils.getJAXBContext(contextPackages, (Holder<CONSTRUCTION_TYPE>)new Holder(), contextPackages.toString(), cacheKey, null);
    }

    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages, Holder<CONSTRUCTION_TYPE> constructionType, String key) throws JAXBException {
        return JAXBUtils.getJAXBContext(contextPackages, constructionType, key, null, null);
    }

    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages, Holder<CONSTRUCTION_TYPE> constructionType, String key, ClassLoader cacheKey, Map<String, ?> properties) throws JAXBException {
        return JAXBUtils.getJAXBContext(contextPackages, constructionType, false, key, cacheKey, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext getJAXBContext(TreeSet<String> contextPackages, Holder<CONSTRUCTION_TYPE> constructionType, boolean forceArrays, String key, ClassLoader cacheKey, Map<String, ?> properties) throws JAXBException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Following packages are in this batch of getJAXBContext() :");
            for (String pkg : contextPackages) {
                log.debug((Object)pkg);
            }
        }
        if (JAXBUtilsMonitor.isMonitoring()) {
            JAXBUtilsMonitor.addPackageKey(contextPackages.toString());
        }
        ConcurrentHashMap<ClassLoader, JAXBContextValue> innerMap = null;
        SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>> softRef = jaxbMap.get(key);
        if (softRef != null) {
            innerMap = softRef.get();
        }
        if (innerMap == null) {
            Map<String, SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>>> map = jaxbMap;
            synchronized (map) {
                softRef = jaxbMap.get(key);
                if (softRef != null) {
                    innerMap = softRef.get();
                }
                if (innerMap == null) {
                    innerMap = new ConcurrentHashMap();
                    softRef = new SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>>(innerMap);
                    jaxbMap.put(key, softRef);
                }
            }
        }
        ClassLoader cl = JAXBUtils.getContextClassLoader();
        JAXBContextValue contextValue = null;
        if (cacheKey != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using supplied classloader to retrieve JAXBContext: " + cacheKey));
            }
            contextValue = innerMap.get(cacheKey);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using classloader from Thread to retrieve JAXBContext: " + cl));
            }
            contextValue = innerMap.get(cl);
        }
        if (forceArrays && contextValue != null && contextValue.constructionType != CONSTRUCTION_TYPE.BY_CLASS_ARRAY_PLUS_ARRAYS) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a JAXBContextValue with constructionType=" + (Object)((Object)contextValue.constructionType) + "  but the caller requested a JAXBContext " + " that includes arrays.  A new JAXBContext will be built"));
            }
            contextValue = null;
        }
        if (contextPackages == null) {
            contextPackages = new TreeSet();
        }
        if (contextValue == null) {
            ConcurrentHashMap<ClassLoader, JAXBContextValue> concurrentHashMap = innerMap;
            synchronized (concurrentHashMap) {
                ClassLoader clKey = cacheKey != null ? cacheKey : cl;
                contextValue = innerMap.get(clKey);
                JAXBUtils.adjustPoolSize(innerMap);
                if (forceArrays && contextValue != null && contextValue.constructionType != CONSTRUCTION_TYPE.BY_CLASS_ARRAY_PLUS_ARRAYS) {
                    contextValue = null;
                }
                if (contextValue == null) {
                    TreeSet<String> validContextPackages = new TreeSet<String>((SortedSet<String>)contextPackages);
                    List<String> classRefs = JAXBUtils.pruneDirectives(validContextPackages);
                    int numPackages = validContextPackages.size();
                    contextValue = JAXBUtils.createJAXBContextValue(validContextPackages, clKey, forceArrays, properties, classRefs);
                    Map<String, SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>>> map = jaxbMap;
                    synchronized (map) {
                        ConcurrentHashMap<ClassLoader, JAXBContextValue> map1 = null;
                        SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>> softRef1 = jaxbMap.get(key);
                        if (softRef1 != null) {
                            map1 = softRef1.get();
                        }
                        if (map1 == null) {
                            map1 = new ConcurrentHashMap();
                            softRef1 = new SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>>(map1);
                            jaxbMap.put(key, softRef1);
                        }
                        map1.put(clKey, contextValue);
                        String validPackagesKey = validContextPackages.toString();
                        ConcurrentHashMap<ClassLoader, JAXBContextValue> map2 = null;
                        SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>> softRef2 = jaxbMap.get(validPackagesKey);
                        if (softRef2 != null) {
                            map2 = softRef2.get();
                        }
                        if (map2 == null) {
                            map2 = new ConcurrentHashMap();
                            softRef2 = new SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>>(map2);
                            jaxbMap.put(validPackagesKey, softRef2);
                        }
                        map2.put(clKey, contextValue);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("JAXBContext [created] for " + key));
                            log.debug((Object)("JAXBContext also stored by the list of valid packages:" + validPackagesKey));
                        }
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBContext [from pool] for " + key));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JAXBContext constructionType= " + (Object)((Object)contextValue.constructionType)));
            log.debug((Object)("JAXBContextValue = " + JavaUtils.getObjectIdentity(contextValue)));
            log.debug((Object)("JAXBContext = " + JavaUtils.getObjectIdentity(contextValue.jaxbContext)));
        }
        constructionType.value = contextValue.constructionType;
        return contextValue.jaxbContext;
    }

    protected static List<String> pruneDirectives(TreeSet<String> contextPackages) {
        String entry;
        ArrayList<String> removePkgsList = new ArrayList<String>();
        ArrayList<String> strongPkgsList = new ArrayList<String>();
        ArrayList<String> classRefs = new ArrayList<String>();
        Iterator<String> it = contextPackages.iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (entry.contains(">")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Override found:" + entry));
                }
                it.remove();
                String removePkg = entry.substring(entry.indexOf(">") + 1);
                removePkg = removePkg.trim();
                removePkgsList.add(removePkg);
            }
            if (entry.startsWith("@")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Strong (class) reference found:" + entry));
                }
                it.remove();
                String strongPkg = entry.substring(1);
                strongPkg = strongPkg.trim();
                strongPkgsList.add(strongPkg);
            }
            if (!entry.startsWith("[")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Class Reference found:" + entry));
            }
            it.remove();
            String cls = entry.substring(1, entry.length() - 1);
            classRefs.add(cls);
        }
        it = contextPackages.iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!removePkgsList.contains(entry)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing override package:" + entry));
            }
            it.remove();
        }
        contextPackages.addAll(strongPkgsList);
        return classRefs;
    }

    private static JAXBContextValue createJAXBContextValue(TreeSet<String> contextPackages, ClassLoader cl, boolean forceArrays, Map<String, ?> properties, List<String> classRefs) throws JAXBException {
        JAXBContextValue contextValue = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Following packages are in this batch of getJAXBContext() :");
            for (String pkg : contextPackages) {
                log.debug((Object)pkg);
            }
            log.debug((Object)("This classloader will be used to construct the JAXBContext" + cl));
        }
        Iterator<String> it = contextPackages.iterator();
        while (it.hasNext()) {
            String p = it.next();
            if (p.startsWith("javax.xml.ws.wsaddressing") || !p.startsWith("java.") && !p.startsWith("javax.")) continue;
            it.remove();
        }
        it = contextPackages.iterator();
        boolean contextConstruction = !forceArrays;
        boolean isJAXBFound = false;
        while (it.hasNext()) {
            String p = it.next();
            if (JAXBUtils.checkPackage(p, cl)) {
                isJAXBFound = true;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Package " + p + " contains an ObjectFactory or package-info class."));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Package " + p + " does not contain an ObjectFactory or package-info class.  Searching for JAXB classes"));
            }
            List<Class> classes = null;
            classes = JAXBUtils.getAllClassesFromPackage(p, cl);
            if (classes == null || classes.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Package " + p + " does not have any JAXB classes.  It is removed from the JAXB context path."));
                }
                it.remove();
                continue;
            }
            contextConstruction = false;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Package " + p + " does not contain ObjectFactory, but it does contain other JAXB classes."));
        }
        if (!isJAXBFound && log.isDebugEnabled()) {
            log.debug((Object)"ObjectFactory & package-info are not found in package hierachy");
        }
        if (contextConstruction) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Recheck Cache Start: Some packages have been removed from the list.  Rechecking cache.");
            }
            String key = contextPackages.toString();
            ConcurrentHashMap<ClassLoader, JAXBContextValue> innerMap = null;
            SoftReference<ConcurrentHashMap<ClassLoader, JAXBContextValue>> softRef = jaxbMap.get(key);
            if (softRef != null) {
                innerMap = softRef.get();
            }
            if (innerMap != null) {
                contextValue = innerMap.get(cl);
                if (forceArrays && contextValue != null && contextValue.constructionType != CONSTRUCTION_TYPE.BY_CLASS_ARRAY_PLUS_ARRAYS) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found a JAXBContextValue with constructionType=" + (Object)((Object)contextValue.constructionType) + "  but the caller requested a JAXBContext " + " that includes arrays.  A new JAXBContext will be built"));
                    }
                    contextValue = null;
                }
                if (contextValue != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully found JAXBContext with updated context list:" + contextValue.jaxbContext.toString()));
                    }
                    return contextValue;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Recheck Cache End: Did not find a JAXBContext.  Will build a new JAXBContext.");
            }
        }
        if (contextConstruction) {
            JAXBContext context;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Try building a JAXBContext using the packages only.");
            }
            if ((context = JAXBUtils.createJAXBContextUsingContextPath(contextPackages, cl, classRefs)) != null) {
                contextValue = new JAXBContextValue(context, CONSTRUCTION_TYPE.BY_CONTEXT_PATH);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Building a JAXBContext with packages only success=" + (contextValue != null)));
            }
        }
        if (contextValue == null) {
            JAXBContext context;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Try building a JAXBContext using a list of classes.");
                log.debug((Object)"Start finding classes");
            }
            it = contextPackages.iterator();
            ArrayList<Class> fullList = new ArrayList<Class>();
            while (it.hasNext()) {
                String pkg = it.next();
                fullList.addAll(JAXBUtils.getAllClassesFromPackage(pkg, cl));
            }
            JAXBUtils.addCommonArrayClasses(fullList);
            Class[] classArray = fullList.toArray(new Class[0]);
            if (log.isDebugEnabled()) {
                log.debug((Object)"End finding classes");
            }
            if ((context = JAXBUtils.JAXBContext_newInstance(classArray, cl, properties, classRefs)) != null) {
                contextValue = forceArrays ? new JAXBContextValue(context, CONSTRUCTION_TYPE.BY_CLASS_ARRAY_PLUS_ARRAYS) : new JAXBContextValue(context, CONSTRUCTION_TYPE.BY_CLASS_ARRAY);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully created JAXBContext " + contextValue.jaxbContext.toString()));
        }
        return contextValue;
    }

    public static Unmarshaller getJAXBUnmarshaller(JAXBContext context) throws JAXBException {
        if (!ENABLE_UNMARSHALL_POOLING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unmarshaller created [no pooling]");
            }
            return JAXBUtils.internalCreateUnmarshaller(context);
        }
        Unmarshaller unm = upool.get(context);
        if (unm == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unmarshaller created [not in pool]");
            }
            unm = JAXBUtils.internalCreateUnmarshaller(context);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Unmarshaller obtained [from  pool]");
        }
        return unm;
    }

    private static Unmarshaller internalCreateUnmarshaller(final JAXBContext context) throws JAXBException {
        Unmarshaller unm;
        try {
            unm = (Unmarshaller)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JAXBException {
                    return context.createUnmarshaller();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (JAXBException)e.getCause();
        }
        return unm;
    }

    private static Marshaller internalCreateMarshaller(final JAXBContext context) throws JAXBException {
        Marshaller marshaller;
        try {
            marshaller = (Marshaller)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JAXBException {
                    return context.createMarshaller();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (JAXBException)e.getCause();
        }
        return marshaller;
    }

    public static void releaseJAXBUnmarshaller(JAXBContext context, Unmarshaller unmarshaller) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unmarshaller placed back into pool");
        }
        if (ENABLE_UNMARSHALL_POOLING) {
            unmarshaller.setAttachmentUnmarshaller(null);
            upool.put(context, unmarshaller);
        }
    }

    public static Marshaller getJAXBMarshaller(JAXBContext context) throws JAXBException {
        Marshaller m = null;
        if (!ENABLE_MARSHALL_POOLING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marshaller created [no pooling]");
            }
            m = JAXBUtils.internalCreateMarshaller(context);
        } else {
            m = mpool.get(context);
            if (m == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Marshaller created [not in pool]");
                }
                m = JAXBUtils.internalCreateMarshaller(context);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Marshaller obtained [from  pool]");
            }
        }
        m.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return m;
    }

    public static void releaseJAXBMarshaller(JAXBContext context, Marshaller marshaller) {
        block4: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Marshaller placed back into pool");
                log.debug((Object)("  Marshaller = " + JavaUtils.getObjectIdentity(marshaller)));
                log.debug((Object)("  JAXBContext = " + JavaUtils.getObjectIdentity(context)));
            }
            if (ENABLE_MARSHALL_POOLING) {
                try {
                    marshaller.setAttachmentMarshaller(null);
                    marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                    mpool.put(context, marshaller);
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)("The following exception is ignored. Processing continues " + t));
                }
            }
        }
    }

    public static JAXBIntrospector getJAXBIntrospector(JAXBContext context) throws JAXBException {
        JAXBIntrospector i = null;
        if (!ENABLE_INTROSPECTION_POOLING) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"JAXBIntrospector created [no pooling]");
            }
            i = JAXBUtils.internalCreateIntrospector(context);
        } else {
            i = ipool.get(context);
            if (i == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JAXBIntrospector created [not in pool]");
                }
                i = JAXBUtils.internalCreateIntrospector(context);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"JAXBIntrospector obtained [from  pool]");
            }
        }
        return i;
    }

    private static JAXBIntrospector internalCreateIntrospector(final JAXBContext context) {
        JAXBIntrospector i = (JAXBIntrospector)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return context.createJAXBIntrospector();
            }
        });
        return i;
    }

    public static void releaseJAXBIntrospector(JAXBContext context, JAXBIntrospector introspector) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"JAXBIntrospector placed back into pool");
        }
        if (ENABLE_INTROSPECTION_POOLING) {
            ipool.put(context, introspector);
        }
    }

    private static boolean checkPackage(String p, ClassLoader cl) {
        block8: {
            Class cls;
            block7: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("checking package :" + p));
                }
                try {
                    cls = JAXBUtils.forName(p + ".ObjectFactory", false, cl);
                    if (cls != null) {
                        return true;
                    }
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)("ObjectFactory Class Not Found " + e));
                }
            }
            try {
                cls = JAXBUtils.forName(p + ".package-info", false, cl);
                if (cls != null) {
                    return true;
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)("package-info Class Not Found " + e));
            }
        }
        return false;
    }

    private static JAXBContext createJAXBContextUsingContextPath(TreeSet<String> packages, ClassLoader cl, List<String> classRefs) {
        JAXBContext context;
        block8: {
            context = null;
            String contextpath = "";
            for (String p : packages) {
                if (contextpath.length() != 0) {
                    contextpath = contextpath + ":";
                }
                contextpath = contextpath + p;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to create JAXBContext with contextPath=" + contextpath));
                }
                if (!JAXBUtils.containsClasses(context = JAXBUtils.JAXBContext_newInstance(contextpath, cl), classRefs)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Unsuccessful: Will now use an alterative JAXBConstruct construction");
                    }
                    return null;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  Successfully created JAXBContext:" + context));
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)"  Unsuccessful: We will now use an alterative JAXBConstruct construction");
                log.debug((Object)("  Reason " + e.toString()));
            }
        }
        return context;
    }

    private static boolean containsClasses(JAXBContext context, List<String> classRefs) {
        String text = context.toString();
        text = text.replace('\n', ' ');
        text = text.replace('\t', ' ');
        text = text.replace('\r', ' ');
        text = text.replace('<', ' ');
        text = text.replace('[', ' ');
        text = text.replace(']', ' ');
        for (String classRef : classRefs) {
            String search;
            int index = classRef.indexOf(60);
            if (index > 0) {
                classRef = classRef.substring(0, index);
            }
            if ((index = classRef.indexOf(91)) > 0) {
                classRef = classRef.substring(0, index);
            }
            if (classRef.length() == 0 || classRef.endsWith(".ObjectFactory") || classRef.startsWith("java.util.") || classRef.startsWith("java.lang.") || text.contains(search = " " + classRef + " ")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("The context does not contain " + classRef + " " + context));
            }
            return false;
        }
        return true;
    }

    private static List<Class> getAllClassesFromPackage(String pkg, ClassLoader cl) {
        ArrayList<Class> classes;
        block19: {
            block18: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start: getAllClassesFromPackage for " + pkg));
                }
                if (pkg == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"End: getAllClassesFromPackage (package is null)");
                    }
                    return new ArrayList<Class>();
                }
                List<Class> knownClasses = specialMap.get(pkg);
                if (knownClasses != null) {
                    if (log.isDebugEnabled()) {
                        try {
                            log.debug((Object)("End: getAllClassesFromPackage (package is special) returning: " + knownClasses));
                        }
                        catch (Throwable t) {
                            log.debug((Object)"End: getAllClassesFromPackage (package is special)");
                        }
                    }
                    return knownClasses;
                }
                classes = new ArrayList<Class>();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Start: Obtain packages from similar directory");
                }
                try {
                    ArrayList<Class> classesFromDir = JAXBUtils.getClassesFromDirectory(pkg, cl);
                    JAXBUtils.checkClasses(classesFromDir, pkg);
                    classes.addAll(classesFromDir);
                }
                catch (ClassNotFoundException e) {
                    if (!log.isDebugEnabled()) break block18;
                    log.debug((Object)"getClassesFromDirectory failed to get Classes");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"End: Obtain packages from similar directory");
                log.debug((Object)"Start: Obtain packages from ClassFinder plugin");
            }
            try {
                ClassFinderFactory cff = (ClassFinderFactory)FactoryRegistry.getFactory(ClassFinderFactory.class);
                ClassFinder cf = cff.getClassFinder();
                ArrayList<Class> classesFromJar = cf.getClassesFromJarFile(pkg, cl);
                JAXBUtils.checkClasses(classesFromJar, pkg);
                classes.addAll(classesFromJar);
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) break block19;
                log.debug((Object)"getClassesFromJarFile failed to get Classes");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End: Obtain packages from ClassFinder plugin");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"End: Obtain packages from ClassFinder plugin");
        }
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("End: getAllClassesFromPackage for " + pkg + "with classes " + classes));
            }
            catch (Throwable e) {
                log.debug((Object)("End: getAllClassesFromPackage for " + pkg));
            }
        }
        return classes;
    }

    private static void checkClasses(List<Class> list, String pkg) {
        int i = 0;
        while (i < list.size()) {
            Class cls = list.get(i);
            if (!(cls.isInterface() || !cls.isEnum() && JAXBUtils.getAnnotation(cls, XmlType.class) == null && ClassUtils.getDefaultPublicConstructor(cls) == null || ClassUtils.isJAXWSClass(cls) || JAXBUtils.isSkipClass(cls) || !cls.getPackage().getName().equals(pkg))) {
                ++i;
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing class " + cls + " from consideration because it is not in package " + pkg + " or is an interface or does not have a public constructor or is" + " a jaxws class"));
            }
            list.remove(i);
        }
    }

    private static ArrayList<Class> getClassesFromDirectory(String pkg, ClassLoader cl) throws ClassNotFoundException {
        String pckgname = pkg;
        ArrayList<File> directories = new ArrayList<File>();
        try {
            String path = pckgname.replace('.', '/');
            Enumeration<URL> resources = cl.getResources(path);
            while (resources.hasMoreElements()) {
                directories.add(new File(URLDecoder.decode(resources.nextElement().getPath(), "UTF-8")));
            }
        }
        catch (UnsupportedEncodingException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(pckgname + " does not appear to be a valid package (Unsupported encoding)"));
            }
            throw new ClassNotFoundException(Messages.getMessage("ClassUtilsErr2", pckgname));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IOException was thrown when trying to get all resources for " + pckgname));
            }
            throw new ClassNotFoundException(Messages.getMessage("ClassUtilsErr3", pckgname));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : directories) {
            String[] files;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Adding JAXB classes from directory: " + directory.getName()));
            }
            if (!directory.exists()) continue;
            for (String file : files = directory.list()) {
                if (!file.endsWith(".class")) continue;
                String className = pckgname + '.' + file.substring(0, file.length() - 6);
                try {
                    Class clazz = JAXBUtils.forName(className, false, JAXBUtils.getContextClassLoader());
                    if (clazz.isInterface() || !clazz.isEnum() && JAXBUtils.getAnnotation(clazz, XmlType.class) == null && ClassUtils.getDefaultPublicConstructor(clazz) == null || ClassUtils.isJAXWSClass(clazz) || JAXBUtils.isSkipClass(clazz) || Exception.class.isAssignableFrom(clazz)) continue;
                    clazz.getDeclaredMethods();
                    clazz.getDeclaredFields();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding class: " + file));
                    }
                    classes.add(clazz);
                }
                catch (Throwable e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Tried to load class " + className + " while constructing a JAXBContext.  This class will be skipped.  Processing Continues."));
                    log.debug((Object)("  The reason that class could not be loaded:" + e.toString()));
                    log.trace((Object)JavaUtils.stackToString(e));
                }
            }
        }
        return classes;
    }

    private static void addCommonArrayClasses(List<Class> list) {
        ClassLoader cl = JAXBUtils.getContextClassLoader();
        for (int i = 0; i < commonArrayClasses.length; ++i) {
            String className = commonArrayClasses[i];
            try {
                Class cls = JAXBUtils.forName(ClassUtils.getLoadableClassName(className), false, cl);
                list.add(cls);
                continue;
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Tried to load class " + className + " while constructing a JAXBContext.  This class will be skipped.  Processing Continues."));
                log.debug((Object)("  The reason that class could not be loaded:" + e.toString()));
                log.trace((Object)JavaUtils.stackToString(e));
            }
        }
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }

    private static boolean isSkipClass(Class clazz) {
        for (Class cls = clazz; cls != null; cls = cls.getSuperclass()) {
            String clsName = cls.getCanonicalName();
            if (clsName != null && (clsName.equals("javax.ejb.SessionBean") || clsName.equals("org.apache.axis2.jaxws.spi.JAXBExclude"))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("isSkipClass returns true for : " + clazz));
                    log.debug((Object)("  (It is skipped because the class extends " + clsName));
                }
                return true;
            }
            Class[] intferfaces = JAXBUtils.getInterfaces_priv(cls);
            if (intferfaces == null) continue;
            for (int i = 0; i < intferfaces.length; ++i) {
                clsName = intferfaces[i].getCanonicalName();
                if (clsName == null || !clsName.equals("javax.ejb.SessionBean") && !clsName.equals("org.apache.axis2.jaxws.spi.JAXBExclude")) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("isSkipClass returns true for : " + clazz));
                    log.debug((Object)("  (It is skipped because the class implements " + clsName));
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("isSkipClass returns false for : " + clazz));
        }
        return false;
    }

    private static Class[] getInterfaces_priv(final Class cls) {
        Class[] intferfaces;
        block3: {
            intferfaces = null;
            if (cls == null) {
                return null;
            }
            try {
                intferfaces = (Class[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return cls.getInterfaces();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("Exception thrown from AccessController: " + e));
                log.debug((Object)"Exception is ignored.");
            }
        }
        return intferfaces;
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    Class<?> cls = ClassUtils.getPrimitiveClass(className);
                    if (cls == null) {
                        cls = Class.forName(className, initialize, classloader);
                    }
                    return cls;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static JAXBContext JAXBContext_newInstance(final String context, final ClassLoader classloader) throws Exception {
        JAXBContext jaxbContext = null;
        try {
            if (log.isDebugEnabled()) {
                if (context == null || context.length() == 0) {
                    log.debug((Object)"JAXBContext is constructed without a context String.");
                } else {
                    log.debug((Object)("JAXBContext is constructed with a context of:" + context));
                }
            }
            jaxbContext = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JAXBException {
                    return JAXBContext.newInstance((String)context, (ClassLoader)classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw e.getException();
        }
        return jaxbContext;
    }

    private static JAXBContext JAXBContext_newInstance(Class[] classArray, ClassLoader cl, Map<String, ?> properties, List<String> classRefs) throws JAXBException {
        JAXBContext jaxbContext = null;
        if (log.isDebugEnabled()) {
            if (classArray == null || classArray.length == 0) {
                log.debug((Object)"JAXBContext is constructed with 0 input classes.");
            } else {
                log.debug((Object)("JAXBContext is constructed with " + classArray.length + " input classes."));
            }
        }
        jaxbContext = JAXBContextFromClasses.newInstance(classArray, cl, properties, classRefs);
        return jaxbContext;
    }

    private static void adjustPoolSize(Map map) {
        if (map.size() > MAX_LOAD_FACTOR) {
            Iterator it = map.entrySet().iterator();
            boolean removeIt = false;
            while (it.hasNext()) {
                it.next();
                if (removeIt) {
                    it.remove();
                }
                removeIt = !removeIt;
            }
        }
    }

    private static Annotation getAnnotation(final AnnotatedElement element, final Class annotation) {
        return (Annotation)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return element.getAnnotation(annotation);
            }
        });
    }

    private static String getDefaultNamespaceRemapProperty() {
        String external = "com.sun.xml.bind.defaultNamespaceRemap";
        String internal = "com.sun.xml.internal.bind.defaultNamespaceRemap";
        Boolean isExternal = JAXBUtils.testJAXBProperty(external);
        if (Boolean.TRUE.equals(isExternal)) {
            return external;
        }
        Boolean isInternal = JAXBUtils.testJAXBProperty(internal);
        if (Boolean.TRUE.equals(isInternal)) {
            return internal;
        }
        return external;
    }

    private static Boolean testJAXBProperty(String propName) {
        final HashMap<String, String> props = new HashMap<String, String>();
        props.put(propName, "http://test");
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws JAXBException {
                    return JAXBContext.newInstance((Class[])new Class[]{Integer.class}, (Map)props);
                }
            });
            return Boolean.TRUE;
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof JAXBException) {
                return Boolean.FALSE;
            }
            return null;
        }
    }

    static {
        ArrayList<Class<W3CEndpointReference>> classes = new ArrayList<Class<W3CEndpointReference>>();
        classes.add(W3CEndpointReference.class);
        specialMap.put("javax.xml.ws.wsaddressing", classes);
        DEFAULT_NAMESPACE_REMAP = JAXBUtils.getDefaultNamespaceRemapProperty();
        commonArrayClasses = new String[]{"boolean[]", "byte[]", "char[]", "double[]", "float[]", "int[]", "long[]", "short[]", "java.lang.String[]", "java.lang.Object[]", "java.awt.Image[]", "java.math.BigDecimal[]", "java.math.BigInteger[]", "java.util.Calendar[]", "javax.xml.namespace.QName[]"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pool<K, V> {
        private SoftReference<Map<K, List<V>>> softMap = new SoftReference(new ConcurrentHashMap());
        private static int MAX_LIST_FACTOR = 50;
        private int count = 0;

        private Pool() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public V get(K key) {
            List<V> values;
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() > 0) {
                    V v = values.remove(values.size() - 1);
                    return v;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(K key, V value) {
            List<V> values;
            this.adjustSize();
            List<V> list = values = this.getValues(key);
            synchronized (list) {
                if (values.size() < MAX_LIST_FACTOR) {
                    values.add(value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<V> getValues(K key) {
            Map<K, List<List<V>>> map = this.softMap.get();
            List<V> values = null;
            if (map != null && (values = map.get(key)) != null) {
                return values;
            }
            Pool pool = this;
            synchronized (pool) {
                if (map != null) {
                    values = map.get(key);
                }
                if (values == null) {
                    if (map == null) {
                        map = new ConcurrentHashMap<K, List<V>>();
                        this.softMap = new SoftReference<Map<K, List<V>>>(map);
                    }
                    values = new ArrayList<V>();
                    map.put(key, values);
                }
                return values;
            }
        }

        private void adjustSize() {
            ++this.count;
            if (this.count < 10) {
                return;
            }
            this.count = 0;
            Map<K, List<V>> map = this.softMap.get();
            if (map != null && map.size() > MAX_LOAD_FACTOR) {
                Iterator<Map.Entry<K, List<V>>> it = map.entrySet().iterator();
                boolean removeIt = false;
                while (it.hasNext()) {
                    it.next();
                    if (removeIt) {
                        it.remove();
                    }
                    removeIt = !removeIt;
                }
            }
        }
    }

    static class JAXBContextValue {
        public JAXBContext jaxbContext;
        public CONSTRUCTION_TYPE constructionType;

        public JAXBContextValue(JAXBContext jaxbContext, CONSTRUCTION_TYPE constructionType) {
            this.jaxbContext = jaxbContext;
            this.constructionType = constructionType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CONSTRUCTION_TYPE {
        BY_CLASS_ARRAY,
        BY_CONTEXT_PATH,
        BY_CLASS_ARRAY_PLUS_ARRAYS,
        UNKNOWN;

    }
}

