/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.FSDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.AbstractLuceneSpellChecker;
import org.apache.solr.util.HighFrequencyDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexBasedSpellChecker
extends AbstractLuceneSpellChecker {
    private static final Logger log = LoggerFactory.getLogger(IndexBasedSpellChecker.class);
    public static final String THRESHOLD_TOKEN_FREQUENCY = "thresholdTokenFrequency";
    protected float threshold;
    protected IndexReader reader;

    public String init(NamedList config, SolrCore core) {
        super.init(config, core);
        this.threshold = config.get(THRESHOLD_TOKEN_FREQUENCY) == null ? 0.0f : ((Float)config.get(THRESHOLD_TOKEN_FREQUENCY)).floatValue();
        this.initSourceReader();
        return this.name;
    }

    private void initSourceReader() {
        if (this.sourceLocation != null) {
            try {
                FSDirectory luceneIndexDir = FSDirectory.getDirectory(this.sourceLocation);
                this.reader = IndexReader.open(luceneIndexDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void build(SolrCore core, SolrIndexSearcher searcher) {
        IndexReader reader = null;
        try {
            reader = this.sourceLocation == null ? searcher.getReader() : this.reader;
            this.dictionary = new HighFrequencyDictionary(reader, this.field, this.threshold);
            this.spellChecker.clearIndex();
            this.spellChecker.indexDictionary(this.dictionary);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected IndexReader determineReader(IndexReader reader) {
        IndexReader result = null;
        result = this.sourceLocation != null ? this.reader : reader;
        return result;
    }

    public void reload() throws IOException {
        super.reload();
        this.initSourceReader();
    }

    public float getThreshold() {
        return this.threshold;
    }
}

