/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class SimpleContentConstructor
extends Expression {
    Expression select;
    Expression separator;
    boolean isSingleton = false;
    boolean isAtomic = false;

    public SimpleContentConstructor(Expression select, Expression separator) {
        this.select = select;
        this.separator = separator;
        this.adoptChildExpression(select);
        this.adoptChildExpression(separator);
        select.setFlattened(true);
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public Expression getSeparatorExpression() {
        return this.separator;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    protected int computeCardinality() {
        return 16384;
    }

    public Expression copy() {
        return new SimpleContentConstructor(this.select.copy(), this.separator.copy());
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        if (this.select instanceof Literal && ((Literal)this.select).getValue() instanceof AtomicValue) {
            return this.select;
        }
        this.separator = visitor.simplify(this.separator);
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th;
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.separator = visitor.typeCheck(this.separator, contextItemType);
        if (!Cardinality.allowsMany(this.select.getCardinality())) {
            this.isSingleton = true;
        }
        if (this.select.getItemType(th = visitor.getConfiguration().getTypeHierarchy()).isAtomicType()) {
            this.isAtomic = true;
        }
        this.select.setFlattened(true);
        if (this.select instanceof Literal && this.separator instanceof Literal) {
            XPathContext c = visitor.getStaticContext().makeEarlyEvaluationContext();
            return new Literal(Value.asValue(this.evaluateItem(c)));
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        this.separator = visitor.optimize(this.separator, contextItemType);
        if (this.select instanceof Literal && this.separator instanceof Literal) {
            XPathContext c = visitor.getStaticContext().makeEarlyEvaluationContext();
            return Literal.makeLiteral(Value.asValue(this.evaluateItem(c)));
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.STRING;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("simpleContentConstructor");
        this.select.explain(out);
        this.separator.explain(out);
        out.endElement();
    }

    public Iterator iterateSubExpressions() {
        return new PairIterator(this.select, this.separator);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.separator == original) {
            this.separator = replacement;
            found = true;
        }
        return found;
    }

    public Expression promote(PromotionOffer offer) throws XPathException {
        Expression exp = offer.accept(this);
        if (exp != null) {
            return exp;
        }
        this.select = this.doPromotion(this.select, offer);
        this.separator = this.doPromotion(this.separator, offer);
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item;
        SequenceIterator iter;
        if (this.isSingleton) {
            Item item2 = this.select.evaluateItem(context);
            if (item2 == null || item2 instanceof StringValue) {
                return item2;
            }
            if (item2 instanceof AtomicValue) {
                return ((AtomicValue)item2).convert(BuiltInAtomicType.STRING, true, context).asAtomic();
            }
            iter = SingletonIterator.makeIterator(item2);
        } else {
            iter = this.select.iterate(context);
        }
        FastStringBuffer sb = new FastStringBuffer(1024);
        boolean prevText = false;
        boolean first = true;
        CharSequence sep = null;
        while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo) {
                Item item2;
                if (((NodeInfo)item).getNodeKind() == 3) {
                    CharSequence s = item.getStringValueCS();
                    if (s.length() <= 0) continue;
                    if (!first && !prevText) {
                        if (sep == null) {
                            sep = this.separator.evaluateItem(context).getStringValueCS();
                        }
                        sb.append(sep);
                    }
                    first = false;
                    sb.append(s);
                    prevText = true;
                    continue;
                }
                prevText = false;
                SequenceIterator iter2 = item.getTypedValue();
                while ((item2 = iter2.next()) != null) {
                    if (!first) {
                        if (sep == null) {
                            sep = this.separator.evaluateItem(context).getStringValueCS();
                        }
                        sb.append(sep);
                    }
                    first = false;
                    sb.append(item2.getStringValueCS());
                }
                continue;
            }
            if (!first) {
                if (sep == null) {
                    sep = this.separator.evaluateItem(context).getStringValueCS();
                }
                sb.append(sep);
            }
            first = false;
            prevText = false;
            sb.append(item.getStringValueCS());
        }
        return StringValue.makeStringValue(sb.condense());
    }

    public int getImplementationMethod() {
        return 1;
    }
}

