/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.net.URL;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.util.FieldCacheSanityChecker;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrInfoMBean;

public class SolrFieldCacheMBean
implements SolrInfoMBean {
    protected FieldCacheSanityChecker checker = new FieldCacheSanityChecker();

    public String getName() {
        return this.getClass().getName();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Provides introspection of the Lucene FieldCache, this is **NOT** a cache that is managed by Solr.";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.CACHE;
    }

    public String getSourceId() {
        return "$Id: SolrFieldCacheMBean.java 826788 2009-10-19 19:44:41Z hossman $";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/solr/branches/branch-1.4/src/java/org/apache/solr/search/SolrFieldCacheMBean.java $";
    }

    public URL[] getDocs() {
        return null;
    }

    public NamedList getStatistics() {
        SimpleOrderedMap<Object> stats = new SimpleOrderedMap<Object>();
        FieldCache.CacheEntry[] entries = FieldCache.DEFAULT.getCacheEntries();
        stats.add("entries_count", entries.length);
        for (int i = 0; i < entries.length; ++i) {
            FieldCache.CacheEntry e = entries[i];
            stats.add("entry#" + i, e.toString());
        }
        FieldCacheSanityChecker.Insanity[] insanity = FieldCacheSanityChecker.checkSanity(entries);
        stats.add("insanity_count", insanity.length);
        for (int i = 0; i < insanity.length; ++i) {
            for (FieldCache.CacheEntry e : insanity[i].getCacheEntries()) {
                if (null != e.getEstimatedSize()) continue;
                e.estimateSize();
            }
            stats.add("insanity#" + i, insanity[i].toString());
        }
        return stats;
    }
}

