/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter
implements Receiver {
    private PipelineConfiguration pipe;
    private NamePool namePool;
    private Node currentNode;
    private Document document;
    private Node nextSibling;
    private int level = 0;
    private boolean canNormalize = true;
    private String systemId;

    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
        this.namePool = pipe.getConfiguration().getNamePool();
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void open() {
    }

    public void close() {
    }

    public void startDocument(int properties) throws XPathException {
    }

    public void endDocument() throws XPathException {
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        String qname = this.namePool.getDisplayName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        try {
            Element element = this.document.createElementNS("".equals(uri) ? null : uri, qname);
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(element, this.nextSibling);
            } else {
                this.currentNode.appendChild(element);
            }
            this.currentNode = element;
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
        ++this.level;
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        try {
            String prefix = this.namePool.getPrefixFromNamespaceCode(namespaceCode);
            String uri = this.namePool.getURIFromNamespaceCode(namespaceCode);
            Element element = (Element)this.currentNode;
            if (!uri.equals("http://www.w3.org/XML/1998/namespace")) {
                if (prefix.length() == 0) {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", uri);
                } else {
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
                }
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        String qname = this.namePool.getDisplayName(nameCode);
        String uri = this.namePool.getURI(nameCode);
        try {
            Element element = (Element)this.currentNode;
            element.setAttributeNS("".equals(uri) ? null : uri, qname, ((Object)value).toString());
            if ((nameCode & 0xFFFFF) == 388 || (properties & 0x800) != 0) {
                int colon = qname.indexOf(58);
                if (colon >= 0) {
                    qname = qname.substring(colon);
                }
                element.setIdAttributeNS(uri, qname, true);
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    public void startContent() throws XPathException {
    }

    public void endElement() throws XPathException {
        if (this.canNormalize) {
            try {
                this.currentNode.normalize();
            }
            catch (Throwable err) {
                this.canNormalize = false;
            }
        }
        this.currentNode = this.currentNode.getParentNode();
        --this.level;
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        try {
            Text text = this.document.createTextNode(((Object)chars).toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(text, this.nextSibling);
            } else {
                this.currentNode.appendChild(text);
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        try {
            ProcessingInstruction pi = this.document.createProcessingInstruction(target, ((Object)data).toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(pi, this.nextSibling);
            } else {
                this.currentNode.appendChild(pi);
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        try {
            Comment comment = this.document.createComment(((Object)chars).toString());
            if (this.nextSibling != null && this.level == 0) {
                this.currentNode.insertBefore(comment, this.nextSibling);
            } else {
                this.currentNode.appendChild(comment);
            }
        }
        catch (DOMException err) {
            throw new XPathException(err);
        }
    }

    public void setNode(Node node) {
        if (node == null) {
            return;
        }
        this.currentNode = node;
        this.document = node.getNodeType() == 9 ? (Document)node : this.currentNode.getOwnerDocument();
    }

    public void setNextSibling(Node nextSibling) {
        this.nextSibling = nextSibling;
    }
}

