/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.jaggery.core.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.engine.JavaScriptHostObject;
import org.jaggeryjs.scriptengine.engine.JavaScriptMethod;
import org.jaggeryjs.scriptengine.engine.JavaScriptModule;
import org.jaggeryjs.scriptengine.engine.JavaScriptScript;
import org.jaggeryjs.scriptengine.engine.RhinoEngine;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityController;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class ModuleManager {
    private static final String NAMESPACE = "namespace";
    private static final String EXPOSE = "expose";
    private static final String NAME = "name";
    private static final String READ_ONLY = "readOnly";
    private static final Log log = LogFactory.getLog(ModuleManager.class);
    public static final String MODULE_NAMESPACE = "http://wso2.org/projects/jaggery/module.xml";
    private static final String MODULE_FILE = "module.xml";
    private final Map<String, JavaScriptModule> modules = new HashMap<String, JavaScriptModule>();
    private String modulesDir = null;

    public ModuleManager(String modulesDir) throws ScriptException {
        this.modulesDir = modulesDir;
        this.init();
    }

    private void init() throws ScriptException {
        InputStream xmlStream = ModuleManager.class.getClassLoader().getResourceAsStream("META-INF/module.xml");
        this.initModule(xmlStream, false);
        RhinoEngine.enterGlobalContext();
        File modulesDir = new File(this.modulesDir);
        File[] modules = modulesDir.listFiles();
        if (modules != null) {
            for (File module : modules) {
                File moduleConfig;
                if (!module.isDirectory() || !(moduleConfig = new File(module, MODULE_FILE)).exists()) continue;
                try {
                    this.initModule(new FileInputStream(moduleConfig), true);
                }
                catch (FileNotFoundException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        RhinoEngine.exitContext();
    }

    public Map<String, JavaScriptModule> getModules() {
        return this.modules;
    }

    private void initModule(InputStream modulesXML, boolean isCustom) throws ScriptException {
        try {
            Context cx = RhinoEngine.enterGlobalContext();
            StAXOMBuilder builder = new StAXOMBuilder(modulesXML);
            OMElement document = builder.getDocumentElement();
            OMNamespace ns = document.getNamespace();
            if (ns == null || !MODULE_NAMESPACE.equals(document.getNamespace().getNamespaceURI())) {
                log.warn((Object)"A module xml found without the proper namespace");
                return;
            }
            String moduleName = document.getAttributeValue(new QName(null, NAME));
            if (this.modules.get(moduleName) != null) {
                log.info((Object)("A module with the name : " + moduleName + " already exists and it will be overwritten."));
            }
            String namespace = document.getAttributeValue(new QName(null, NAMESPACE));
            boolean expose = "true".equalsIgnoreCase(document.getAttributeValue(new QName(null, EXPOSE)));
            JavaScriptModule module = new JavaScriptModule(moduleName);
            module.setNamespace(namespace);
            module.setExpose(expose);
            this.initHostObjects(document, module);
            this.initMethods(document, module);
            this.initScripts(document, cx, module, isCustom);
            this.modules.put(moduleName, module);
        }
        catch (XMLStreamException e) {
            String msg = "Error while reading the module.xml";
            log.error((Object)msg, (Throwable)e);
            throw new ScriptException(msg, (Exception)e);
        }
        finally {
            RhinoEngine.exitContext();
        }
    }

    private void initScripts(OMElement moduleOM, Context cx, JavaScriptModule module, boolean isCustom) throws ScriptException {
        String name = null;
        String path = null;
        Iterator itr = moduleOM.getChildrenWithName(new QName(MODULE_NAMESPACE, "script"));
        while (itr.hasNext()) {
            String msg;
            try {
                OMElement scriptOM = (OMElement)itr.next();
                name = scriptOM.getFirstChildWithName(new QName(MODULE_NAMESPACE, NAME)).getText();
                path = scriptOM.getFirstChildWithName(new QName(MODULE_NAMESPACE, "path")).getText();
                JavaScriptScript script = new JavaScriptScript(name);
                InputStreamReader reader = isCustom ? new FileReader(this.modulesDir + File.separator + module.getName() + File.separator + this.filterPath(path)) : new InputStreamReader(ModuleManager.class.getClassLoader().getResourceAsStream(path));
                final Script scriptObj = cx.compileReader((Reader)reader, name, 1, null);
                if (RhinoSecurityController.isSecurityEnabled()) {
                    script.setScript(new Script(){

                        public Object exec(final Context cx, final Scriptable scope) {
                            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    return scriptObj.exec(cx, scope);
                                }
                            });
                        }
                    });
                } else {
                    script.setScript(scriptObj);
                }
                module.addScript(script);
            }
            catch (FileNotFoundException e) {
                msg = "Error executing script. Script cannot be found, name : " + name + ", path : " + path;
                log.error((Object)msg, (Throwable)e);
                if (isCustom) continue;
                throw new ScriptException(msg, (Exception)e);
            }
            catch (IOException e) {
                msg = "Error executing script. Script cannot be found, name : " + name + ", path : " + path;
                log.error((Object)msg, (Throwable)e);
                if (isCustom) continue;
                throw new ScriptException(msg, (Exception)e);
            }
        }
    }

    private void initMethods(OMElement moduleOM, JavaScriptModule module) throws ScriptException {
        String name = null;
        String className = null;
        Iterator itr = moduleOM.getChildrenWithName(new QName(MODULE_NAMESPACE, "method"));
        while (itr.hasNext()) {
            try {
                OMElement methodOM = (OMElement)itr.next();
                name = methodOM.getFirstChildWithName(new QName(MODULE_NAMESPACE, NAME)).getText();
                className = methodOM.getFirstChildWithName(new QName(MODULE_NAMESPACE, "className")).getText();
                OMAttribute attribute = methodOM.getAttribute(new QName(MODULE_NAMESPACE, READ_ONLY));
                JavaScriptMethod method = new JavaScriptMethod(name);
                method.setClazz(Class.forName(className));
                method.setMethodName(name);
                if (attribute != null) {
                    method.setAttribute("true".equals(attribute.getAttributeValue()) ? 1 : 4);
                }
                module.addMethod(method);
            }
            catch (ClassNotFoundException e) {
                String msg = "Error registering method. Class cannot be found, name : " + name + ", class : " + className;
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    private void initHostObjects(OMElement moduleOM, JavaScriptModule jaggeryModule) throws ScriptException {
        Iterator itr = moduleOM.getChildrenWithName(new QName(MODULE_NAMESPACE, "hostObject"));
        String msg = "Error while adding HostObject : ";
        while (itr.hasNext()) {
            OMElement hostObjectOM = (OMElement)itr.next();
            String name = hostObjectOM.getFirstChildWithName(new QName(MODULE_NAMESPACE, NAME)).getText();
            String className = hostObjectOM.getFirstChildWithName(new QName(MODULE_NAMESPACE, "className")).getText();
            OMAttribute attribute = hostObjectOM.getAttribute(new QName(MODULE_NAMESPACE, READ_ONLY));
            JavaScriptHostObject hostObject = new JavaScriptHostObject(name);
            if (attribute != null) {
                hostObject.setAttribute("true".equals(attribute.getAttributeValue()) ? 1 : 4);
            }
            try {
                hostObject.setClazz(Class.forName(className));
                jaggeryModule.addHostObject(hostObject);
            }
            catch (ClassNotFoundException e) {
                msg = msg + name + " " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
            }
        }
    }

    private String filterPath(String path) {
        String pathToReturn = path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        if (!pathToReturn.startsWith(File.separator)) {
            pathToReturn = File.separator + pathToReturn;
        }
        return pathToReturn;
    }
}

