/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.wso2.javascript.xmlimpl.XMLLibImpl;

public class Namespace
extends IdScriptableObject {
    private XMLLibImpl lib;
    private String prefixValue;
    private String uriValue;
    private static final Object NAMESPACE_TAG = new Object();
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_prefix = 1;
    private static final int Id_uri = 2;
    private static final int MAX_PROTOTYPE_ID = 3;
    private static final int MAX_INSTANCE_ID = 2;

    public Namespace(XMLLibImpl lib, String uriValue) {
        super(lib.globalScope(), (Scriptable)lib.namespacePrototype);
        this.lib = lib;
        if (uriValue == null) {
            throw new IllegalArgumentException();
        }
        this.lib = lib;
        this.prefixValue = uriValue.length() == 0 ? "" : null;
        this.uriValue = uriValue;
    }

    public Namespace(XMLLibImpl lib, String prefixValue, String uriValue) {
        super(lib.globalScope(), (Scriptable)lib.namespacePrototype);
        if (uriValue == null) {
            throw new IllegalArgumentException();
        }
        if (uriValue.length() == 0) {
            if (prefixValue == null) {
                throw new IllegalArgumentException();
            }
            if (prefixValue.length() != 0) {
                throw new IllegalArgumentException();
            }
        }
        this.lib = lib;
        this.prefixValue = prefixValue;
        this.uriValue = uriValue;
    }

    public void exportAsJSClass(boolean sealed) {
        this.exportAsJSClass(3, this.lib.globalScope(), sealed);
    }

    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    protected int findInstanceIdInfo(String s) {
        int attr;
        int id = 0;
        String x = null;
        int length = s.length();
        if (length == 3) {
            x = "uri";
            id = 2;
        } else if (length == 6) {
            x = "prefix";
            id = 1;
        }
        if (x != null && x != s && !x.equals(s)) {
            id = 0;
        }
        if (id == 0) {
            return super.findInstanceIdInfo(s);
        }
        switch (id) {
            case 1: 
            case 2: {
                attr = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return Namespace.instanceIdInfo((int)attr, (int)(super.getMaxInstanceId() + id));
    }

    protected String getInstanceIdName(int id) {
        switch (id - super.getMaxInstanceId()) {
            case 1: {
                return "prefix";
            }
            case 2: {
                return "uri";
            }
        }
        return super.getInstanceIdName(id);
    }

    protected Object getInstanceIdValue(int id) {
        switch (id - super.getMaxInstanceId()) {
            case 1: {
                if (this.prefix() == null) {
                    return Undefined.instance;
                }
                return this.prefix();
            }
            case 2: {
                return this.uri();
            }
        }
        return super.getInstanceIdValue(id);
    }

    protected Object equivalentValues(Object value) {
        if (!(value instanceof Namespace)) {
            return Scriptable.NOT_FOUND;
        }
        boolean result = this.equals((Namespace)((Object)value));
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Namespace)) {
            return false;
        }
        return this.equals((Namespace)((Object)obj));
    }

    private boolean equals(Namespace n) {
        return this.uri().equals(n.uri());
    }

    private Namespace realThis(Scriptable thisObj, IdFunctionObject f) {
        if (!(thisObj instanceof Namespace)) {
            throw Namespace.incompatibleCallError((IdFunctionObject)f);
        }
        return (Namespace)thisObj;
    }

    protected int findPrototypeId(String s) {
        int id = 0;
        String x = null;
        int length = s.length();
        if (length == 8) {
            char c = s.charAt(3);
            if (c == 'o') {
                x = "toSource";
                id = 3;
            } else if (c == 't') {
                x = "toString";
                id = 2;
            }
        } else if (length == 11) {
            x = "constructor";
            id = 1;
        }
        if (x != null && x != s && !x.equals(s)) {
            id = 0;
        }
        return id;
    }

    protected void initPrototypeId(int id) {
        String s;
        int arity;
        switch (id) {
            case 1: {
                arity = 2;
                s = "constructor";
                break;
            }
            case 2: {
                arity = 0;
                s = "toString";
                break;
            }
            case 3: {
                arity = 0;
                s = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(NAMESPACE_TAG, id, s, arity);
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag(NAMESPACE_TAG)) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        int id = f.methodId();
        switch (id) {
            case 1: {
                return this.namespaceConstructor(cx, thisObj == null, args);
            }
            case 2: {
                return this.realThis(thisObj, f).toString();
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public String toString() {
        return this.uriValue;
    }

    public String getClassName() {
        return "Namespace";
    }

    private Object namespaceConstructor(Context cx, boolean inNewExpr, Object[] args) {
        Namespace namespace;
        if (!inNewExpr && args.length == 1 && args[0] instanceof Namespace) {
            Namespace namespace2 = this.lib.castToNamespace(cx, args[0]);
        }
        if (args.length == 0) {
            namespace = this.lib.constructNamespace(cx);
        } else if (args.length == 1) {
            namespace = this.lib.constructNamespace(cx, args[0]);
        } else if (args.length == 2) {
            namespace = this.lib.constructNamespace(cx, args[0], args[1]);
        } else {
            throw ScriptRuntime.typeError((String)"Cannot find a matching constructor. ");
        }
        return namespace;
    }

    public String uri() {
        return this.uriValue;
    }

    public String prefix() {
        return this.prefixValue;
    }
}

