/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.security;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityDomain;

public class RhinoURISecurityDomain
implements RhinoSecurityDomain {
    private String scriptURI;
    private CodeSource codeSource = null;

    public RhinoURISecurityDomain(String scriptURI) {
        this.scriptURI = scriptURI;
    }

    @Override
    public CodeSource getCodeSource() throws ScriptException {
        if (this.codeSource != null) {
            return this.codeSource;
        }
        try {
            URL url = new URI(this.scriptURI).toURL();
            this.codeSource = new CodeSource(url, (Certificate[])null);
            return this.codeSource;
        }
        catch (MalformedURLException e) {
            throw new ScriptException(e);
        }
        catch (URISyntaxException e) {
            throw new ScriptException(e);
        }
    }

    public String getScriptURI() {
        return this.scriptURI;
    }
}

