/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.eventing;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.registry.common.utils.CommonUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public final class WorkListConfig {
    private static final Log log = LogFactory.getLog(WorkListConfig.class);
    private String username;
    private String password;
    private String serverURL;
    private String remote;

    public WorkListConfig() {
        File registryXML;
        String configPath = CarbonUtils.getRegistryXMLPath();
        if (configPath != null && (registryXML = new File(configPath)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(registryXML);
                StAXOMBuilder builder = new StAXOMBuilder(CarbonUtils.replaceSystemVariablesInXml((InputStream)fileInputStream));
                OMElement configElement = builder.getDocumentElement();
                SecretResolver secretResolver = SecretResolverFactory.create((OMElement)configElement, (boolean)false);
                OMElement workList = configElement.getFirstChildWithName(new QName("workList"));
                if (workList != null) {
                    this.username = workList.getFirstChildWithName(new QName("username")).getText();
                    this.password = CommonUtil.getResolvedPassword(secretResolver, "workList", workList.getFirstChildWithName(new QName("password")).getText());
                    this.serverURL = workList.getAttributeValue(new QName("serverURL"));
                    this.remote = workList.getAttributeValue(new QName("remote"));
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Unable to parse registry.xml", (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Unable to read registry.xml", (Throwable)e);
            }
            catch (CarbonException e) {
                log.error((Object)"An error occurred during system variable replacement", (Throwable)e);
            }
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public boolean isRemote() {
        return Boolean.valueOf(this.remote);
    }
}

