/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.sync;

import java.util.Map;
import java.util.UUID;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebappsConstants;

public class ApplicationSynchronizeRequest
extends ClusteringMessage {
    private static final transient Log log = LogFactory.getLog(ApplicationSynchronizeRequest.class);
    private int tenantId;
    private String tenantDomain;
    private UUID messageId;
    private WebappsConstants.ApplicationOpType operation;
    private String[] webappFileNames;

    public ApplicationSynchronizeRequest() {
    }

    public ApplicationSynchronizeRequest(int tenantId, String tenantDomain, UUID messageId, WebappsConstants.ApplicationOpType applicationOpType, String[] webappFileNames) {
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.messageId = messageId;
        this.operation = applicationOpType;
        this.webappFileNames = webappFileNames;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received [" + (Object)((Object)this) + "] "));
        }
        if (this.tenantId != -1234 && TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)configContext).get(this.tenantDomain) == null) {
            if (!log.isDebugEnabled()) return;
            log.debug((Object)"Tenant is not loaded. ");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Going to synchronize Application status.");
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(this.tenantId);
            privilegedCarbonContext.setTenantDomain(this.tenantDomain);
            ConfigurationContext tenantConfigConfigurationContext = (ConfigurationContext)TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)configContext).get(this.tenantDomain);
            WebApplicationsHolder webappsHolder = (WebApplicationsHolder)tenantConfigConfigurationContext.getProperty("carbon.webapps.holder");
            switch (this.operation) {
                case STOP: {
                    this.stopApplications(webappsHolder);
                    return;
                }
                case START: {
                    this.startApplications(tenantConfigConfigurationContext, webappsHolder);
                    return;
                }
                case RELOAD: {
                    this.reloadApplications(webappsHolder);
                    return;
                }
            }
            return;
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void startApplications(ConfigurationContext configContext, WebApplicationsHolder webappsHolder) {
        Map<String, WebApplication> stoppedWebapps = webappsHolder.getStoppedWebapps();
        Deployer webappDeployer = ((DeploymentEngine)configContext.getAxisConfiguration().getConfigurator()).getDeployer("webapps", "war");
        for (String webappFileName : this.webappFileNames) {
            WebApplication webapp = stoppedWebapps.get(webappFileName);
            if (webapp != null) {
                try {
                    boolean started = webapp.start();
                    if (!started) continue;
                    String startedWebappFileName = webapp.getWebappFile().getName();
                    stoppedWebapps.remove(startedWebappFileName);
                    Map<String, WebApplication> startedWebapps = webappsHolder.getStartedWebapps();
                    startedWebapps.put(startedWebappFileName, webapp);
                }
                catch (CarbonException e) {
                    String msg = "Cannot start Application " + webapp;
                    log.error((Object)msg, (Throwable)e);
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("No stopped webapp " + webappFileName + "found for tenant:" + this.tenantDomain));
        }
    }

    private void reloadApplications(WebApplicationsHolder webappsHolder) {
        for (String webappFileName : this.webappFileNames) {
            webappsHolder.getStartedWebapps().get(webappFileName).reload();
        }
    }

    private void stopApplications(WebApplicationsHolder webappsHolder) {
        Map<String, WebApplication> startedWebapps = webappsHolder.getStartedWebapps();
        for (String webappFileName : this.webappFileNames) {
            try {
                WebApplication webApplication = startedWebapps.get(webappFileName);
                if (webApplication != null) {
                    webappsHolder.stopWebapp(webApplication);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No started webapp " + webappFileName + "found for tenant:" + this.tenantDomain));
            }
            catch (CarbonException e) {
                log.error((Object)"Error occurred while undeploying Applications", (Throwable)e);
            }
        }
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public String toString() {
        return "ApplicationSynchronizeRequest{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", messageId=" + this.messageId + '}';
    }
}

