/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.multitenancy;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ArtifactUnloader;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.deployment.GhostDeployer;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.utils.GhostWebappDeployerUtils;

public class WebappUnloader
implements ArtifactUnloader {
    private static final Log log = LogFactory.getLog(WebappUnloader.class);
    private static final long DEFAULT_MAX_INACTIVE_INTERVAL = 10L;

    public void unload() {
        ConfigurationContext mainConfigCtx = DataHolder.getServerConfigContext();
        if (mainConfigCtx == null) {
            return;
        }
        Set ccEntries = TenantAxisUtils.getTenantConfigurationContexts((ConfigurationContext)mainConfigCtx).entrySet();
        for (Map.Entry entry : ccEntries) {
            String tenantDomain = (String)entry.getKey();
            this.unloadInactiveWebapps((ConfigurationContext)entry.getValue(), tenantDomain);
        }
        this.unloadInactiveWebapps(mainConfigCtx, "Super Tenant");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadInactiveWebapps(ConfigurationContext configCtx, String tenantDomain) {
        WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)configCtx.getProperty("carbon.webapps.holder");
        int tenantId = MultitenantUtils.getTenantId((ConfigurationContext)configCtx);
        try {
            if (tenantId > 0) {
                PrivilegedCarbonContext.startTenantFlow();
            }
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantId(tenantId);
            privilegedCarbonContext.setTenantDomain(tenantDomain);
            if (webApplicationsHolder != null) {
                for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
                    Long lastUsageTime;
                    if (GhostWebappDeployerUtils.isGhostWebApp(webApplication) || (lastUsageTime = Long.valueOf(Long.parseLong((String)webApplication.getProperty("lastUsedTime")))) == null || !this.isInactive(lastUsageTime)) continue;
                    GhostDeployer ghostDeployer = GhostWebappDeployerUtils.getGhostDeployer(configCtx.getAxisConfiguration());
                    DeploymentFileData webappFileData = ghostDeployer.getFileData(webApplication.getWebappFile().getPath());
                    log.info((Object)("Unloading actual webapp : " + webApplication.getWebappFile().getName() + " and adding Ghost webapp. Tenant Domain: " + tenantDomain));
                    webApplication.setProperty("isBeingUnloaded", "true");
                    Map<String, WebApplication> transitGhostList = GhostWebappDeployerUtils.getTransitGhostWebAppsMap(configCtx);
                    transitGhostList.put(webApplication.getContextName(), webApplication);
                    try {
                        TomcatGenericWebappsDeployer tomcatWebappDeployer = webApplication.getTomcatGenericWebappsDeployer();
                        tomcatWebappDeployer.undeploy(webApplication.getWebappFile());
                        File ghostFile = GhostWebappDeployerUtils.getGhostFile(webappFileData.getAbsolutePath(), configCtx.getAxisConfiguration());
                        if (!ghostFile.exists()) continue;
                        WebApplication ghostWebapp = GhostWebappDeployerUtils.createGhostWebApp(ghostFile, webappFileData.getFile(), webApplication.getTomcatGenericWebappsDeployer(), configCtx);
                        webApplicationsHolder.getStartedWebapps().put(webappFileData.getName(), ghostWebapp);
                        webApplicationsHolder.getFaultyWebapps().remove(webappFileData.getName());
                        transitGhostList.remove(ghostWebapp.getContextName());
                    }
                    catch (Exception e) {
                        log.error((Object)("Error while unloading webapp : " + webApplication.getWebappFile().getName()), (Throwable)e);
                    }
                }
            }
        }
        finally {
            if (tenantId > 0) {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private boolean isInactive(Long lastUsedTime) {
        long inactiveInterval = System.currentTimeMillis() - lastUsedTime;
        long maxInactiveInterval = 10L;
        String property = System.getProperty("webapp.idle.time");
        if (property != null) {
            maxInactiveInterval = Long.parseLong(property);
        }
        return inactiveInterval > maxInactiveInterval * 60L * 1000L;
    }
}

