/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetIterator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBase;

public class BitDocSet
extends DocSetBase {
    final OpenBitSet bits;
    int size;

    public BitDocSet() {
        this.bits = new OpenBitSet();
    }

    public BitDocSet(OpenBitSet bits) {
        this.bits = bits;
        this.size = -1;
    }

    public BitDocSet(OpenBitSet bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    public DocIterator iterator() {
        return new DocIterator(){
            private final OpenBitSetIterator iter;
            private int pos;
            {
                this.iter = new OpenBitSetIterator(BitDocSet.this.bits);
                this.pos = this.iter.nextDoc();
            }

            public boolean hasNext() {
                return this.pos != Integer.MAX_VALUE;
            }

            public Integer next() {
                return this.nextDoc();
            }

            public void remove() {
                BitDocSet.this.bits.clear(this.pos);
            }

            public int nextDoc() {
                int old = this.pos;
                this.pos = this.iter.nextDoc();
                return old;
            }

            public float score() {
                return 0.0f;
            }
        };
    }

    public OpenBitSet getBits() {
        return this.bits;
    }

    public void add(int doc) {
        this.bits.set(doc);
        this.size = -1;
    }

    public void addUnique(int doc) {
        this.bits.set(doc);
        this.size = -1;
    }

    public int size() {
        if (this.size != -1) {
            return this.size;
        }
        this.size = (int)this.bits.cardinality();
        return this.size;
    }

    public void invalidateSize() {
        this.size = -1;
    }

    public boolean exists(int doc) {
        return this.bits.get(doc);
    }

    public int intersectionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.intersectionCount(this.bits, ((BitDocSet)other).bits);
        }
        return other.intersectionSize(this);
    }

    public int unionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.unionCount(this.bits, ((BitDocSet)other).bits);
        }
        return other.unionSize(this);
    }

    public int andNotSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.andNotCount(this.bits, ((BitDocSet)other).bits);
        }
        return super.andNotSize(other);
    }

    public DocSet andNot(DocSet other) {
        OpenBitSet newbits = (OpenBitSet)this.bits.clone();
        if (other instanceof BitDocSet) {
            newbits.andNot(((BitDocSet)other).bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                newbits.clear(iter.nextDoc());
            }
        }
        return new BitDocSet(newbits);
    }

    public DocSet union(DocSet other) {
        OpenBitSet newbits = (OpenBitSet)this.bits.clone();
        if (other instanceof BitDocSet) {
            newbits.union(((BitDocSet)other).bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                newbits.set(iter.nextDoc());
            }
        }
        return new BitDocSet(newbits);
    }

    public long memSize() {
        return (this.bits.getBits().length << 3) + 16;
    }
}

