/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.XmlUpdateRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;

class XMLLoader
extends ContentStreamLoader {
    protected UpdateRequestProcessor processor;
    private XMLInputFactory inputFactory;

    public XMLLoader(UpdateRequestProcessor processor, XMLInputFactory inputFactory) {
        this.processor = processor;
        this.inputFactory = inputFactory;
    }

    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream) throws Exception {
        this.errHeader = "XMLLoader: " + stream.getSourceInfo();
        Reader reader = null;
        try {
            try {
                reader = stream.getReader();
                if (XmlUpdateRequestHandler.log.isTraceEnabled()) {
                    String body = IOUtils.toString((Reader)reader);
                    XmlUpdateRequestHandler.log.trace("body", (Object)body);
                    reader = new StringReader(body);
                }
                XMLStreamReader parser = this.inputFactory.createXMLStreamReader(reader);
                this.processUpdate(this.processor, parser);
            }
            catch (XMLStreamException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            IOUtils.closeQuietly((Reader)reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }

    void processUpdate(UpdateRequestProcessor processor, XMLStreamReader parser) throws XMLStreamException, IOException, FactoryConfigurationError, InstantiationException, IllegalAccessException, TransformerConfigurationException {
        AddUpdateCommand addCmd = null;
        while (true) {
            int event = parser.next();
            switch (event) {
                case 8: {
                    parser.close();
                    return;
                }
                case 1: {
                    String attrVal;
                    String attrName;
                    int i;
                    String currTag = parser.getLocalName();
                    if (currTag.equals("add")) {
                        XmlUpdateRequestHandler.log.trace("SolrCore.update(add)");
                        addCmd = new AddUpdateCommand();
                        boolean overwrite = true;
                        Boolean overwritePending = null;
                        Boolean overwriteCommitted = null;
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            attrName = parser.getAttributeLocalName(i);
                            attrVal = parser.getAttributeValue(i);
                            if ("overwrite".equals(attrName)) {
                                overwrite = StrUtils.parseBoolean(attrVal);
                                continue;
                            }
                            if ("allowDups".equals(attrName)) {
                                overwrite = !StrUtils.parseBoolean(attrVal);
                                continue;
                            }
                            if ("commitWithin".equals(attrName)) {
                                addCmd.commitWithin = Integer.parseInt(attrVal);
                                continue;
                            }
                            if ("overwritePending".equals(attrName)) {
                                overwritePending = StrUtils.parseBoolean(attrVal);
                                continue;
                            }
                            if ("overwriteCommitted".equals(attrName)) {
                                overwriteCommitted = StrUtils.parseBoolean(attrVal);
                                continue;
                            }
                            XmlUpdateRequestHandler.log.warn("Unknown attribute id in add:" + attrName);
                        }
                        if (overwritePending != null && overwriteCommitted != null) {
                            if (overwritePending != overwriteCommitted) {
                                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "can't have different values for 'overwritePending' and 'overwriteCommitted'");
                            }
                            overwrite = overwritePending;
                        }
                        addCmd.overwriteCommitted = overwrite;
                        addCmd.overwritePending = overwrite;
                        addCmd.allowDups = !overwrite;
                        break;
                    }
                    if ("doc".equals(currTag)) {
                        XmlUpdateRequestHandler.log.trace("adding doc...");
                        addCmd.clear();
                        addCmd.solrDoc = this.readDoc(parser);
                        processor.processAdd(addCmd);
                        break;
                    }
                    if ("commit".equals(currTag) || "optimize".equals(currTag)) {
                        XmlUpdateRequestHandler.log.trace("parsing " + currTag);
                        CommitUpdateCommand cmd = new CommitUpdateCommand("optimize".equals(currTag));
                        boolean sawWaitSearcher = false;
                        boolean sawWaitFlush = false;
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            attrName = parser.getAttributeLocalName(i);
                            attrVal = parser.getAttributeValue(i);
                            if ("waitFlush".equals(attrName)) {
                                cmd.waitFlush = StrUtils.parseBoolean(attrVal);
                                sawWaitFlush = true;
                                continue;
                            }
                            if ("waitSearcher".equals(attrName)) {
                                cmd.waitSearcher = StrUtils.parseBoolean(attrVal);
                                sawWaitSearcher = true;
                                continue;
                            }
                            if ("maxSegments".equals(attrName)) {
                                cmd.maxOptimizeSegments = Integer.parseInt(attrVal);
                                continue;
                            }
                            if ("expungeDeletes".equals(attrName)) {
                                cmd.expungeDeletes = StrUtils.parseBoolean(attrVal);
                                continue;
                            }
                            XmlUpdateRequestHandler.log.warn("unexpected attribute commit/@" + attrName);
                        }
                        if (sawWaitFlush && !sawWaitSearcher) {
                            cmd.waitSearcher = false;
                        }
                        processor.processCommit(cmd);
                        break;
                    }
                    if ("rollback".equals(currTag)) {
                        XmlUpdateRequestHandler.log.trace("parsing " + currTag);
                        RollbackUpdateCommand cmd = new RollbackUpdateCommand();
                        processor.processRollback(cmd);
                        break;
                    }
                    if (!"delete".equals(currTag)) break;
                    XmlUpdateRequestHandler.log.trace("parsing delete");
                    this.processDelete(processor, parser);
                }
            }
        }
    }

    void processDelete(UpdateRequestProcessor processor, XMLStreamReader parser) throws XMLStreamException, IOException {
        DeleteUpdateCommand deleteCmd = new DeleteUpdateCommand();
        deleteCmd.fromPending = true;
        deleteCmd.fromCommitted = true;
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attrName = parser.getAttributeLocalName(i);
            String attrVal = parser.getAttributeValue(i);
            if ("fromPending".equals(attrName)) {
                deleteCmd.fromPending = StrUtils.parseBoolean(attrVal);
                continue;
            }
            if ("fromCommitted".equals(attrName)) {
                deleteCmd.fromCommitted = StrUtils.parseBoolean(attrVal);
                continue;
            }
            XmlUpdateRequestHandler.log.warn("unexpected attribute delete/@" + attrName);
        }
        StringBuilder text = new StringBuilder();
        while (true) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    String mode = parser.getLocalName();
                    if (!"id".equals(mode) && !"query".equals(mode)) {
                        XmlUpdateRequestHandler.log.warn("unexpected XML tag /delete/" + mode);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag /delete/" + mode);
                    }
                    text.setLength(0);
                    break;
                }
                case 2: {
                    String currTag = parser.getLocalName();
                    if ("id".equals(currTag)) {
                        deleteCmd.id = text.toString();
                    } else if ("query".equals(currTag)) {
                        deleteCmd.query = text.toString();
                    } else {
                        if ("delete".equals(currTag)) {
                            return;
                        }
                        XmlUpdateRequestHandler.log.warn("unexpected XML tag /delete/" + currTag);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag /delete/" + currTag);
                    }
                    processor.processDelete(deleteCmd);
                    deleteCmd.id = null;
                    deleteCmd.query = null;
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                }
            }
        }
    }

    SolrInputDocument readDoc(XMLStreamReader parser) throws XMLStreamException {
        SolrInputDocument doc = new SolrInputDocument();
        String attrName = "";
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            attrName = parser.getAttributeLocalName(i);
            if ("boost".equals(attrName)) {
                doc.setDocumentBoost(Float.parseFloat(parser.getAttributeValue(i)));
                continue;
            }
            XmlUpdateRequestHandler.log.warn("Unknown attribute doc/@" + attrName);
        }
        StringBuilder text = new StringBuilder();
        String name = null;
        float boost = 1.0f;
        boolean isNull = false;
        block6: while (true) {
            int event = parser.next();
            switch (event) {
                case 4: 
                case 6: 
                case 12: {
                    text.append(parser.getText());
                    break;
                }
                case 2: {
                    if ("doc".equals(parser.getLocalName())) {
                        return doc;
                    }
                    if (!"field".equals(parser.getLocalName()) || isNull) continue block6;
                    doc.addField(name, text.toString(), boost);
                    boost = 1.0f;
                    break;
                }
                case 1: {
                    text.setLength(0);
                    String localName = parser.getLocalName();
                    if (!"field".equals(localName)) {
                        XmlUpdateRequestHandler.log.warn("unexpected XML tag doc/" + localName);
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unexpected XML tag doc/" + localName);
                    }
                    boost = 1.0f;
                    String attrVal = "";
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        attrName = parser.getAttributeLocalName(i);
                        attrVal = parser.getAttributeValue(i);
                        if ("name".equals(attrName)) {
                            name = attrVal;
                            continue;
                        }
                        if ("boost".equals(attrName)) {
                            boost = Float.parseFloat(attrVal);
                            continue;
                        }
                        if ("null".equals(attrName)) {
                            isNull = StrUtils.parseBoolean(attrVal);
                            continue;
                        }
                        XmlUpdateRequestHandler.log.warn("Unknown attribute doc/field/@" + attrName);
                    }
                    continue block6;
                }
            }
        }
    }
}

