/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.index.IndexCommit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.FileUtils;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapPuller {
    private static final Logger LOG = LoggerFactory.getLogger((String)SnapPuller.class.getName());
    private final String masterUrl;
    private final ReplicationHandler replicationHandler;
    private final Integer pollInterval;
    private String pollIntervalStr;
    private ScheduledExecutorService executorService;
    private volatile long executorStartTime;
    private volatile long replicationStartTime;
    private final SolrCore solrCore;
    private volatile List<Map<String, Object>> filesToDownload;
    private volatile List<Map<String, Object>> confFilesToDownload;
    private volatile List<Map<String, Object>> filesDownloaded;
    private volatile List<Map<String, Object>> confFilesDownloaded;
    private volatile Map<String, Object> currentFile;
    private volatile FileFetcher fileFetcher;
    private volatile ExecutorService fsyncService;
    private volatile boolean stop = false;
    private boolean useInternal = false;
    private boolean useExternal = false;
    private AtomicBoolean pollDisabled = new AtomicBoolean(false);
    private static HttpClient client;
    private final HttpClient myHttpClient;
    boolean successfulInstall = false;
    private volatile Exception fsyncException;
    private final Map<String, ReplicationHandler.FileInfo> confFileInfoCache = new HashMap<String, ReplicationHandler.FileInfo>();
    private static final int MAX_RETRIES = 5;
    private static final int NO_CONTENT = 1;
    private static final int ERR = 2;
    public static final String REPLICATION_PROPERTIES = "replication.properties";
    public static final String POLL_INTERVAL = "pollInterval";
    public static final String INTERVAL_ERR_MSG = "The pollInterval must be in this format 'HH:mm:ss'";
    private static final Pattern INTERVAL_PATTERN;
    private static final String HTTP_CONN_TIMEOUT = "httpConnTimeout";
    private static final String HTTP_READ_TIMEOUT = "httpReadTimeout";
    private static final String HTTP_BASIC_AUTH_USER = "httpBasicAuthUser";
    private static final String HTTP_BASIC_AUTH_PASSWORD = "httpBasicAuthPassword";
    static final String INDEX_REPLICATED_AT = "indexReplicatedAt";
    static final String TIMES_INDEX_REPLICATED = "timesIndexReplicated";
    static final String CONF_FILES_REPLICATED = "confFilesReplicated";
    static final String CONF_FILES_REPLICATED_AT = "confFilesReplicatedAt";
    static final String TIMES_CONFIG_REPLICATED = "timesConfigReplicated";
    static final String LAST_CYCLE_BYTES_DOWNLOADED = "lastCycleBytesDownloaded";
    static final String TIMES_FAILED = "timesFailed";
    static final String REPLICATION_FAILED_AT = "replicationFailedAt";
    static final String PREVIOUS_CYCLE_TIME_TAKEN = "previousCycleTimeInSeconds";
    static final String INDEX_REPLICATED_AT_LIST = "indexReplicatedAtList";
    static final String REPLICATION_FAILED_AT_LIST = "replicationFailedAtList";

    private static synchronized HttpClient createHttpClient(String connTimeout, String readTimeout) {
        if (connTimeout == null && readTimeout == null && client != null) {
            return client;
        }
        MultiThreadedHttpConnectionManager mgr = new MultiThreadedHttpConnectionManager();
        mgr.getParams().setDefaultMaxConnectionsPerHost(10000);
        mgr.getParams().setMaxTotalConnections(10000);
        mgr.getParams().setSoTimeout(readTimeout == null ? 20000 : Integer.parseInt(readTimeout));
        mgr.getParams().setConnectionTimeout(connTimeout == null ? 5000 : Integer.parseInt(connTimeout));
        HttpClient httpClient = new HttpClient((HttpConnectionManager)mgr);
        if (client == null && connTimeout == null && readTimeout == null) {
            client = httpClient;
        }
        return httpClient;
    }

    public SnapPuller(NamedList initArgs, ReplicationHandler handler, SolrCore sc) {
        this.solrCore = sc;
        this.masterUrl = (String)initArgs.get("masterUrl");
        if (this.masterUrl == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'masterUrl' is required for a slave");
        }
        this.replicationHandler = handler;
        this.pollIntervalStr = (String)initArgs.get(POLL_INTERVAL);
        this.pollInterval = SnapPuller.readInterval(this.pollIntervalStr);
        String compress = (String)initArgs.get("compression");
        this.useInternal = "internal".equals(compress);
        this.useExternal = "external".equals(compress);
        String connTimeout = (String)initArgs.get(HTTP_CONN_TIMEOUT);
        String readTimeout = (String)initArgs.get(HTTP_READ_TIMEOUT);
        String httpBasicAuthUser = (String)initArgs.get(HTTP_BASIC_AUTH_USER);
        String httpBasicAuthPassword = (String)initArgs.get(HTTP_BASIC_AUTH_PASSWORD);
        this.myHttpClient = SnapPuller.createHttpClient(connTimeout, readTimeout);
        if (httpBasicAuthUser != null && httpBasicAuthPassword != null) {
            this.myHttpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(httpBasicAuthUser, httpBasicAuthPassword));
        }
        if (this.pollInterval != null && this.pollInterval > 0) {
            this.startExecutorService();
        } else {
            LOG.info(" No value set for 'pollInterval'. Timer Task not started.");
        }
    }

    private void startExecutorService() {
        Runnable task = new Runnable(){

            public void run() {
                if (SnapPuller.this.pollDisabled.get()) {
                    LOG.info("Poll disabled");
                    return;
                }
                try {
                    SnapPuller.this.executorStartTime = System.currentTimeMillis();
                    SnapPuller.this.replicationHandler.doFetch(null);
                }
                catch (Exception e) {
                    LOG.error("Exception in fetching index", (Throwable)e);
                }
            }
        };
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        long initialDelay = (long)this.pollInterval.intValue() - System.currentTimeMillis() % (long)this.pollInterval.intValue();
        this.executorService.scheduleAtFixedRate(task, initialDelay, this.pollInterval.intValue(), TimeUnit.MILLISECONDS);
        LOG.info("Poll Scheduled at an interval of " + this.pollInterval + "ms");
    }

    NamedList getLatestVersion() throws IOException {
        PostMethod post = new PostMethod(this.masterUrl);
        post.addParameter("command", "indexversion");
        post.addParameter("wt", "javabin");
        return this.getNamedListResponse(post);
    }

    NamedList getCommandResponse(NamedList<String> commands) throws IOException {
        PostMethod post = new PostMethod(this.masterUrl);
        for (Map.Entry<String, String> entry : commands) {
            post.addParameter(entry.getKey(), entry.getValue());
        }
        post.addParameter("wt", "javabin");
        return this.getNamedListResponse(post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedList getNamedListResponse(PostMethod method) throws IOException {
        NamedList namedList;
        try {
            int status = this.myHttpClient.executeMethod((HttpMethod)method);
            if (status != 200) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Request failed for the url " + method);
            }
            namedList = (NamedList)new JavaBinCodec().unmarshal(method.getResponseBodyAsStream());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                method.releaseConnection();
            }
            catch (Exception e) {}
            throw throwable;
        }
        try {
            method.releaseConnection();
        }
        catch (Exception e) {
            // empty catch block
        }
        return namedList;
    }

    void fetchFileList(long version) throws IOException {
        PostMethod post = new PostMethod(this.masterUrl);
        post.addParameter("command", "filelist");
        post.addParameter("indexversion", String.valueOf(version));
        post.addParameter("wt", "javabin");
        NamedList nl = this.getNamedListResponse(post);
        List f = (List)nl.get("filelist");
        if (f != null) {
            this.filesToDownload = Collections.synchronizedList(f);
        } else {
            this.filesToDownload = Collections.emptyList();
            LOG.error("No files to download for indexversion: " + version);
        }
        f = (List)nl.get("confFiles");
        if (f != null) {
            this.confFilesToDownload = Collections.synchronizedList(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean fetchLatestIndex(SolrCore core) throws IOException {
        boolean bl;
        block40: {
            this.replicationStartTime = System.currentTimeMillis();
            try {
                boolean bl2;
                block39: {
                    IndexCommit commit;
                    NamedList response = null;
                    try {
                        response = this.getLatestVersion();
                    }
                    catch (Exception e) {
                        LOG.error("Master at: " + this.masterUrl + " is not available. Index fetch failed. Exception: " + e.getMessage());
                        boolean bl3 = false;
                        Object var18_6 = null;
                        if (!this.successfulInstall) {
                            this.logReplicationTimeAndConfFiles(null, this.successfulInstall);
                        }
                        this.confFilesToDownload = null;
                        this.confFilesDownloaded = null;
                        this.filesDownloaded = null;
                        this.filesToDownload = null;
                        this.replicationStartTime = 0L;
                        this.fileFetcher = null;
                        if (this.fsyncService != null && !this.fsyncService.isShutdown()) {
                            this.fsyncService.shutdownNow();
                        }
                        this.fsyncService = null;
                        this.stop = false;
                        this.fsyncException = null;
                        return bl3;
                    }
                    long latestVersion = (Long)response.get("indexversion");
                    long latestGeneration = (Long)response.get("generation");
                    if (latestVersion == 0L) {
                        boolean bl4 = false;
                        Object var18_7 = null;
                        if (!this.successfulInstall) {
                            this.logReplicationTimeAndConfFiles(null, this.successfulInstall);
                        }
                        this.confFilesToDownload = null;
                        this.confFilesDownloaded = null;
                        this.filesDownloaded = null;
                        this.filesToDownload = null;
                        this.replicationStartTime = 0L;
                        this.fileFetcher = null;
                        if (this.fsyncService != null && !this.fsyncService.isShutdown()) {
                            this.fsyncService.shutdownNow();
                        }
                        this.fsyncService = null;
                        this.stop = false;
                        this.fsyncException = null;
                        return bl4;
                    }
                    RefCounted<SolrIndexSearcher> searcherRefCounted = null;
                    try {
                        searcherRefCounted = core.getNewestSearcher(false);
                        commit = searcherRefCounted.get().getReader().getIndexCommit();
                        Object var10_17 = null;
                        if (searcherRefCounted != null) {
                            searcherRefCounted.decref();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_18 = null;
                        if (searcherRefCounted == null) throw throwable;
                        searcherRefCounted.decref();
                        throw throwable;
                    }
                    if (commit.getVersion() == latestVersion && commit.getGeneration() == latestGeneration) {
                        LOG.info("Slave in sync with master.");
                        boolean bl5 = false;
                        Object var18_8 = null;
                        if (!this.successfulInstall) {
                            this.logReplicationTimeAndConfFiles(null, this.successfulInstall);
                        }
                        this.confFilesToDownload = null;
                        this.confFilesDownloaded = null;
                        this.filesDownloaded = null;
                        this.filesToDownload = null;
                        this.replicationStartTime = 0L;
                        this.fileFetcher = null;
                        if (this.fsyncService != null && !this.fsyncService.isShutdown()) {
                            this.fsyncService.shutdownNow();
                        }
                        this.fsyncService = null;
                        this.stop = false;
                        this.fsyncException = null;
                        return bl5;
                    }
                    LOG.info("Master's version: " + latestVersion + ", generation: " + latestGeneration);
                    LOG.info("Slave's version: " + commit.getVersion() + ", generation: " + commit.getGeneration());
                    LOG.info("Starting replication process");
                    this.fetchFileList(latestVersion);
                    if (this.filesToDownload.isEmpty()) {
                        boolean bl6 = false;
                        Object var18_9 = null;
                        if (!this.successfulInstall) {
                            this.logReplicationTimeAndConfFiles(null, this.successfulInstall);
                        }
                        this.confFilesToDownload = null;
                        this.confFilesDownloaded = null;
                        this.filesDownloaded = null;
                        this.filesToDownload = null;
                        this.replicationStartTime = 0L;
                        this.fileFetcher = null;
                        if (this.fsyncService != null && !this.fsyncService.isShutdown()) {
                            this.fsyncService.shutdownNow();
                        }
                        this.fsyncService = null;
                        this.stop = false;
                        this.fsyncException = null;
                        return bl6;
                    }
                    LOG.info("Number of files in latest index in master: " + this.filesToDownload.size());
                    this.fsyncService = Executors.newSingleThreadExecutor();
                    this.filesDownloaded = Collections.synchronizedList(new ArrayList());
                    boolean isFullCopyNeeded = commit.getGeneration() >= latestGeneration;
                    File tmpIndexDir = this.createTempindexDir(core);
                    if (this.isIndexStale()) {
                        isFullCopyNeeded = true;
                    }
                    this.successfulInstall = false;
                    boolean deleteTmpIdxDir = true;
                    try {
                        File indexDir = new File(core.getIndexDir());
                        this.downloadIndexFiles(isFullCopyNeeded, tmpIndexDir, latestVersion);
                        LOG.info("Total time taken for download : " + (System.currentTimeMillis() - this.replicationStartTime) / 1000L + " secs");
                        Collection<Map<String, Object>> modifiedConfFiles = this.getModifiedConfFiles(this.confFilesToDownload);
                        if (!modifiedConfFiles.isEmpty()) {
                            this.downloadConfFiles(this.confFilesToDownload, latestVersion);
                            if (isFullCopyNeeded) {
                                this.modifyIndexProps(tmpIndexDir.getName());
                            } else {
                                this.successfulInstall = this.copyIndexFiles(tmpIndexDir, indexDir);
                            }
                            if (this.successfulInstall) {
                                LOG.info("Configuration files are modified, core will be reloaded");
                                this.logReplicationTimeAndConfFiles(modifiedConfFiles, this.successfulInstall);
                                this.reloadCore();
                            }
                        } else {
                            this.terminateAndWaitFsyncService();
                            if (isFullCopyNeeded) {
                                this.successfulInstall = this.modifyIndexProps(tmpIndexDir.getName());
                                deleteTmpIdxDir = false;
                            } else {
                                this.successfulInstall = this.copyIndexFiles(tmpIndexDir, indexDir);
                            }
                            if (this.successfulInstall) {
                                this.logReplicationTimeAndConfFiles(modifiedConfFiles, this.successfulInstall);
                                this.doCommit();
                            }
                        }
                        this.replicationStartTime = 0L;
                        bl2 = this.successfulInstall;
                        Object var16_31 = null;
                        if (!deleteTmpIdxDir) break block39;
                    }
                    catch (ReplicationHandlerException e) {
                        try {
                            LOG.error("User aborted Replication");
                            Object var16_32 = null;
                            if (deleteTmpIdxDir) {
                                SnapPuller.delTree(tmpIndexDir);
                            }
                            catch (SolrException e2) {
                                throw e2;
                            }
                            catch (Exception e3) {
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Index fetch failed : ", (Throwable)e3);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_33 = null;
                            if (!deleteTmpIdxDir) throw throwable;
                            SnapPuller.delTree(tmpIndexDir);
                            throw throwable;
                        }
                    }
                    SnapPuller.delTree(tmpIndexDir);
                }
                Object var18_10 = null;
                if (!this.successfulInstall) {
                    this.logReplicationTimeAndConfFiles(null, this.successfulInstall);
                }
                this.confFilesToDownload = null;
                this.confFilesDownloaded = null;
                this.filesDownloaded = null;
                this.filesToDownload = null;
                this.replicationStartTime = 0L;
                this.fileFetcher = null;
                if (this.fsyncService != null && !this.fsyncService.isShutdown()) {
                    this.fsyncService.shutdownNow();
                }
                this.fsyncService = null;
                this.stop = false;
                this.fsyncException = null;
                return bl2;
                bl = this.successfulInstall;
                Object var18_11 = null;
                if (!this.successfulInstall) {
                    this.logReplicationTimeAndConfFiles(null, this.successfulInstall);
                }
                this.confFilesToDownload = null;
                this.confFilesDownloaded = null;
                this.filesDownloaded = null;
                this.filesToDownload = null;
                this.replicationStartTime = 0L;
                this.fileFetcher = null;
                if (this.fsyncService == null || this.fsyncService.isShutdown()) break block40;
                this.fsyncService.shutdownNow();
            }
            catch (Throwable throwable) {
                Object var18_12 = null;
                if (!this.successfulInstall) {
                    this.logReplicationTimeAndConfFiles(null, this.successfulInstall);
                }
                this.confFilesToDownload = null;
                this.confFilesDownloaded = null;
                this.filesDownloaded = null;
                this.filesToDownload = null;
                this.replicationStartTime = 0L;
                this.fileFetcher = null;
                if (this.fsyncService != null && !this.fsyncService.isShutdown()) {
                    this.fsyncService.shutdownNow();
                }
                this.fsyncService = null;
                this.stop = false;
                this.fsyncException = null;
                throw throwable;
            }
        }
        this.fsyncService = null;
        this.stop = false;
        this.fsyncException = null;
        return bl;
    }

    private void terminateAndWaitFsyncService() throws Exception {
        if (this.fsyncService.isTerminated()) {
            return;
        }
        this.fsyncService.shutdown();
        this.fsyncService.awaitTermination(3600L, TimeUnit.SECONDS);
        Exception fsyncExceptionCopy = this.fsyncException;
        if (fsyncExceptionCopy != null) {
            throw fsyncExceptionCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logReplicationTimeAndConfFiles(Collection<Map<String, Object>> modifiedConfFiles, boolean successfulInstall) {
        FileOutputStream outFile = null;
        ArrayList<String> confFiles = new ArrayList<String>();
        if (modifiedConfFiles != null && !modifiedConfFiles.isEmpty()) {
            for (Map<String, Object> map1 : modifiedConfFiles) {
                confFiles.add((String)map1.get("name"));
            }
        }
        Properties props = this.replicationHandler.loadReplicationProperties();
        long replicationTime = System.currentTimeMillis();
        long replicationTimeTaken = (replicationTime - this.getReplicationStartTime()) / 1000L;
        try {
            try {
                int indexCount = 1;
                int confFilesCount = 1;
                if (props.containsKey(TIMES_INDEX_REPLICATED)) {
                    indexCount = Integer.valueOf(props.getProperty(TIMES_INDEX_REPLICATED)) + 1;
                }
                StringBuffer sb = this.readToStringBuffer(replicationTime, props.getProperty(INDEX_REPLICATED_AT_LIST));
                props.setProperty(INDEX_REPLICATED_AT_LIST, sb.toString());
                props.setProperty(INDEX_REPLICATED_AT, String.valueOf(replicationTime));
                props.setProperty(PREVIOUS_CYCLE_TIME_TAKEN, String.valueOf(replicationTimeTaken));
                props.setProperty(TIMES_INDEX_REPLICATED, String.valueOf(indexCount));
                if (modifiedConfFiles != null && !modifiedConfFiles.isEmpty()) {
                    props.setProperty(CONF_FILES_REPLICATED, ((Object)confFiles).toString());
                    props.setProperty(CONF_FILES_REPLICATED_AT, String.valueOf(replicationTime));
                    if (props.containsKey(TIMES_CONFIG_REPLICATED)) {
                        confFilesCount = Integer.valueOf(props.getProperty(TIMES_CONFIG_REPLICATED)) + 1;
                    }
                    props.setProperty(TIMES_CONFIG_REPLICATED, String.valueOf(confFilesCount));
                }
                props.setProperty(LAST_CYCLE_BYTES_DOWNLOADED, String.valueOf(SnapPuller.getTotalBytesDownloaded(this)));
                if (!successfulInstall) {
                    int numFailures = 1;
                    if (props.containsKey(TIMES_FAILED)) {
                        numFailures = Integer.valueOf(props.getProperty(TIMES_FAILED)) + 1;
                    }
                    props.setProperty(TIMES_FAILED, String.valueOf(numFailures));
                    props.setProperty(REPLICATION_FAILED_AT, String.valueOf(replicationTime));
                    sb = this.readToStringBuffer(replicationTime, props.getProperty(REPLICATION_FAILED_AT_LIST));
                    props.setProperty(REPLICATION_FAILED_AT_LIST, sb.toString());
                }
                File f = new File(this.solrCore.getDataDir(), REPLICATION_PROPERTIES);
                outFile = new FileOutputStream(f);
                props.store(outFile, "Replication details");
                outFile.close();
            }
            catch (Exception e) {
                LOG.warn("Exception while updating statistics", (Throwable)e);
                Object var15_16 = null;
                IOUtils.closeQuietly(outFile);
                return;
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            IOUtils.closeQuietly(outFile);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)outFile);
    }

    static long getTotalBytesDownloaded(SnapPuller snappuller) {
        long bytesDownloaded = 0L;
        for (Map<String, Object> file : snappuller.getFilesDownloaded()) {
            bytesDownloaded += ((Long)file.get("size")).longValue();
        }
        for (Map<String, Object> file : snappuller.getConfFilesDownloaded()) {
            bytesDownloaded += ((Long)file.get("size")).longValue();
        }
        Map<String, Object> currentFile = snappuller.getCurrentFile();
        if (currentFile != null && currentFile.containsKey("bytesDownloaded")) {
            bytesDownloaded += ((Long)currentFile.get("bytesDownloaded")).longValue();
        }
        return bytesDownloaded;
    }

    private StringBuffer readToStringBuffer(long replicationTime, String str) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> l = new ArrayList<String>();
        if (str != null && str.length() != 0) {
            String[] ss = str.split(",");
            for (int i = 0; i < ss.length; ++i) {
                l.add(ss[i]);
            }
        }
        sb.append(replicationTime);
        if (!l.isEmpty()) {
            for (int i = 0; (i < l.size() || i < 9) && i != l.size() && i != 9; ++i) {
                String s = (String)l.get(i);
                sb.append(",").append(s);
            }
        }
        return sb;
    }

    private void doCommit() throws IOException {
        CommitUpdateCommand cmd = new CommitUpdateCommand(false);
        cmd.waitFlush = true;
        cmd.waitSearcher = true;
        this.solrCore.getUpdateHandler().commit(cmd);
        if (this.solrCore.getUpdateHandler() instanceof DirectUpdateHandler2) {
            LOG.info("Force open index writer to make sure older index files get deleted");
            DirectUpdateHandler2 handler = (DirectUpdateHandler2)this.solrCore.getUpdateHandler();
            handler.forceOpenWriter();
            this.replicationHandler.refreshCommitpoint();
        } else {
            LOG.warn("The update handler is not an instance or sub-class of DirectUpdateHandler2. ReplicationHandler may not be able to cleanup un-used index files.");
        }
    }

    private File createTempindexDir(SolrCore core) {
        String tmpIdxDirName = "index." + new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
        File tmpIdxDir = new File(core.getDataDir(), tmpIdxDirName);
        tmpIdxDir.mkdirs();
        return tmpIdxDir;
    }

    private void reloadCore() {
        new Thread(){

            public void run() {
                try {
                    SnapPuller.this.solrCore.getCoreDescriptor().getCoreContainer().reload(SnapPuller.this.solrCore.getName());
                }
                catch (Exception e) {
                    LOG.error("Could not restart core ", (Throwable)e);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadConfFiles(List<Map<String, Object>> confFilesToDownload, long latestVersion) throws Exception {
        LOG.info("Starting download of configuration files from master: " + confFilesToDownload);
        this.confFilesDownloaded = Collections.synchronizedList(new ArrayList());
        File tmpconfDir = new File(this.solrCore.getResourceLoader().getConfigDir(), "conf." + this.getDateAsStr(new Date()));
        try {
            boolean status = tmpconfDir.mkdirs();
            if (!status) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create temporary config folder: " + tmpconfDir.getName());
            }
            for (Map<String, Object> file : confFilesToDownload) {
                String saveAs = (String)(file.get("alias") == null ? file.get("name") : file.get("alias"));
                this.fileFetcher = new FileFetcher(tmpconfDir, file, saveAs, true, latestVersion);
                this.currentFile = file;
                this.fileFetcher.fetchFile();
                this.confFilesDownloaded.add(new HashMap<String, Object>(file));
            }
            this.terminateAndWaitFsyncService();
            this.copyTmpConfFiles2Conf(tmpconfDir);
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            SnapPuller.delTree(tmpconfDir);
            throw throwable;
        }
        SnapPuller.delTree(tmpconfDir);
    }

    private void downloadIndexFiles(boolean downloadCompleteIndex, File tmpIdxDir, long latestVersion) throws Exception {
        for (Map<String, Object> file : this.filesToDownload) {
            File localIndexFile = new File(this.solrCore.getIndexDir(), (String)file.get("name"));
            if (!localIndexFile.exists() || downloadCompleteIndex) {
                this.fileFetcher = new FileFetcher(tmpIdxDir, file, (String)file.get("name"), false, latestVersion);
                this.currentFile = file;
                this.fileFetcher.fetchFile();
                this.filesDownloaded.add(new HashMap<String, Object>(file));
                continue;
            }
            LOG.info("Skipping download for " + localIndexFile);
        }
    }

    private boolean isIndexStale() {
        for (Map<String, Object> file : this.filesToDownload) {
            File localIndexFile = new File(this.solrCore.getIndexDir(), (String)file.get("name"));
            if (!localIndexFile.exists() || localIndexFile.length() == ((Long)file.get("size")).longValue()) continue;
            return true;
        }
        return false;
    }

    private boolean copyAFile(File tmpIdxDir, File indexDir, String fname, List<String> copiedfiles) {
        File indexFileInTmpDir = new File(tmpIdxDir, fname);
        File indexFileInIndex = new File(indexDir, fname);
        boolean success = indexFileInTmpDir.renameTo(indexFileInIndex);
        if (!success) {
            LOG.error("Unable to move index file from: " + indexFileInTmpDir + " to: " + indexFileInIndex);
            for (String f : copiedfiles) {
                File indexFile = new File(indexDir, f);
                if (!indexFile.exists()) continue;
                indexFile.delete();
            }
            SnapPuller.delTree(tmpIdxDir);
            return false;
        }
        return true;
    }

    private boolean copyIndexFiles(File tmpIdxDir, File indexDir) throws IOException {
        String segmentsFile = null;
        ArrayList<String> copiedfiles = new ArrayList<String>();
        for (Map<String, Object> f : this.filesDownloaded) {
            String fname = (String)f.get("name");
            if (fname.startsWith("segments_")) {
                segmentsFile = fname;
                continue;
            }
            if (!this.copyAFile(tmpIdxDir, indexDir, fname, copiedfiles)) {
                return false;
            }
            copiedfiles.add(fname);
        }
        return segmentsFile == null || this.copyAFile(tmpIdxDir, indexDir, segmentsFile, copiedfiles);
    }

    private void copyTmpConfFiles2Conf(File tmpconfDir) throws IOException {
        File confDir = new File(this.solrCore.getResourceLoader().getConfigDir());
        for (File file : tmpconfDir.listFiles()) {
            File backupFile;
            boolean status;
            File oldFile = new File(confDir, file.getName());
            if (oldFile.exists() && !(status = oldFile.renameTo(backupFile = new File(confDir, oldFile.getName() + "." + this.getDateAsStr(new Date(oldFile.lastModified())))))) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + oldFile + " to: " + backupFile);
            }
            boolean status2 = file.renameTo(oldFile);
            if (status2) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + file + " to: " + oldFile);
        }
    }

    private String getDateAsStr(Date d) {
        return new SimpleDateFormat("yyyyMMddhhmmss").format(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean modifyIndexProps(String tmpIdxDirName) {
        Properties p;
        File idxprops;
        block10: {
            LOG.info("New index installed. Updating index properties...");
            idxprops = new File(this.solrCore.getDataDir() + "index.properties");
            p = new Properties();
            if (idxprops.exists()) {
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(idxprops);
                        p.load(is);
                    }
                    catch (Exception e) {
                        LOG.error("Unable to load index.properties");
                        Object var7_6 = null;
                        IOUtils.closeQuietly((InputStream)is);
                        break block10;
                    }
                    Object var7_5 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        p.put("index", tmpIdxDirName);
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(idxprops);
                p.store(os, "index properties");
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to write index.properties", (Throwable)e);
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            IOUtils.closeQuietly((OutputStream)os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
        return true;
    }

    private Collection<Map<String, Object>> getModifiedConfFiles(List<Map<String, Object>> confFilesToDownload) {
        if (confFilesToDownload == null || confFilesToDownload.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, Map<String, Object>> nameVsFile = new HashMap<String, Map<String, Object>>();
        NamedList<String> names = new NamedList<String>();
        for (Map<String, Object> map : confFilesToDownload) {
            String name = (String)(map.get("alias") == null ? map.get("name") : map.get("alias"));
            nameVsFile.put(name, map);
            names.add(name, null);
        }
        List<Map<String, Object>> localFilesInfo = this.replicationHandler.getConfFileInfoFromCache(names, this.confFileInfoCache);
        for (Map<String, Object> fileInfo : localFilesInfo) {
            String name = (String)fileInfo.get("name");
            Map m = (Map)nameVsFile.get(name);
            if (m == null || !m.get("checksum").equals(fileInfo.get("checksum"))) continue;
            nameVsFile.remove(name);
        }
        return nameVsFile.isEmpty() ? Collections.EMPTY_LIST : nameVsFile.values();
    }

    static boolean delTree(File dir) {
        if (dir == null || !dir.exists()) {
            return false;
        }
        boolean isSuccess = true;
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (File file : contents) {
                boolean success;
                if (file.isDirectory()) {
                    success = SnapPuller.delTree(file);
                    if (success) continue;
                    LOG.warn("Unable to delete directory : " + file);
                    isSuccess = false;
                    continue;
                }
                success = file.delete();
                if (success) continue;
                LOG.warn("Unable to delete file : " + file);
                isSuccess = false;
                return false;
            }
        }
        return isSuccess && dir.delete();
    }

    void disablePoll() {
        this.pollDisabled.set(true);
        LOG.info("inside disable poll, value of pollDisabled = " + this.pollDisabled);
    }

    void enablePoll() {
        this.pollDisabled.set(false);
        LOG.info("inside enable poll, value of pollDisabled = " + this.pollDisabled);
    }

    void abortPull() {
        this.stop = true;
    }

    long getReplicationStartTime() {
        return this.replicationStartTime;
    }

    List<Map<String, Object>> getConfFilesToDownload() {
        List<Map<String, Object>> tmp = this.confFilesToDownload;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getConfFilesDownloaded() {
        List<Map<String, Object>> tmp = this.confFilesDownloaded;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getFilesToDownload() {
        List<Map<String, Object>> tmp = this.filesToDownload;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getFilesDownloaded() {
        List<Map<String, Object>> tmp = this.filesDownloaded;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    Map<String, Object> getCurrentFile() {
        Map<String, Object> tmp = this.currentFile;
        FileFetcher tmpFileFetcher = this.fileFetcher;
        if (tmp == null) {
            return null;
        }
        tmp = new HashMap<String, Object>(tmp);
        if (tmpFileFetcher != null) {
            tmp.put("bytesDownloaded", tmpFileFetcher.bytesDownloaded);
        }
        return tmp;
    }

    boolean isPollingDisabled() {
        return this.pollDisabled.get();
    }

    Long getNextScheduledExecTime() {
        Long nextTime = null;
        if (this.executorStartTime > 0L) {
            nextTime = this.executorStartTime + (long)this.pollInterval.intValue();
        }
        return nextTime;
    }

    private InputStream checkCompressed(HttpMethod method, InputStream respBody) throws IOException {
        Header contentEncodingHeader = method.getResponseHeader("Content-Encoding");
        if (contentEncodingHeader != null) {
            String contentEncoding = contentEncodingHeader.getValue();
            if (contentEncoding.contains("gzip")) {
                respBody = new GZIPInputStream(respBody);
            } else if (contentEncoding.contains("deflate")) {
                respBody = new InflaterInputStream(respBody);
            }
        } else {
            String contentType;
            Header contentTypeHeader = method.getResponseHeader("Content-Type");
            if (contentTypeHeader != null && (contentType = contentTypeHeader.getValue()) != null) {
                if (contentType.startsWith("application/x-gzip-compressed")) {
                    respBody = new GZIPInputStream(respBody);
                } else if (contentType.startsWith("application/x-deflate")) {
                    respBody = new InflaterInputStream(respBody);
                }
            }
        }
        return respBody;
    }

    static Integer readInterval(String interval) {
        if (interval == null) {
            return null;
        }
        int result = 0;
        if (interval != null) {
            Matcher m = INTERVAL_PATTERN.matcher(interval.trim());
            if (m.find()) {
                String hr = m.group(1);
                String min = m.group(2);
                String sec = m.group(3);
                result = 0;
                try {
                    if (sec != null && sec.length() > 0) {
                        result += Integer.parseInt(sec);
                    }
                    if (min != null && min.length() > 0) {
                        result += 60 * Integer.parseInt(min);
                    }
                    if (hr != null && hr.length() > 0) {
                        result += 3600 * Integer.parseInt(hr);
                    }
                    result *= 1000;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, INTERVAL_ERR_MSG);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, INTERVAL_ERR_MSG);
            }
        }
        return result;
    }

    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    String getMasterUrl() {
        return this.masterUrl;
    }

    String getPollInterval() {
        return this.pollIntervalStr;
    }

    static {
        INTERVAL_PATTERN = Pattern.compile("(\\d*?):(\\d*?):(\\d*)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileFetcher {
        boolean includeChecksum = true;
        private File copy2Dir;
        String fileName;
        String saveAs;
        long size;
        long lastmodified;
        long bytesDownloaded = 0L;
        FileChannel fileChannel;
        private FileOutputStream fileOutputStream;
        byte[] buf = new byte[0x100000];
        Checksum checksum;
        File file;
        int errorCount = 0;
        private boolean isConf;
        private PostMethod post;
        private boolean aborted = false;
        private Long indexVersion;

        FileFetcher(File dir, Map<String, Object> fileDetails, String saveAs, boolean isConf, long latestVersion) throws IOException {
            this.copy2Dir = dir;
            this.fileName = (String)fileDetails.get("name");
            this.size = (Long)fileDetails.get("size");
            this.isConf = isConf;
            this.saveAs = saveAs;
            if (fileDetails.get("lastmodified") != null) {
                this.lastmodified = (Long)fileDetails.get("lastmodified");
            }
            this.indexVersion = latestVersion;
            this.file = new File(this.copy2Dir, saveAs);
            this.fileOutputStream = new FileOutputStream(this.file);
            this.fileChannel = this.fileOutputStream.getChannel();
            if (this.includeChecksum) {
                this.checksum = new Adler32();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void fetchFile() throws Exception {
            try {
                Object var4_3;
                FastInputStream is;
                while (true) {
                    is = this.getStream();
                    int result = this.fetchPackets(is);
                    if (result != 0 && result != 1) break block7;
                    if (this.file.exists() && this.lastmodified > 0L) {
                        this.file.setLastModified(this.lastmodified);
                    }
                    var4_3 = null;
                    break;
                }
                catch (Throwable throwable) {
                    var4_3 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    throw throwable;
                }
                {
                    block7: {
                        IOUtils.closeQuietly((InputStream)is);
                        Object var6_4 = null;
                        this.cleanup();
                        SnapPuller.this.fsyncService.submit(new Runnable(){

                            public void run() {
                                try {
                                    FileUtils.sync(FileFetcher.this.file);
                                }
                                catch (IOException e) {
                                    SnapPuller.this.fsyncException = e;
                                }
                            }
                        });
                        return;
                    }
                    var4_3 = null;
                    IOUtils.closeQuietly((InputStream)is);
                    continue;
                }
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.cleanup();
                SnapPuller.this.fsyncService.submit(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        private int fetchPackets(FastInputStream fis) throws Exception {
            byte[] intbytes = new byte[4];
            byte[] longbytes = new byte[8];
            try {
                while (true) {
                    if (SnapPuller.this.stop) {
                        SnapPuller.this.stop = false;
                        this.aborted = true;
                        throw new ReplicationHandlerException("User aborted replication");
                    }
                    long checkSumServer = -1L;
                    fis.readFully(intbytes);
                    int packetSize = this.readInt(intbytes);
                    if (packetSize <= 0) {
                        LOG.warn("No content recieved for file: " + SnapPuller.this.currentFile);
                        return 1;
                    }
                    if (this.buf.length < packetSize) {
                        this.buf = new byte[packetSize];
                    }
                    if (this.checksum != null) {
                        fis.readFully(longbytes);
                        checkSumServer = this.readLong(longbytes);
                    }
                    fis.readFully(this.buf, 0, packetSize);
                    if (this.includeChecksum) {
                        this.checksum.reset();
                        this.checksum.update(this.buf, 0, packetSize);
                        long checkSumClient = this.checksum.getValue();
                        if (checkSumClient != checkSumServer) {
                            LOG.error("Checksum not matched between client and server for: " + SnapPuller.this.currentFile);
                            return 1;
                        }
                    }
                    this.fileChannel.write(ByteBuffer.wrap(this.buf, 0, packetSize));
                    this.bytesDownloaded += (long)packetSize;
                    if (this.bytesDownloaded >= this.size) {
                        return 0;
                    }
                    this.errorCount = 0;
                }
            }
            catch (ReplicationHandlerException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Error in fetching packets ", (Throwable)e);
                ++this.errorCount;
                if (this.errorCount > 5) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Fetch failed for file:" + this.fileName, (Throwable)e);
                }
                return 2;
            }
        }

        private int readInt(byte[] b) {
            return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        }

        private long readLong(byte[] b) {
            return (long)(b[0] & 0xFF) << 56 | (long)(b[1] & 0xFF) << 48 | (long)(b[2] & 0xFF) << 40 | (long)(b[3] & 0xFF) << 32 | (long)(b[4] & 0xFF) << 24 | (long)((b[5] & 0xFF) << 16) | (long)((b[6] & 0xFF) << 8) | (long)(b[7] & 0xFF);
        }

        private void cleanup() {
            try {
                this.fileOutputStream.close();
            }
            catch (Exception e) {
                LOG.error("Error closing the file stream: " + this.saveAs, (Throwable)e);
            }
            try {
                this.post.releaseConnection();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.bytesDownloaded != this.size) {
                try {
                    this.file.delete();
                }
                catch (Exception e) {
                    LOG.error("Error deleting file in cleanup" + e.getMessage());
                }
                if (!this.aborted) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to download " + this.fileName + " completely. Downloaded " + this.bytesDownloaded + "!=" + this.size);
                }
            }
        }

        FastInputStream getStream() throws IOException {
            this.post = new PostMethod(SnapPuller.this.masterUrl);
            this.post.addParameter("command", "filecontent");
            this.post.addParameter("indexversion", this.indexVersion.toString());
            if (this.isConf) {
                this.post.addParameter("cf", this.fileName);
            } else {
                this.post.addParameter("file", this.fileName);
            }
            if (SnapPuller.this.useInternal) {
                this.post.addParameter("compression", "true");
            }
            if (SnapPuller.this.useExternal) {
                this.post.setRequestHeader(new Header("Accept-Encoding", "gzip,deflate"));
            }
            if (this.includeChecksum) {
                this.post.addParameter("checksum", "true");
            }
            this.post.addParameter("wt", "filestream");
            if (this.bytesDownloaded > 0L) {
                this.post.addParameter("offset", "" + this.bytesDownloaded);
            }
            SnapPuller.this.myHttpClient.executeMethod((HttpMethod)this.post);
            InputStream is = this.post.getResponseBodyAsStream();
            if (SnapPuller.this.useInternal) {
                is = new InflaterInputStream(is);
            } else if (SnapPuller.this.useExternal) {
                is = SnapPuller.this.checkCompressed((HttpMethod)this.post, is);
            }
            return new FastInputStream(is);
        }
    }

    private static class ReplicationHandlerException
    extends InterruptedException {
        public ReplicationHandlerException(String message) {
            super(message);
        }
    }
}

