/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.webapp.mgt.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployer;
import org.wso2.carbon.webapp.mgt.DataHolder;
import org.wso2.carbon.webapp.mgt.TomcatGenericWebappsDeployer;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.WebContextParameter;

public class GhostWebappDeployerUtils {
    private static final Log log = LogFactory.getLog(GhostWebappDeployerUtils.class);
    private static final String ENABLE_GHOST_DEPLOYER = "EnableGhostDeployer";
    private static final String TRANSIT_GHOST_WEBAPP_MAP = "TransitGhostWebappMap";

    private GhostWebappDeployerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebApplication deployActualWebApp(WebApplication ghostWebapp, ConfigurationContext configurationContext) {
        WebApplication newWebApp = null;
        String string = ghostWebapp.getContextName().intern();
        synchronized (string) {
            WebApplicationsHolder webappsHolder = (WebApplicationsHolder)configurationContext.getProperty("carbon.webapps.holder");
            if (webappsHolder != null) {
                WebApplication deployedWebapp = webappsHolder.getStartedWebapps().get(ghostWebapp.getWebappFile().getName());
                if (deployedWebapp == null) {
                    return null;
                }
                String ghostParam = String.valueOf(deployedWebapp.getProperty("GhostWebApp"));
                if ("false".equals(ghostParam)) {
                    newWebApp = deployedWebapp;
                } else {
                    GhostDeployer ghostDeployer = GhostWebappDeployerUtils.getGhostDeployer(configurationContext.getAxisConfiguration());
                    if (ghostDeployer == null) {
                        return null;
                    }
                    DeploymentFileData dfd = ghostDeployer.getFileData(deployedWebapp.getWebappFile().getPath());
                    if (dfd != null) {
                        log.info((Object)("Removing Ghost webapp and loading actual webapp : " + deployedWebapp.getWebappFile().getName()));
                        try {
                            Map<String, WebApplication> transitGhostList = GhostWebappDeployerUtils.getTransitGhostWebAppsMap(configurationContext);
                            transitGhostList.put(deployedWebapp.getContextName(), deployedWebapp);
                            webappsHolder.undeployWebapp(deployedWebapp);
                            TomcatGenericWebappsDeployer tomcatWebappDeployer = (TomcatGenericWebappsDeployer)configurationContext.getProperty("tomcatGenericWebappsDeplyer");
                            WebContextParameter serverUrlParam = new WebContextParameter("webServiceServerURL", CarbonUtils.getServerURL((ServerConfigurationService)ServerConfiguration.getInstance(), (ConfigurationContext)configurationContext));
                            ArrayList servletContextParameters = (ArrayList)configurationContext.getProperty("servlet.context.parameters.list");
                            if (servletContextParameters != null) {
                                servletContextParameters.add(serverUrlParam);
                            }
                            ArrayList<Object> listeners = new ArrayList<Object>(1);
                            tomcatWebappDeployer.deploy(dfd.getFile(), servletContextParameters, listeners);
                            newWebApp = webappsHolder.getStartedWebapps().get(dfd.getFile().getName());
                            newWebApp.setProperty("GhostWebApp", "false");
                            if (dfd.getAbsolutePath().contains("jaxwebapps")) {
                                newWebApp.setProperty("webappFilter", "jaxWebapp");
                            }
                            newWebApp.setIsGhostWebapp(false);
                            transitGhostList.remove(newWebApp.getContextName());
                        }
                        catch (CarbonException e) {
                            log.error((Object)("Error while loading actual webapp : " + deployedWebapp.getWebappFile().getName()), (Throwable)e);
                        }
                    }
                }
                GhostWebappDeployerUtils.updateLastUsedTime(newWebApp);
            }
        }
        return newWebApp;
    }

    public static void updateLastUsedTime(WebApplication webApplication) {
        if (webApplication == null) {
            return;
        }
        try {
            webApplication.setProperty("lastUsedTime", String.valueOf(System.currentTimeMillis()));
        }
        catch (Exception e) {
            log.error((Object)("Error while updating lastUsedTime parameter in webapp : " + webApplication.getContextName()), (Throwable)e);
        }
    }

    public static GhostDeployer getGhostDeployer(AxisConfiguration axisConfig) {
        GhostDeployer ghostDeployer = null;
        Parameter param = axisConfig.getParameter("ghostDeployer");
        if (param != null) {
            return (GhostDeployer)param.getValue();
        }
        return ghostDeployer;
    }

    public static boolean isGhostOn() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String ghostOn = serverConfig.getFirstProperty(ENABLE_GHOST_DEPLOYER);
        return ghostOn != null && Boolean.parseBoolean(ghostOn);
    }

    public static synchronized Map<String, WebApplication> getTransitGhostWebAppsMap(ConfigurationContext cfgContext) {
        HashMap transitMap = null;
        transitMap = (HashMap)cfgContext.getProperty(TRANSIT_GHOST_WEBAPP_MAP);
        if (transitMap == null) {
            transitMap = new HashMap();
            cfgContext.setProperty(TRANSIT_GHOST_WEBAPP_MAP, transitMap);
        }
        return transitMap;
    }

    public static WebApplication dispatchWebAppFromTransitGhosts(String requestURI, ConfigurationContext cfgContext) {
        WebApplication actualWebapp = null;
        Map<String, WebApplication> transitGhostMap = GhostWebappDeployerUtils.getTransitGhostWebAppsMap(cfgContext);
        if (requestURI != null) {
            int index = requestURI.indexOf(46);
            if (index != -1) {
                requestURI = requestURI.substring(0, index);
            }
            String[] parts = requestURI.split("/");
            String tmpWebappContextName = "";
            for (int count = 0; actualWebapp == null && count < parts.length && count < 10; ++count) {
                String string = tmpWebappContextName = count == 0 ? tmpWebappContextName + parts[count] : tmpWebappContextName + "/" + parts[count];
                if (!transitGhostMap.containsKey(tmpWebappContextName)) continue;
                actualWebapp = transitGhostMap.get(tmpWebappContextName);
            }
        }
        return actualWebapp;
    }

    public static void waitForWebAppToLeaveTransit(String contextName, ConfigurationContext cfgContext) {
        Map<String, WebApplication> transitGhostMap = GhostWebappDeployerUtils.getTransitGhostWebAppsMap(cfgContext);
        while (transitGhostMap.containsKey(contextName)) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static boolean isGhostWebApp(WebApplication webApplication) {
        if (webApplication == null) {
            return false;
        }
        String ghostParam = (String)webApplication.getProperty("GhostWebApp");
        return ghostParam != null && "true".equals(ghostParam);
    }

    public static WebApplication createGhostWebApp(File ghostFile, File originalFile, AxisConfiguration axisConfig) {
        OMElement webAppElm;
        WebApplication ghostWebApp = null;
        try {
            FileInputStream xmlInputStream = new FileInputStream(ghostFile);
            webAppElm = new StAXOMBuilder((InputStream)xmlInputStream).getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)("Error while parsing ghost XML file : " + ghostFile.getAbsolutePath()));
            return null;
        }
        try {
            String dummyContextPath;
            File dummyCtxFolder;
            String filterProp;
            String activeSessions;
            String lastModifiedTime;
            String webAppFile;
            String contextName = webAppElm.getAttributeValue(new QName("name"));
            StandardContext context = new StandardContext();
            context.setName(contextName);
            context.setPath(contextName);
            ghostWebApp = new WebApplication((Context)context, originalFile);
            ghostWebApp.setProperty("GhostWebApp", "true");
            ghostWebApp.setIsGhostWebapp(true);
            String displayName = webAppElm.getAttributeValue(new QName("displayName"));
            if (displayName != null) {
                ghostWebApp.setDisplayName(displayName);
            }
            if ((webAppFile = webAppElm.getAttributeValue(new QName("file"))) != null) {
                // empty if block
            }
            if ((lastModifiedTime = webAppElm.getAttributeValue(new QName("lastModifiedTime"))) != null) {
                ghostWebApp.setLastModifiedTime(Long.parseLong(lastModifiedTime));
            }
            if ((activeSessions = webAppElm.getAttributeValue(new QName("sessions"))) != null) {
                // empty if block
            }
            if ((filterProp = webAppElm.getAttributeValue(new QName("webappFilter"))) != null) {
                ghostWebApp.setProperty("webappFilter", filterProp);
            }
            if (!(dummyCtxFolder = new File(dummyContextPath = GhostWebappDeployerUtils.getDummyContextDirectoryPath(contextName, axisConfig))).exists() && !dummyCtxFolder.mkdir()) {
                log.error((Object)("Error while creating dummy context folder at : " + dummyContextPath));
                return null;
            }
            if (dummyContextPath != null) {
                Host host = DataHolder.getCarbonTomcatService().getTomcat().getHost();
                context.setDocBase(dummyContextPath);
                ContextConfig ctxCfg = new ContextConfig();
                context.addLifecycleListener((LifecycleListener)ctxCfg);
                host.addChild((Container)context);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error while creating Ghost Webapp from Ghost File : " + ghostFile.getAbsolutePath()), (Throwable)e);
        }
        return ghostWebApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeWebApp(WebApplication webApplication, AxisConfiguration axisConfig, String webappPath) {
        String tenantTmpDirPath;
        String sessions;
        String lastModifiedTime;
        String file;
        String displayName;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement webappEle = omFactory.createOMElement(new QName("webApplication"));
        webappEle.addAttribute("name", webApplication.getContext().getName(), null);
        String contextPath = webApplication.getContextName();
        if (contextPath != null) {
            webappEle.addAttribute("contextPath", contextPath, null);
        }
        if ((displayName = webApplication.getDisplayName()) != null) {
            webappEle.addAttribute("displayName", displayName, null);
        }
        if ((file = webApplication.getWebappFile().getName()) != null) {
            webappEle.addAttribute("file", file, null);
        }
        if ((lastModifiedTime = String.valueOf(webApplication.getLastModifiedTime())) != null) {
            webappEle.addAttribute("lastModifiedTime", lastModifiedTime, null);
        }
        if ((sessions = String.valueOf(webApplication.getStatistics().getActiveSessions())) != null) {
            webappEle.addAttribute("sessions", sessions, null);
        }
        if (webappPath.contains("jaxwebapps")) {
            webappEle.addAttribute("webappFilter", "jaxWebapp", null);
        }
        if ((tenantTmpDirPath = CarbonUtils.getTenantTmpDirPath((AxisConfiguration)axisConfig)) == null) {
            return;
        }
        String ghostPath = tenantTmpDirPath + File.separator + "ghostWebapps";
        File ghostFolder = new File(ghostPath);
        if (!ghostFolder.exists() && !ghostFolder.mkdir()) {
            log.error((Object)("Error while creating ghostWebapps folder at : " + ghostPath));
            return;
        }
        FileOutputStream fos = null;
        try {
            File serviceFile = new File(ghostPath + File.separator + GhostWebappDeployerUtils.calculateGhostFileName(webappPath, axisConfig.getRepository().getPath()));
            fos = new FileOutputStream(serviceFile);
            webappEle.serialize((OutputStream)fos);
            fos.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error while serializing OMElement for Ghost Webapp", (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error while closing the file output stream", (Throwable)e);
                }
            }
        }
    }

    public static File getGhostFile(String fileName, AxisConfiguration axisConfig) {
        String tenantTmpDirPath = CarbonUtils.getTenantTmpDirPath((AxisConfiguration)axisConfig);
        if (tenantTmpDirPath == null) {
            return null;
        }
        return new File(tenantTmpDirPath + File.separator + "ghostWebapps" + File.separator + GhostWebappDeployerUtils.calculateGhostFileName(fileName, axisConfig.getRepository().getPath()));
    }

    public static String calculateGhostFileName(String fileName, String repoPath) {
        String ghostFileName = null;
        if (fileName != null && fileName.startsWith(repoPath)) {
            ghostFileName = fileName.substring(repoPath.length());
            if (ghostFileName.lastIndexOf(46) != -1) {
                ghostFileName = ghostFileName.substring(0, ghostFileName.lastIndexOf(46));
            }
            if (File.separatorChar == '\\') {
                ghostFileName = ghostFileName.replace('\\', '/');
            }
            ghostFileName = ghostFileName.replace('/', '_');
            ghostFileName = ghostFileName + ".xml";
        }
        return ghostFileName;
    }

    public static WebApplication findDeployedWebapp(ConfigurationContext configurationContext, String webappPath) {
        try {
            WebApplicationsHolder webApplicationsHolder = (WebApplicationsHolder)configurationContext.getProperty("carbon.webapps.holder");
            if (webApplicationsHolder != null) {
                for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
                    if (!webApplication.getWebappFile().getAbsolutePath().equals(webappPath)) continue;
                    return webApplication;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving the webapp from webappsHolder..", (Throwable)e);
        }
        return null;
    }

    public static String getDummyContextDirectoryPath(String contextName, AxisConfiguration axisConfig) {
        if (contextName.contains("/t/")) {
            String tenantCtx = "/t/" + TenantAxisUtils.getTenantDomain((String)contextName) + File.separator + "webapps";
            contextName = contextName.substring(tenantCtx.length());
        }
        String tenantTmpDirPath = CarbonUtils.getTenantTmpDirPath((AxisConfiguration)axisConfig);
        return tenantTmpDirPath + File.separator + "ghostWebapps" + File.separator + contextName;
    }

    public static File getDummyContextFile(String fileName, AxisConfiguration axisConfig) {
        File dummyContextFile = null;
        String dummyContextName = null;
        String repoPath = axisConfig.getRepository().getPath();
        if (fileName != null && fileName.startsWith(repoPath)) {
            dummyContextName = fileName.substring((repoPath + File.separator + "webapps").length());
            if (dummyContextName.lastIndexOf(46) != -1) {
                dummyContextName = dummyContextName.substring(0, dummyContextName.lastIndexOf(46));
            }
            if (File.separatorChar == '\\') {
                dummyContextName = dummyContextName.replace('\\', '/');
            }
            String tenantTmpDirPath = CarbonUtils.getTenantTmpDirPath((AxisConfiguration)axisConfig);
            dummyContextFile = new File(tenantTmpDirPath + File.separator + "ghostWebapps" + File.separator + dummyContextName);
        }
        return dummyContextFile;
    }
}

